/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.entity;

import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import kd.bos.archive.ArchiveConfigUtil;

public class ArchiveCascadeConfigEntity {
    private long id;
    private String entitynumber;
    private String parentnumber;
    private String joinfield;
    private ArchiveCascadeConfigEntity parentCascadeConfig;
    private List<ArchiveCascadeConfigEntity> cascadeConfigList = null;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getEntitynumber() {
        return this.entitynumber;
    }

    public void setEntitynumber(String entitynumber) {
        this.entitynumber = entitynumber;
    }

    public String getParentnumber() {
        return this.parentnumber;
    }

    public void setParentnumber(String parentnumber) {
        this.parentnumber = parentnumber;
    }

    public String getJoinfield() {
        return this.joinfield;
    }

    public void setJoinfield(String joinfield) {
        this.joinfield = joinfield;
    }

    public boolean isRoot() {
        return Objects.isNull(this.parentnumber) || this.parentnumber.trim().length() == 0;
    }

    public ArchiveCascadeConfigEntity getParentCascadeConfig() {
        return this.parentCascadeConfig;
    }

    public void setParentCascadeConfig(ArchiveCascadeConfigEntity parentCascadeConfig) {
        this.parentCascadeConfig = parentCascadeConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ArchiveCascadeConfigEntity> toArchiveCascadeConfigs() {
        ArchiveCascadeConfigEntity archiveCascadeConfigEntity = this;
        synchronized (archiveCascadeConfigEntity) {
            if (this.cascadeConfigList == null) {
                this.cascadeConfigList = ArchiveConfigUtil.toArchiveCascadeConfigs(this);
            }
        }
        return this.cascadeConfigList;
    }

    public TreeSet<ArchiveCascadeConfigEntity> getSortExpandConfigs(List<ArchiveCascadeConfigEntity> expandConfigList) {
        TreeSet<ArchiveCascadeConfigEntity> sortKey = new TreeSet<ArchiveCascadeConfigEntity>((o1, o2) -> {
            int level1 = 0;
            ArchiveCascadeConfigEntity t01 = o1;
            while (!t01.isRoot()) {
                ++level1;
                t01 = t01.getParentCascadeConfig();
            }
            int level2 = 0;
            ArchiveCascadeConfigEntity t02 = o2;
            while (!t02.isRoot()) {
                ++level2;
                t02 = t02.getParentCascadeConfig();
            }
            if (level1 == level2) {
                return o1.getEntitynumber().compareToIgnoreCase(o2.getEntitynumber());
            }
            return level1 - level2;
        });
        for (ArchiveCascadeConfigEntity ecpandConfig : expandConfigList) {
            sortKey.add(ecpandConfig);
        }
        return sortKey;
    }
}

