/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.entity;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import kd.bos.archive.ArchiveConfigUtil;
import kd.bos.archive.enums.ArchiveConfigFilterTypeEnum;
import kd.bos.archive.enums.ArchiveConfigMovingTypeEnum;
import kd.bos.db.archive.ArchiveRouteType;
import kd.bos.db.archive.LogicArchiveRoute;
import kd.bos.db.archive.config.ArchiveConfig;
import kd.bos.db.archive.config.ChildrenArchiveConfig;

public class ArchiveConfigEntity {
    private long id;
    private String entitynumber;
    private String condition;
    private String targetType;
    private String region;
    private String archiveRoute;
    private String logicSuffix = "";
    private int suffix;
    private ArchiveConfigFilterTypeEnum filterType;
    private ArchiveConfigMovingTypeEnum movingType;
    private ArchiveRouteType routeType;
    private String archivePlugin;
    private List<ArchiveConfig> archiveConfigs = null;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getEntitynumber() {
        return this.entitynumber;
    }

    public void setEntitynumber(String entitynumber) {
        this.entitynumber = entitynumber;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getArchiveRoute() {
        return this.archiveRoute;
    }

    public void setArchiveRoute(String archiveRoute) {
        LogicArchiveRoute logicArchiveRoute = LogicArchiveRoute.of((String)archiveRoute);
        this.archiveRoute = logicArchiveRoute.getRealArchiveKey();
        this.logicSuffix = logicArchiveRoute.getLogicSuffix();
    }

    public String getLogicSuffix() {
        return this.logicSuffix;
    }

    public void setLogicSuffix(String logicSuffix) {
        this.logicSuffix = logicSuffix;
    }

    public int getSuffix() {
        return this.suffix;
    }

    public void setSuffix(int suffix) {
        this.suffix = suffix;
    }

    public ArchiveConfigFilterTypeEnum getFilterType() {
        return this.filterType;
    }

    public void setFilterType(ArchiveConfigFilterTypeEnum filterType) {
        this.filterType = filterType;
    }

    public ArchiveConfigMovingTypeEnum getMovingType() {
        return this.movingType;
    }

    public void setMovingType(ArchiveConfigMovingTypeEnum movingType) {
        this.movingType = movingType;
    }

    public ArchiveRouteType getRouteType() {
        return this.routeType;
    }

    public void setRouteType(ArchiveRouteType routeType) {
        this.routeType = routeType;
    }

    public String getArchivePlugin() {
        return this.archivePlugin;
    }

    public void setArchivePlugin(String archivePlugin) {
        this.archivePlugin = archivePlugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ArchiveConfig> toArchiveConfigs() {
        if (this.archiveConfigs == null) {
            ArchiveConfigEntity archiveConfigEntity = this;
            synchronized (archiveConfigEntity) {
                if (this.archiveConfigs == null) {
                    this.archiveConfigs = ArchiveConfigUtil.toArchiveConfigs(this.entitynumber, this.archiveRoute, this.logicSuffix);
                }
            }
        }
        return this.archiveConfigs;
    }

    public Multimap<ArchiveConfig, ArchiveConfig> getGroupConfigs(List<ArchiveConfig> shardingConfigs) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        for (ArchiveConfig ac : shardingConfigs) {
            if (ArchiveConfigUtil.isLangOrGroupTableDBConfig(ac) || ArchiveConfigUtil.isLkTableDBConfig(ac)) {
                multimap.put((Object)((ChildrenArchiveConfig)ac).getParent(), (Object)ac);
                continue;
            }
            multimap.put((Object)ac, (Object)ac);
        }
        return multimap;
    }

    public Map<String, ArchiveConfig> getReverseKeyConfigs(Multimap<ArchiveConfig, ArchiveConfig> multimap) {
        Map map = multimap.asMap();
        HashMap<String, ArchiveConfig> reverseKeyMap = new HashMap<String, ArchiveConfig>();
        for (Map.Entry entry : map.entrySet()) {
            ArchiveConfig key = (ArchiveConfig)entry.getKey();
            for (ArchiveConfig value : (Collection)entry.getValue()) {
                reverseKeyMap.put(value.getTable(), key);
            }
        }
        return reverseKeyMap;
    }

    public TreeSet<ArchiveConfig> getSortConfigKey(Multimap<ArchiveConfig, ArchiveConfig> multimap) {
        TreeSet<ArchiveConfig> sortKey = new TreeSet<ArchiveConfig>((o1, o2) -> {
            int level1 = 0;
            if (o1 instanceof ChildrenArchiveConfig) {
                ArchiveConfig t01 = o1;
                while (t01 instanceof ChildrenArchiveConfig) {
                    ++level1;
                    t01 = ((ChildrenArchiveConfig)t01).getParent();
                }
            }
            int level2 = 0;
            if (o2 instanceof ChildrenArchiveConfig) {
                ArchiveConfig t02 = o2;
                while (t02 instanceof ChildrenArchiveConfig) {
                    ++level2;
                    t02 = ((ChildrenArchiveConfig)t02).getParent();
                }
            }
            if (level1 == level2) {
                return o1.getTable().compareToIgnoreCase(o2.getTable());
            }
            return level1 - level2;
        });
        Map map = multimap.asMap();
        for (Map.Entry entry : map.entrySet()) {
            sortKey.add((ArchiveConfig)entry.getKey());
        }
        return sortKey;
    }
}

