/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.operationcollect;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.archive.entity.ArchiveConfigEntity;
import kd.bos.archive.enums.ArchiveConfigMovingTypeEnum;
import kd.bos.archive.enums.ArchiveTaskTypeEnum;
import kd.bos.archive.repository.ArchiveConfigRepository;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.DBArchiveRuntime;
import kd.bos.operationcollect.CbsOperationCollectService;
import kd.bos.operationcollect.CollectInfo;
import kd.bos.util.JSONUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveServiceOperationCollect
implements CbsOperationCollectService {
    Logger log = LoggerFactory.getLogger((String)"Archive");
    private static final String querySql = "select fid from t_cbs_archi_schema where fenable = '1'";

    public List<CollectInfo> collect() {
        ArrayList<CollectInfo> collectInfoList = new ArrayList<CollectInfo>(2);
        CollectInfo collectInfo = new CollectInfo();
        collectInfo.setBusinessScene("Archive");
        HashMap<String, String> collectDataMap = new HashMap<String, String>(2);
        boolean archiveEnable = DBArchiveRuntime.get().getArchiveAccountEnable();
        collectDataMap.put("archiveEnable", String.valueOf(archiveEnable));
        ArrayList configMapList = new ArrayList(1);
        if (archiveEnable) {
            ArrayList schemaIds = new ArrayList(1);
            DB.query((DBRoute)DBRoute.basedata, (String)querySql, rs -> {
                while (rs.next()) {
                    schemaIds.add(rs.getLong(1));
                }
                return null;
            });
            for (Long schemaId : schemaIds) {
                List<ArchiveConfigEntity> scheduleConfigList = ArchiveConfigRepository.get().loadScheduleConfigList(schemaId);
                for (ArchiveConfigEntity config : scheduleConfigList) {
                    ArchiveTaskTypeEnum taskTypeEnum;
                    HashMap<String, String> configMap = new HashMap<String, String>(2);
                    configMap.put("entitynumber", config.getEntitynumber());
                    if (ArchiveConfigMovingTypeEnum.CLEAR == config.getMovingType()) {
                        taskTypeEnum = ArchiveTaskTypeEnum.DATACLEAN;
                    } else if (ArchiveConfigMovingTypeEnum.SYNC == config.getMovingType()) {
                        taskTypeEnum = ArchiveTaskTypeEnum.ARCHIVESYNC;
                        configMap.put("targetType", config.getTargetType());
                    } else {
                        taskTypeEnum = ArchiveTaskTypeEnum.ARCHIVE;
                    }
                    configMap.put("taskType", taskTypeEnum.getKey());
                    configMapList.add(configMap);
                }
            }
        }
        try {
            collectDataMap.put("archiveConfigs", JSONUtils.toString(configMapList));
        }
        catch (IOException e) {
            this.log.error("ArchiveServiceOperationCollect collectDataMap toString error", (Throwable)e);
        }
        collectInfo.setData(collectDataMap);
        collectInfoList.add(collectInfo);
        return collectInfoList;
    }
}

