/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.repository.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveBasedataEntity;
import kd.bos.archive.repository.ArchiveBasedataRepository;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;

public class ArchiveBasedataRepositoryImpl
implements ArchiveBasedataRepository {
    public static final ArchiveBasedataRepositoryImpl instance = new ArchiveBasedataRepositoryImpl();

    @Override
    public List<ArchiveBasedataEntity> loadArchiveBasedataList(String condition, List<Object> paramList) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select ");
        sql.append(" fid,fentitynumber,farchiveroute,fcreatetime ");
        sql.append(" from t_cbs_archi_basedata  ");
        if (condition != null) {
            sql.append(" where ").append(condition);
        }
        return (List)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])(paramList == null ? null : paramList.toArray()), rs -> {
            ArrayList<ArchiveBasedataEntity> ret = new ArrayList<ArchiveBasedataEntity>(100);
            while (rs.next()) {
                ArchiveBasedataEntity entityrcd = new ArchiveBasedataEntity();
                entityrcd.setId(rs.getLong(1));
                entityrcd.setEntitynumber(rs.getString(2));
                entityrcd.setArchiveRoute(rs.getString(3));
                entityrcd.setCreatetime(rs.getTimestamp(4));
                ret.add(entityrcd);
            }
            return ret;
        });
    }

    @Override
    public ArchiveBasedataEntity loadArchiveBasedata(long entityrcdId) {
        String condition = " fid = ? ";
        ArrayList<Object> paramList = new ArrayList<Object>(1);
        paramList.add(entityrcdId);
        List<ArchiveBasedataEntity> ret = this.loadArchiveBasedataList(condition, paramList);
        return ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public List<String> loadArchivBasedata(String entityNumber) {
        String condition = " fentitynumber = ?";
        ArrayList<Object> paramList = new ArrayList<Object>(1);
        paramList.add(entityNumber);
        List<ArchiveBasedataEntity> ret = this.loadArchiveBasedataList(condition, paramList);
        return ret.isEmpty() ? null : ret.stream().map(ArchiveBasedataEntity::getArchiveRoute).collect(Collectors.toList());
    }

    @Override
    public ArchiveBasedataEntity loadArchiveBasedata(String entityNumber, String archiveRoute) {
        String condition = " fentitynumber = ? and farchiveroute = ?";
        ArrayList<Object> paramList = new ArrayList<Object>(2);
        paramList.add(entityNumber);
        paramList.add(archiveRoute);
        List<ArchiveBasedataEntity> ret = this.loadArchiveBasedataList(condition, paramList);
        return ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public boolean checkBasedataExist(String entityNumber, String archiveRoute) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select count(*) from t_cbs_archi_basedata ");
        sql.append(" where  fentitynumber = ? and farchiveroute = ? ");
        ArrayList<String> paramList = new ArrayList<String>(2);
        paramList.add(entityNumber);
        paramList.add(archiveRoute);
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])paramList.toArray(), rs -> {
            if (rs.next() && rs.getLong(1) > 0L) {
                return true;
            }
            return false;
        });
    }

    @Override
    public void insertBasedata(String entityNumber, String archiveRoute) {
        StringBuilder sql = new StringBuilder();
        sql.append(" insert into t_cbs_archi_basedata(");
        sql.append(" fid,fentitynumber,farchiveroute,fcreatetime ");
        sql.append(" ) values( ");
        sql.append(" ?,?,?,? ");
        sql.append(" ) ");
        Object[] obj = new Object[]{ID.genLongId(), entityNumber, archiveRoute, new Date()};
        DB.execute((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), (Object[])obj);
    }
}

