/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.repository.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.archive.entity.ArchiveBillSetEntity;
import kd.bos.archive.repository.ArchiveBillSetRepository;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;

public class ArchiveBillSetRepositoryImpl
implements ArchiveBillSetRepository {
    public static final ArchiveBillSetRepositoryImpl instance = new ArchiveBillSetRepositoryImpl();

    @Override
    public List<ArchiveBillSetEntity> loadBillSetList(String condition, List<Object> paramList) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select ");
        sql.append(" fid,fentitynumber,fis_store,fis_clean,fpreset,fcreatetime ");
        sql.append(" from t_cbs_archi_billset  ");
        if (condition != null) {
            sql.append(" where ").append(condition);
        }
        return (List)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])(paramList == null ? null : paramList.toArray()), rs -> {
            ArrayList<ArchiveBillSetEntity> ret = new ArrayList<ArchiveBillSetEntity>(100);
            while (rs.next()) {
                ArchiveBillSetEntity entity = new ArchiveBillSetEntity();
                entity.setId(rs.getLong("fid"));
                entity.setEntitynumber(rs.getString("fentitynumber"));
                entity.setStore(rs.getBoolean("fis_store"));
                entity.setClean(rs.getBoolean("fis_clean"));
                entity.setPreset(rs.getBoolean("fpreset"));
                entity.setCreatetime(rs.getTimestamp("fcreatetime"));
                ret.add(entity);
            }
            return ret;
        });
    }

    @Override
    public ArchiveBillSetEntity loadBillSetEntity(long fId) {
        String condition = " fid = ? ";
        ArrayList<Object> paramList = new ArrayList<Object>(1);
        paramList.add(fId);
        List<ArchiveBillSetEntity> ret = this.loadBillSetList(condition, paramList);
        return ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public ArchiveBillSetEntity loadBillSetEntity(String entityNumber) {
        String condition = " fentitynumber = ?";
        ArrayList<Object> paramList = new ArrayList<Object>(1);
        paramList.add(entityNumber);
        List<ArchiveBillSetEntity> ret = this.loadBillSetList(condition, paramList);
        return ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public boolean checkEntityExist(String entityNumber) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select count(*) from t_cbs_archi_billset ");
        sql.append(" where  fentitynumber = ? ");
        ArrayList<String> paramList = new ArrayList<String>(1);
        paramList.add(entityNumber);
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])paramList.toArray(), rs -> {
            if (rs.next() && rs.getLong(1) > 0L) {
                return true;
            }
            return false;
        });
    }
}

