/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.repository.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.entity.ArchiveCascadeConfigEntity;
import kd.bos.archive.repository.ArchiveCascadeConfigRepository;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;

public class ArchiveCascadeConfigRepositoryImpl
implements ArchiveCascadeConfigRepository,
ArchiveLogable {
    public static final ArchiveCascadeConfigRepositoryImpl instance = new ArchiveCascadeConfigRepositoryImpl();

    @Override
    public List<ArchiveCascadeConfigEntity> loadCascadeConfigList(String condition, List<Object> paramList) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select ");
        sql.append(" fid,fentitynumber,fparentnumber,fjoinfield ");
        sql.append(" from t_cbs_archi_cascade ");
        if (condition != null) {
            sql.append(" where ").append(condition);
        }
        return (List)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])(paramList == null ? null : paramList.toArray()), rs -> {
            ArrayList<ArchiveCascadeConfigEntity> ret = new ArrayList<ArchiveCascadeConfigEntity>(100);
            while (rs.next()) {
                ArchiveCascadeConfigEntity cascadeConfigEntity = new ArchiveCascadeConfigEntity();
                cascadeConfigEntity.setId(rs.getLong("fid"));
                cascadeConfigEntity.setEntitynumber(rs.getString("fentitynumber"));
                cascadeConfigEntity.setParentnumber(rs.getString("fparentnumber"));
                cascadeConfigEntity.setJoinfield(rs.getString("fjoinfield"));
                ret.add(cascadeConfigEntity);
            }
            return ret;
        });
    }

    @Override
    public ArchiveCascadeConfigEntity loadCascadeConfig(long configId) {
        String condition = " fid = ? ";
        ArrayList<Object> paramList = new ArrayList<Object>(1);
        paramList.add(configId);
        List<ArchiveCascadeConfigEntity> ret = this.loadCascadeConfigList(condition, paramList);
        return ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public ArchiveCascadeConfigEntity loadCascadeConfig(String entityNumber) {
        String condition = " fentitynumber = ? ";
        ArrayList<Object> paramList = new ArrayList<Object>(1);
        paramList.add(entityNumber);
        List<ArchiveCascadeConfigEntity> ret = this.loadCascadeConfigList(condition, paramList);
        return ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public List<ArchiveCascadeConfigEntity> loadCascadeChildConfig(String entityNumber) {
        String condition = " fparentnumber = ? ";
        ArrayList<Object> paramList = new ArrayList<Object>(1);
        paramList.add(entityNumber);
        List<ArchiveCascadeConfigEntity> ret = this.loadCascadeConfigList(condition, paramList);
        return ret;
    }
}

