/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.repository.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.archive.ArchiveConfigUtil;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveEntityEntity;
import kd.bos.archive.entity.ArchiveIndexConfigEntity;
import kd.bos.archive.repository.ArchiveEntityRepository;
import kd.bos.archive.repository.ArchiveIndexConfigRepository;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.archive.ArchiveConfigLoader;
import kd.bos.db.archive.config.ArchiveConfig;
import kd.bos.db.archive.config.ArchiveIndexConfig;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.EntityNotExistsException;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;
import kd.bos.threads.impl.RequestContextRunnable;
import kd.bos.xdb.exception.ExceptionUtil;

public class ArchiveConfigLoaderImpl
implements ArchiveConfigLoader {
    private static final Log log = LogFactory.getLog(ArchiveConfigLoaderImpl.class);

    public Set<ArchiveConfig> loadAll() {
        List<ArchiveEntityEntity> entityList = ArchiveEntityRepository.get().loadArchiveEntityList(null, null);
        Set<ArchiveConfig> set = this.toArchiveConfig(entityList);
        return set;
    }

    public Set<ArchiveConfig> load(String entityName) {
        String condition = " fentitynumber = ? ";
        ArrayList<Object> paramList = new ArrayList<Object>(1);
        paramList.add(entityName);
        List<ArchiveEntityEntity> entityList = ArchiveEntityRepository.get().loadArchiveEntityList(condition, paramList);
        Set<ArchiveConfig> set = this.toArchiveConfig(entityList);
        return set;
    }

    private Set<ArchiveConfig> toArchiveConfig(List<ArchiveEntityEntity> entityList) {
        HashSet<ArchiveConfig> set = new HashSet<ArchiveConfig>();
        for (ArchiveEntityEntity entityEntity : entityList) {
            List<ArchiveConfig> list = null;
            try {
                list = ArchiveConfigUtil.toArchiveConfigs(entityEntity.getEntitynumber(), entityEntity.getArchiveRoute(), null);
            }
            catch (EntityNotExistsException e) {
                ArchiveUtil.logError(String.format("ArchiveConfigUtil, entity: %s not exists", entityEntity.getEntitynumber()), e);
            }
            catch (Exception e) {
                ArchiveUtil.logError(String.format("ArchiveConfigUtil, toArchiveConfigs occur error, entiy: %s", entityEntity.getEntitynumber()), e);
            }
            if (list == null) continue;
            set.addAll(list);
        }
        return set;
    }

    public Set<ArchiveIndexConfig> loadIndexAll() {
        List<ArchiveIndexConfigEntity> indexConfigEntityList = ArchiveIndexConfigRepository.get().loadIndexConfigList(null, null);
        Set<ArchiveIndexConfig> set = this.toArchiveIndexConfig(indexConfigEntityList);
        return set;
    }

    public ArchiveIndexConfig loadIndex(String entityName) {
        ArchiveIndexConfigEntity indexConfigEntity = ArchiveIndexConfigRepository.get().loadIndexConfig(entityName);
        if (indexConfigEntity == null) {
            return null;
        }
        ArchiveIndexConfig indexConfig = ArchiveConfigUtil.toArchiveIndexConfig(indexConfigEntity.getEntitynumber());
        return indexConfig;
    }

    private Set<ArchiveIndexConfig> toArchiveIndexConfig(List<ArchiveIndexConfigEntity> indexConfigEntityList) {
        HashSet<ArchiveIndexConfig> set = new HashSet<ArchiveIndexConfig>();
        for (ArchiveIndexConfigEntity indexConfigEntity : indexConfigEntityList) {
            ArchiveIndexConfig indexConfig = ArchiveConfigUtil.toArchiveIndexConfig(indexConfigEntity.getEntitynumber());
            if (indexConfig == null) continue;
            set.add(indexConfig);
        }
        return set;
    }

    public String getEntityMainTable(String entityName) {
        return ORM.create().getDataEntityType(entityName).getAlias();
    }

    public void runWithDBAccessible(Runnable runnable, RequestContextInfo requestContextInfo) {
        try (AutoCloseable ac = requestContextInfo.setupThreadRequestContext();){
            RequestContext rc = (RequestContext)RequestContextInfo.getRequestContext();
            OperationContext oc = new OperationContext();
            oc.setAppId("archive");
            Runnable wrapRunnable = ThreadLifeCycleManager.wrapRunnable((Runnable)new RequestContextRunnable(runnable, rc, oc));
            ThreadPools.executeOnce((String)"runWithDBAccessible", (Runnable)wrapRunnable);
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap((Throwable)e);
        }
    }
}

