/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.repository.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveCrossInfoEntity;
import kd.bos.archive.enums.ArchiveTaskTypeEnum;
import kd.bos.archive.repository.ArchiveCrossInfoRepository;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveRouteType;
import kd.bos.id.ID;

public class ArchiveCrossInfoRepositoryImpl
implements ArchiveCrossInfoRepository {
    public static final ArchiveCrossInfoRepositoryImpl instance = new ArchiveCrossInfoRepositoryImpl();

    @Override
    public List<ArchiveCrossInfoEntity> loadCrossInfoList(String condition, List<Object> paramList) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select ");
        sql.append(" fid,ftaskid,ftasktype,fentitynumber,fscheduleid,fbatchnum,fconfigid,ftotalcount,fdatabase_type,farchiveroute,freversestatus,fcleanstatus,fcreatetime,fupdatetime ");
        sql.append(" from t_cbs_archi_cross_info  ");
        if (condition != null) {
            sql.append(" where ").append(condition);
        }
        return (List)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])(paramList == null ? null : paramList.toArray()), rs -> {
            ArrayList<ArchiveCrossInfoEntity> ret = new ArrayList<ArchiveCrossInfoEntity>(100);
            while (rs.next()) {
                ArchiveCrossInfoEntity crossInfoEntity = new ArchiveCrossInfoEntity();
                crossInfoEntity.setId(rs.getLong("fid"));
                crossInfoEntity.setTasktype(ArchiveTaskTypeEnum.from(rs.getString("ftasktype")));
                crossInfoEntity.setTaskid(rs.getLong("ftaskid"));
                crossInfoEntity.setEntitynumber(rs.getString("fentitynumber"));
                crossInfoEntity.setScheduleid(rs.getLong("fscheduleid"));
                crossInfoEntity.setBatchnum(rs.getString("fbatchnum"));
                crossInfoEntity.setConfigid(rs.getLong("fconfigid"));
                crossInfoEntity.setDatabaseType(ArchiveRouteType.from((String)rs.getString("fdatabase_type")));
                crossInfoEntity.setArchiveRoute(rs.getString("farchiveroute"));
                crossInfoEntity.setTotalcount(rs.getLong("ftotalcount"));
                crossInfoEntity.setReversestatus(rs.getString("freversestatus"));
                crossInfoEntity.setCleanstatus(rs.getString("fcleanstatus"));
                crossInfoEntity.setCreatetime(rs.getTimestamp("fcreatetime"));
                crossInfoEntity.setUpdatetime(rs.getTimestamp("fupdatetime"));
                ret.add(crossInfoEntity);
            }
            return ret;
        });
    }

    @Override
    public ArchiveCrossInfoEntity loadCrossInfo(long entityrcdId) {
        String condition = " fid = ? ";
        ArrayList<Object> paramList = new ArrayList<Object>(1);
        paramList.add(entityrcdId);
        List<ArchiveCrossInfoEntity> ret = this.loadCrossInfoList(condition, paramList);
        return ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public ArchiveCrossInfoEntity loadCrossInfoByTaskId(long taskId) {
        String condition = " ftaskid = ? ";
        ArrayList<Object> paramList = new ArrayList<Object>(1);
        paramList.add(taskId);
        List<ArchiveCrossInfoEntity> ret = this.loadCrossInfoList(condition, paramList);
        return ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public int updateReversestatus(long entityrcdId, String reversestatus) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update  t_cbs_archi_cross_info set freversestatus = ? where fid = ?");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{reversestatus, entityrcdId});
    }

    @Override
    public int updateCleanstatus(long entityrcdId, String cleanstatus) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update  t_cbs_archi_cross_info set fcleanstatus = ? where fid = ?");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{cleanstatus, entityrcdId});
    }

    @Override
    public ArchiveCrossInfoEntity loadCrossInfo(String entityNumber, String archiveRoute) {
        String condition = " fentitynumber = ? and farchiveroute = ?";
        ArrayList<Object> paramList = new ArrayList<Object>(2);
        paramList.add(entityNumber);
        paramList.add(archiveRoute);
        List<ArchiveCrossInfoEntity> ret = this.loadCrossInfoList(condition, paramList);
        return ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public boolean checkCrossInfoExist(String entityNumber, String archiveRoute) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select count(*) from t_cbs_archi_cross_info ");
        sql.append(" where  fentitynumber = ? and farchiveroute = ? ");
        ArrayList<String> paramList = new ArrayList<String>(2);
        paramList.add(entityNumber);
        paramList.add(archiveRoute);
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])paramList.toArray(), rs -> {
            if (rs.next() && rs.getLong(1) > 0L) {
                return true;
            }
            return false;
        });
    }

    @Override
    public void insertCrossInfo(ArchiveCrossInfoEntity crossInfoEntity) {
        StringBuilder sql = new StringBuilder();
        sql.append(" insert into t_cbs_archi_cross_info(");
        sql.append(" fid,ftaskid,ftasktype,fentitynumber,fscheduleid,fbatchnum,fconfigid,ftotalcount,fdatabase_type,farchiveroute,freversestatus,fcleanstatus,fcreatetime,fupdatetime ");
        sql.append(" ) values( ");
        sql.append(" ?,?,?,?,?,?,?,?,?,?,?,?,?,? ");
        sql.append(" ) ");
        Object[] obj = new Object[]{ID.genLongId(), crossInfoEntity.getTaskid(), crossInfoEntity.getTasktype().getKey(), crossInfoEntity.getEntitynumber(), crossInfoEntity.getScheduleid(), crossInfoEntity.getBatchnum(), crossInfoEntity.getConfigid(), crossInfoEntity.getTotalcount(), crossInfoEntity.getDatabaseType().getKey(), crossInfoEntity.getArchiveRoute(), crossInfoEntity.getReversestatus(), crossInfoEntity.getCleanstatus(), new Date(), new Date()};
        DB.execute((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), (Object[])obj);
    }

    @Override
    public long count(String entityName, String archiveRoute, Date startTime) {
        String sql = "select sum(ftotalcount) cnt from t_cbs_archi_cross_info where fentitynumber = ? and farchiveroute = ? and fcreatetime >= ? and ftasktype = ?";
        Object[] params = new Object[]{entityName, archiveRoute, startTime, ArchiveTaskTypeEnum.ARCHIVE.getKey()};
        sql = ArchiveUtil.wrapSQL(sql, true, true);
        return (Long)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, resultSet -> resultSet.next() ? resultSet.getLong("cnt") : 0L);
    }
}

