/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.repository.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.entity.ArchiveIndexConfigEntity;
import kd.bos.archive.repository.ArchiveIndexConfigRepository;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;

public class ArchiveIndexConfigRepositoryImpl
implements ArchiveIndexConfigRepository,
ArchiveLogable {
    public static final ArchiveIndexConfigRepositoryImpl instance = new ArchiveIndexConfigRepositoryImpl();

    @Override
    public List<ArchiveIndexConfigEntity> loadIndexConfigList(String condition, List<Object> paramList) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select ");
        sql.append(" fid,fentitynumber,findicesfields ");
        sql.append(" from t_cbs_archi_index ");
        if (condition != null) {
            sql.append(" where ").append(condition);
        }
        return (List)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])(paramList == null ? null : paramList.toArray()), rs -> {
            ArrayList<ArchiveIndexConfigEntity> ret = new ArrayList<ArchiveIndexConfigEntity>(100);
            while (rs.next()) {
                ArchiveIndexConfigEntity indexConfigEntity = new ArchiveIndexConfigEntity();
                indexConfigEntity.setId(rs.getLong("fid"));
                indexConfigEntity.setEntitynumber(rs.getString("fentitynumber"));
                String indicesFields = rs.getString("findicesfields");
                indexConfigEntity.setIndicesfields(indicesFields);
                if (indicesFields != null) {
                    indexConfigEntity.setIndicesProperties(indicesFields.split(","));
                }
                ret.add(indexConfigEntity);
            }
            return ret;
        });
    }

    @Override
    public ArchiveIndexConfigEntity loadIndexConfig(long configId) {
        String condition = " fid = ? ";
        ArrayList<Object> paramList = new ArrayList<Object>(1);
        paramList.add(configId);
        List<ArchiveIndexConfigEntity> ret = this.loadIndexConfigList(condition, paramList);
        return ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public ArchiveIndexConfigEntity loadIndexConfig(String entityNumber) {
        String condition = " fentitynumber = ? ";
        ArrayList<Object> paramList = new ArrayList<Object>(1);
        paramList.add(entityNumber);
        List<ArchiveIndexConfigEntity> ret = this.loadIndexConfigList(condition, paramList);
        return ret.isEmpty() ? null : ret.get(0);
    }
}

