/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.repository.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.enums.ArchiveTaskStatusEnum;
import kd.bos.archive.repository.ArchiveSplitTaskRepository;
import kd.bos.archive.task.service.db.split.entity.SplitInfo;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;

public class ArchiveSplitTaskRepositoryImpl
implements ArchiveSplitTaskRepository,
ArchiveLogable {
    public static final ArchiveSplitTaskRepositoryImpl instance = new ArchiveSplitTaskRepositoryImpl();

    @Override
    public List<ArchiveSplitTaskEntity> loadUnexecutedSplitTaskList(long taskId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" ftaskid = ?");
        sql.append(" and ftaskstatus = ?");
        ArrayList<Object> paramList = new ArrayList<Object>(2);
        paramList.add(taskId);
        paramList.add(ArchiveTaskStatusEnum.UNEXECUTED.getKey());
        return this.loadSplitTaskList(sql.toString(), paramList);
    }

    private List<ArchiveSplitTaskEntity> loadSplitTaskList(String condition, List<Object> paramList) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select ");
        sql.append(" fid,ftaskid,fentitynumber,fseq,findex,fpagesize,fpagenum,fheadpk,ftailpk ");
        sql.append(" ,ftasknode,ftaskstatus,fstarttime,fendtime,fprogresssign,fcreatetime,fmodifytime ");
        sql.append(" from t_cbs_archi_splittask ");
        if (condition != null) {
            sql.append(" where ").append(condition);
        }
        sql.append(" order by fseq asc ");
        return (List)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])paramList.toArray(), rs -> {
            ArrayList<ArchiveSplitTaskEntity> ret = new ArrayList<ArchiveSplitTaskEntity>(100);
            while (rs.next()) {
                ArchiveSplitTaskEntity splitEntity = new ArchiveSplitTaskEntity();
                splitEntity.setId(rs.getLong("fid"));
                splitEntity.setTaskid(rs.getLong("ftaskid"));
                splitEntity.setEntitynumber(rs.getString("fentitynumber"));
                splitEntity.setSeq(rs.getInt("fseq"));
                splitEntity.setIndex(rs.getInt("findex"));
                splitEntity.setPagesize(rs.getInt("fpagesize"));
                splitEntity.setPagenum(rs.getInt("fpagenum"));
                splitEntity.setHeadpk(rs.getString("fheadpk"));
                splitEntity.setTailpk(rs.getString("ftailpk"));
                splitEntity.setTaskstatus(ArchiveTaskStatusEnum.from(rs.getString("ftaskstatus")));
                splitEntity.setTasknode(ArchiveTaskNodeEnum.from(rs.getString("ftasknode")));
                splitEntity.setStarttime(rs.getTimestamp("fstarttime"));
                splitEntity.setEndtime(rs.getTimestamp("fendtime"));
                splitEntity.setProgresssign(rs.getString("fprogresssign"));
                splitEntity.setCreatetime(rs.getTimestamp("fcreatetime"));
                splitEntity.setModifytime(rs.getTimestamp("fmodifytime"));
                ret.add(splitEntity);
            }
            return ret;
        });
    }

    @Override
    public ArchiveSplitTaskEntity loadSplitTask(long taskId) {
        String condition = " fid = ? ";
        ArrayList<Object> paramList = new ArrayList<Object>(2);
        paramList.add(taskId);
        List<ArchiveSplitTaskEntity> ret = this.loadSplitTaskList(condition, paramList);
        return ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public List<ArchiveSplitTaskEntity> loadSplitTaskList(long taskId) {
        String condition = " ftaskid = ?";
        ArrayList<Object> paramList = new ArrayList<Object>(1);
        paramList.add(taskId);
        return this.loadSplitTaskList(condition, paramList);
    }

    @Override
    public int setNextTaskNode(long taskId, ArchiveTaskNodeEnum curNode, ArchiveTaskNodeEnum nextNode) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_archi_splittask ");
        sql.append(" set ftasknode = ? ");
        sql.append(" where fid = ? and ftasknode = ? ");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{nextNode.getKey(), taskId, curNode.getKey()});
    }

    @Override
    public int setSplitTaskUnexecuted(long subTaskid) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_archi_splittask ");
        sql.append(" set ftaskstatus = ? ");
        sql.append(" where ftaskid = ? and ftaskstatus in(?,?,?)");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ArchiveTaskStatusEnum.UNEXECUTED.getKey(), subTaskid, ArchiveTaskStatusEnum.EXECUTING.getKey(), ArchiveTaskStatusEnum.PAUSE.getKey(), ArchiveTaskStatusEnum.FAILED.getKey()});
    }

    @Override
    public int setUnexecutedByBarrier(long taskid) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_archi_splittask ");
        sql.append(" set ftasknode = ? , ftaskstatus = ? ");
        sql.append(" where ftaskid = ? and ftasknode = ? and ftaskstatus = ? ");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ArchiveTaskNodeEnum.DATACLEAN.getKey(), ArchiveTaskStatusEnum.UNEXECUTED.getKey(), taskid, ArchiveTaskNodeEnum.CASCADEBARRIER.getKey(), ArchiveTaskStatusEnum.SUCCESS.getKey()});
    }

    @Override
    public int updateSplitTaskSuccess(long subTaskid) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_archi_splittask ");
        sql.append(" set ftaskstatus = ?, fmodifytime = ? ");
        sql.append(", fendtime = ? ");
        sql.append(" where fid = ? and ftaskstatus in(?,?) ");
        ArrayList<Object> paramList = new ArrayList<Object>(6);
        paramList.add(ArchiveTaskStatusEnum.SUCCESS.getKey());
        paramList.add(new Date());
        paramList.add(new Date());
        paramList.add(subTaskid);
        paramList.add(ArchiveTaskStatusEnum.EXECUTING.getKey());
        paramList.add(ArchiveTaskStatusEnum.PAUSE.getKey());
        Object[] params = paramList.toArray();
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])params);
    }

    @Override
    public int setNextSplitTaskstatus(long taskId, ArchiveTaskStatusEnum curTaskstatus, ArchiveTaskStatusEnum nextTaskstatus) {
        return this.setTaskstatus(taskId, curTaskstatus, nextTaskstatus, false, false);
    }

    @Override
    public long countSplitTaskUnclosed(long subTaskid) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select count(*) from t_cbs_archi_splittask ");
        sql.append(" where ftaskid = ? and ftaskstatus != ? ");
        ArrayList<Object> paramList = new ArrayList<Object>(2);
        paramList.add(subTaskid);
        paramList.add(ArchiveTaskStatusEnum.SUCCESS.getKey());
        Object[] params = paramList.toArray();
        return (Long)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])params, rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return 0L;
        });
    }

    @Override
    public int updateSplitTaskExecuting(long subTaskid) {
        return this.setTaskstatus(subTaskid, ArchiveTaskStatusEnum.UNEXECUTED, ArchiveTaskStatusEnum.EXECUTING, true, false);
    }

    private int setTaskstatus(long subTaskid, ArchiveTaskStatusEnum curTaskstatus, ArchiveTaskStatusEnum nextTaskstatus, boolean isStart, boolean isEnd) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_archi_splittask ");
        sql.append(" set ftaskstatus = ?,fmodifytime = ? ");
        if (isStart) {
            sql.append(", fstarttime = ? ");
        }
        if (isEnd) {
            sql.append(", fendtime = ? ");
        }
        sql.append(" where fid = ? and ftaskstatus = ? ");
        ArrayList<Object> paramList = new ArrayList<Object>(6);
        paramList.add(nextTaskstatus.getKey());
        paramList.add(new Date());
        if (isStart) {
            paramList.add(new Date());
        }
        if (isEnd) {
            paramList.add(new Date());
        }
        paramList.add(subTaskid);
        paramList.add(curTaskstatus.getKey());
        Object[] params = paramList.toArray();
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])params);
    }

    @Override
    public void deleteSplitTask(long taskId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" delete from t_cbs_archi_splittask ");
        sql.append(" where ftaskid = ? ");
        DB.execute((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{taskId});
    }

    @Override
    public void insertSplitTask(long taskId, String entitynumber, ArchiveTaskNodeEnum taskNodeEnum, List<SplitInfo> splitList) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into t_cbs_archi_splittask (");
        sql.append(" fid,ftaskid,fentitynumber,fseq,findex,fpagenum,fpagesize,fheadpk,ftailpk,");
        sql.append(" ftaskstatus,ftasknode,fcreatetime ");
        sql.append(" )values (?,?,?,?,?,?,?,?,?,?,?,?)");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(splitList.size());
        for (int i = 0; i < splitList.size(); ++i) {
            ArrayList<Object> obj = new ArrayList<Object>(12);
            obj.add(ID.genLongId());
            obj.add(taskId);
            obj.add(entitynumber);
            obj.add(i + 1);
            obj.addAll(splitList.get(i).toList());
            obj.add(ArchiveTaskStatusEnum.UNEXECUTED.getKey());
            obj.add(taskNodeEnum.getKey());
            obj.add(new Date());
            paramList.add(obj.toArray());
        }
        DB.executeBatch((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), paramList);
    }
}

