/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.repository.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveSubTaskEntity;
import kd.bos.archive.enums.ArchiveSubTaskTypeEnum;
import kd.bos.archive.enums.ArchiveTaskStatusEnum;
import kd.bos.archive.repository.ArchiveSubTaskRepository;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;

public class ArchiveSubTaskRepositoryImpl
implements ArchiveSubTaskRepository,
ArchiveLogable {
    public static final ArchiveSubTaskRepositoryImpl instance = new ArchiveSubTaskRepositoryImpl();

    @Override
    public List<ArchiveSubTaskEntity> loadUnexecutedSubTaskList(long taskId, ArchiveSubTaskTypeEnum taskTypeEnum) {
        StringBuilder sql = new StringBuilder();
        sql.append(" ftaskid = ?");
        sql.append(" and ftasktype = ?");
        sql.append(" and ftaskstatus = ?");
        ArrayList<Object> paramList = new ArrayList<Object>(3);
        paramList.add(taskId);
        paramList.add(taskTypeEnum.getKey());
        paramList.add(ArchiveTaskStatusEnum.UNEXECUTED.getKey());
        return this.loadSubTaskList(sql.toString(), paramList);
    }

    private List<ArchiveSubTaskEntity> loadSubTaskList(String condition, List<Object> paramList) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select ");
        sql.append(" fid,ftaskid,fentitynumber,fmvtable,ftasktype ");
        sql.append(" ,ftaskstatus,fstarttime,fendtime,fprogresssign,fcreatetime,fmodifytime ");
        sql.append(" from t_cbs_archi_subtask ");
        if (condition != null) {
            sql.append(" where ").append(condition);
        }
        sql.append(" order by fid asc ");
        return (List)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])paramList.toArray(), rs -> {
            ArrayList<ArchiveSubTaskEntity> ret = new ArrayList<ArchiveSubTaskEntity>(100);
            while (rs.next()) {
                ArchiveSubTaskEntity progressEntity = new ArchiveSubTaskEntity();
                progressEntity.setId(rs.getLong("fid"));
                progressEntity.setTaskid(rs.getLong("ftaskid"));
                progressEntity.setEntitynumber(rs.getString("fentitynumber"));
                progressEntity.setMvtable(rs.getString("fmvtable"));
                progressEntity.setTasktype(ArchiveSubTaskTypeEnum.from(rs.getString("ftasktype")));
                progressEntity.setTaskstatus(ArchiveTaskStatusEnum.from(rs.getString("ftaskstatus")));
                progressEntity.setStarttime(rs.getTimestamp("fstarttime"));
                progressEntity.setEndtime(rs.getTimestamp("fendtime"));
                progressEntity.setProgresssign(rs.getString("fprogresssign"));
                progressEntity.setCreatetime(rs.getTimestamp("fcreatetime"));
                progressEntity.setModifytime(rs.getTimestamp("fmodifytime"));
                ret.add(progressEntity);
            }
            return ret;
        });
    }

    @Override
    public int setSubTaskUnexecuted(long subTaskid) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_archi_subtask ");
        sql.append(" set ftaskstatus = ? ");
        sql.append(" where ftaskid = ? and ftaskstatus in(?,?,?)");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ArchiveTaskStatusEnum.UNEXECUTED.getKey(), subTaskid, ArchiveTaskStatusEnum.EXECUTING.getKey(), ArchiveTaskStatusEnum.PAUSE.getKey(), ArchiveTaskStatusEnum.FAILED.getKey()});
    }

    @Override
    public int setSubTaskUnexecuted(List<Long> idList) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_archi_subtask ");
        sql.append(" set ftaskstatus = ? ");
        sql.append(" where  ftaskstatus in(?,?,?)");
        params.add(ArchiveTaskStatusEnum.UNEXECUTED.getKey());
        params.add(ArchiveTaskStatusEnum.EXECUTING.getKey());
        params.add(ArchiveTaskStatusEnum.PAUSE.getKey());
        params.add(ArchiveTaskStatusEnum.FAILED.getKey());
        params.addAll(idList);
        sql.append(" and ftaskid in( ");
        sql.append(" ? ");
        for (int i = 1; i < idList.size(); ++i) {
            sql.append(" ,? ");
        }
        sql.append(") ");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])params.toArray());
    }

    @Override
    public int setSubTaskFailedBySubTaskId(long subTaskid) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_archi_subtask ");
        sql.append(" set ftaskstatus = ? ");
        sql.append(" where fid = ? and ftaskstatus = ? ");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ArchiveTaskStatusEnum.FAILED.getKey(), subTaskid, ArchiveTaskStatusEnum.EXECUTING.getKey()});
    }

    @Override
    public int updateSubTaskSuccess(long subTaskid) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_archi_subtask ");
        sql.append(" set ftaskstatus = ?, fmodifytime = ? ");
        sql.append(", fendtime = ? ");
        sql.append(" where fid = ? and ftaskstatus in(?,?) ");
        ArrayList<Object> paramList = new ArrayList<Object>(6);
        paramList.add(ArchiveTaskStatusEnum.SUCCESS.getKey());
        paramList.add(new Date());
        paramList.add(new Date());
        paramList.add(subTaskid);
        paramList.add(ArchiveTaskStatusEnum.EXECUTING.getKey());
        paramList.add(ArchiveTaskStatusEnum.PAUSE.getKey());
        Object[] params = paramList.toArray();
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])params);
    }

    @Override
    public long countSubTaskUnclosed(long subTaskid, ArchiveSubTaskTypeEnum taskTypeEnum) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select count(*) from t_cbs_archi_subtask ");
        sql.append(" where ftaskid = ? and ftasktype = ? and ftaskstatus != ? ");
        ArrayList<Object> paramList = new ArrayList<Object>(3);
        paramList.add(subTaskid);
        paramList.add(taskTypeEnum.getKey());
        paramList.add(ArchiveTaskStatusEnum.SUCCESS.getKey());
        Object[] params = paramList.toArray();
        return (Long)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])params, rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return 0L;
        });
    }

    @Override
    public int updateSubTaskExecuting(long subTaskid) {
        return this.setTaskstatus(subTaskid, ArchiveTaskStatusEnum.UNEXECUTED, ArchiveTaskStatusEnum.EXECUTING, true, false);
    }

    private int setTaskstatus(long subTaskid, ArchiveTaskStatusEnum curTaskstatus, ArchiveTaskStatusEnum nextTaskstatus, boolean isStart, boolean isEnd) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_archi_subtask ");
        sql.append(" set ftaskstatus = ?,fmodifytime = ? ");
        if (isStart) {
            sql.append(", fstarttime = ? ");
        }
        if (isEnd) {
            sql.append(", fendtime = ? ");
        }
        sql.append(" where fid = ? and ftaskstatus = ? ");
        ArrayList<Object> paramList = new ArrayList<Object>(6);
        paramList.add(nextTaskstatus.getKey());
        paramList.add(new Date());
        if (isStart) {
            paramList.add(new Date());
        }
        if (isEnd) {
            paramList.add(new Date());
        }
        paramList.add(subTaskid);
        paramList.add(curTaskstatus.getKey());
        Object[] params = paramList.toArray();
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])params);
    }

    @Override
    public boolean checkExistsSubTask(long taskId, String mvtable, ArchiveSubTaskTypeEnum taskTypeEnum) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select count(*) from t_cbs_archi_subtask ");
        sql.append(" where ftaskid = ? and fmvtable = ? and ftasktype = ? ");
        ArrayList<Object> paramList = new ArrayList<Object>(3);
        paramList.add(taskId);
        paramList.add(mvtable);
        paramList.add(taskTypeEnum.getKey());
        Object[] params = paramList.toArray();
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])params, rs -> {
            if (rs.next() && rs.getLong(1) > 0L) {
                return true;
            }
            return false;
        });
    }

    @Override
    public void insertSubTask(long taskId, String mvtable, String entitynumber, ArchiveSubTaskTypeEnum taskTypeEnum) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into t_cbs_archi_subtask (");
        sql.append(" fid,ftaskid,fentitynumber,fmvtable,ftasktype,");
        sql.append(" ftaskstatus,fcreatetime ");
        sql.append(" )values (?,?,?,?,?,?,?)");
        long id = ID.genLongId();
        DB.execute((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{id, taskId, entitynumber, mvtable, taskTypeEnum.getKey(), ArchiveTaskStatusEnum.UNEXECUTED.getKey(), new Date()});
    }
}

