/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.schedule.cron;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.schedule.cron.CronTask;
import kd.bos.archive.schedule.task.ScheduleService;
import kd.bos.archive.schedule.task.ScheduleTaskStore;
import kd.bos.context.RequestContext;
import kd.bos.dlock.DLock;
import kd.bos.util.DisCardUtil;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;

public final class CronService
implements ArchiveLogable {
    private static final CronService INSTANCE = new CronService();
    private final Map<String, Map<Long, CronTask>> accountScheduledTaskMap = new ConcurrentHashMap();
    private final AtomicBoolean running = new AtomicBoolean();
    private Thread cornThread;
    private Map<Long, DLock> scheduledTaskLockMap = new ConcurrentHashMap();

    public static CronService get() {
        return INSTANCE;
    }

    private CronService() {
    }

    private Map<Long, CronTask> getScheduledTaskMap() {
        RequestContext rc = RequestContext.get();
        String key = rc.getTenantId() + '#' + rc.getAccountId();
        Map ret = this.accountScheduledTaskMap.get(key);
        if (ret == null) {
            ret = this.accountScheduledTaskMap.computeIfAbsent(key, k -> new ConcurrentHashMap());
        }
        return ret;
    }

    public void removeExcludeTask(List<CronTask> excludes) {
        if (!this.running.get()) {
            return;
        }
        HashSet<Long> ids = new HashSet<Long>(excludes.size());
        for (CronTask task : excludes) {
            ids.add(task.getId());
        }
        Iterator<Object> iterator = new ArrayList<Long>(this.getScheduledTaskMap().keySet()).iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            if (ids.contains(id)) continue;
            this.removeTask(id, true);
        }
    }

    public void removeTask(long id, boolean checkRunning) {
        if (checkRunning && !this.running.get()) {
            return;
        }
        CronTask task = this.getScheduledTaskMap().remove(id);
        if (task != null) {
            log.info("Remove archive cron task: " + task);
            ScheduleTaskStore.markStop(id);
            log.info("Archive cron task removed: " + task);
            this.scheduledTaskLockMap.remove(id).close();
        }
    }

    public void addTask(CronTask task, DLock scheduledLock) {
        if (!this.running.get()) {
            return;
        }
        long id = task.getId();
        Map<Long, CronTask> scheduledTaskMap = this.getScheduledTaskMap();
        CronTask existedTask = scheduledTaskMap.get(id);
        if (existedTask == null) {
            log.info("Add cron task: " + task);
            this.scheduledTaskLockMap.put(id, scheduledLock);
            scheduledTaskMap.put(id, task);
        } else if (!existedTask.getExpr().equals(task.getExpr())) {
            log.info("Update cron task: " + existedTask + "->" + task);
            existedTask.resetExpr(task.getExpr());
        }
    }

    public void startService() {
        if (this.running.compareAndSet(false, true)) {
            log.info("Start archive cron service...");
            this.cornThread = new Thread(){

                @Override
                public void run() {
                    CronService.this.roundTask();
                }
            };
            this.cornThread.setDaemon(true);
            this.cornThread.setName("archive-cron-service");
            this.cornThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService() {
        if (this.running.compareAndSet(false, true)) {
            log.info("Stopping archive cron service...");
            this.cornThread.interrupt();
            try {
                for (Map<Long, CronTask> scheduledTaskMap : this.accountScheduledTaskMap.values()) {
                    for (long id : new ArrayList<Long>(scheduledTaskMap.keySet())) {
                        this.removeTask(id, false);
                    }
                }
                log.info("Archive cron service stopped.");
            }
            finally {
                this.accountScheduledTaskMap.clear();
                this.scheduledTaskLockMap.clear();
            }
        }
    }

    private void roundTask() {
        long minuteTS = 60000L;
        ZonedDateTime beginTime = ZonedDateTime.now().truncatedTo(ChronoUnit.MINUTES);
        while (this.running.get()) {
            long ts = System.currentTimeMillis();
            ZonedDateTime nextBeginTime = beginTime.plusMinutes(1L);
            for (Map<Long, CronTask> scheduledTaskMap : new ArrayList<Map<Long, CronTask>>(this.accountScheduledTaskMap.values())) {
                for (CronTask task : new ArrayList<CronTask>(scheduledTaskMap.values())) {
                    ZonedDateTime fireTime;
                    if (!this.running.get()) {
                        return;
                    }
                    Date startTime = task.getStartTime();
                    Date endTime = task.getEndTime();
                    ZoneId zoneId = ZoneId.systemDefault();
                    ZonedDateTime startZonedDate = ZonedDateTime.ofInstant(startTime.toInstant(), zoneId);
                    ZonedDateTime endZonedDate = ZonedDateTime.ofInstant(endTime.toInstant(), zoneId);
                    if (!beginTime.isAfter(startZonedDate) || !beginTime.isBefore(endZonedDate) || (fireTime = task.getCornExpression().nextTimeAfter(beginTime)).isAfter(nextBeginTime)) continue;
                    this.fireCronTask(task);
                }
            }
            beginTime = nextBeginTime;
            if ((ts = 60000L + ts - System.currentTimeMillis()) <= 0L) continue;
            this.snoopRoundTask(ts);
        }
    }

    private void fireCronTask(CronTask task) {
        log.info("Schedule archive cron task: " + task);
        ScheduleService.get().submit(task);
    }

    private void snoopRoundTask(long ts) {
        try {
            Thread.sleep(ts);
        }
        catch (InterruptedException e) {
            DisCardUtil.discard();
        }
    }
}

