/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.schedule.task;

import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.config.AccountEnable;
import kd.bos.archive.schedule.cron.CronService;
import kd.bos.archive.schedule.cron.CronTask;
import kd.bos.archive.schedule.task.ScheduleTask;
import kd.bos.archive.schedule.task.ScheduleTaskStore;
import kd.bos.archive.service.config.ArchiveServiceConfig;
import kd.bos.archive.util.Accounts;
import kd.bos.context.RequestContext;
import kd.bos.dlock.DLock;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.util.DisCardUtil;

public final class ScheduleService
implements ArchiveLogable {
    private static final ScheduleService INSTANCE = new ScheduleService();
    private final AtomicBoolean running = new AtomicBoolean();
    private final ThreadPoolExecutor es = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private Thread scheduleThread;

    public static ScheduleService get() {
        return INSTANCE;
    }

    private ScheduleService() {
        this.es.setThreadFactory(new ThreadFactory(){
            int i = 0;

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("archive-schedule-thread" + this.i++);
                return t;
            }
        });
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            log.info("Start archive schedule service...");
            this.scheduleThread = new Thread(ThreadLifeCycleManager.wrapRunnable(() -> this.roundAccount()));
            this.scheduleThread.setDaemon(true);
            this.scheduleThread.setName("archive-schedule-service");
            this.scheduleThread.start();
        }
    }

    public void stop() {
        if (this.running.compareAndSet(true, false)) {
            log.info("Stop archive schedule service...");
            this.scheduleThread.interrupt();
            this.es.shutdown();
        }
    }

    private void roundAccount() {
        this.snoopRoundAccount(Math.max(10000L, ArchiveServiceConfig.getScanInterval() / 2L));
        CronService cs = CronService.get();
        while (this.running.get()) {
            for (RequestContext rc : Accounts.getAccountRequestContext()) {
                if (!this.running.get()) {
                    return;
                }
                RequestContext.copyAndSet((RequestContext)rc);
                if (!AccountEnable.isAccountEnable()) continue;
                DLock accountLock = DLock.create((String)("/archive/cron/account/" + rc.getAccountId()));
                Throwable throwable = null;
                try {
                    if (!accountLock.tryLock()) continue;
                    try {
                        List<CronTask> list = ScheduleTaskStore.loadCronTaskList();
                        cs.removeExcludeTask(list);
                        for (CronTask task : list) {
                            DLock scheduledLock = DLock.createReentrant((String)("/archive/cron/scheduledtask/" + task.getId()));
                            if (!scheduledLock.tryLock()) continue;
                            task.setRequestContext(rc);
                            cs.addTask(task, scheduledLock);
                        }
                    }
                    catch (Exception e) {
                        log.error("Round archive task error, tenantId=" + rc.getTenantId() + ", accountId=" + rc.getAccountId() + ":\t\n" + e.getMessage(), (Throwable)e);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (accountLock == null) continue;
                    if (throwable != null) {
                        try {
                            accountLock.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    accountLock.close();
                }
            }
            this.snoopRoundAccount(ArchiveServiceConfig.getScanInterval());
        }
    }

    private void snoopRoundAccount(long ts) {
        try {
            Thread.sleep(ts);
        }
        catch (InterruptedException e) {
            DisCardUtil.discard();
        }
    }

    public void submit(CronTask cronTask) {
        this.es.submit(new ScheduleTask(cronTask));
    }
}

