/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.schedule.task;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.schedule.cron.CronTask;
import kd.bos.archive.schedule.task.ScheduleTaskStore;
import kd.bos.archive.service.ArchiveService;
import kd.bos.context.RequestContext;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.util.DisCardUtil;

public class ScheduleTask
implements Runnable,
ArchiveLogable {
    private final CronTask cronTask;
    private final long id;

    public ScheduleTask(CronTask cronTask) {
        this.cronTask = cronTask;
        this.id = cronTask.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RequestContext.copyAndSet((RequestContext)this.cronTask.getRequestContext());
        CountDownLatch cdStop = new CountDownLatch(1);
        ScheduleTaskStore.keepRunning(this.id, true);
        Thread executeThread = new Thread(ThreadLifeCycleManager.wrapRunnable(() -> {
            try {
                this.schedule();
            }
            catch (Exception e) {
                log.error("Archive schedule task error, id=" + this.id + ", accountId=" + this.cronTask.getRequestContext().getAccountId() + ":\t\n" + e.getMessage(), (Throwable)e);
            }
            finally {
                cdStop.countDown();
            }
        }));
        executeThread.setName("archive-scheduletask-id" + this.id);
        executeThread.start();
        try {
            while (!cdStop.await(10L, TimeUnit.SECONDS)) {
                ScheduleTaskStore.keepRunning(this.id, false);
            }
        }
        catch (InterruptedException e) {
            DisCardUtil.discard();
        }
        finally {
            ScheduleTaskStore.onStopped(this.id);
            log.info("Archive schedule task stopped: " + this.id);
        }
    }

    private void schedule() {
        RequestContext.copyAndSet((RequestContext)this.cronTask.getRequestContext());
        log.info("Schedule archive task: " + this.id);
        ArchiveService.scheduleArchiveTask(this.id);
    }
}

