/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.service;

import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.archive.ArchiveConstant;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.ArchiveManager;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.changetask.ArchiveChangeTaskInfo;
import kd.bos.archive.changetask.ArchiveChangeTaskNotifier;
import kd.bos.archive.config.AccountEnable;
import kd.bos.archive.entity.ArchiveConfigEntity;
import kd.bos.archive.entity.ArchiveConfigRefbdEntity;
import kd.bos.archive.entity.ArchiveLogEntity;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.entity.ArchiveTaskEntity;
import kd.bos.archive.enums.ArchiveConfigMovingTypeEnum;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.enums.ArchiveTaskStatusEnum;
import kd.bos.archive.mq.ArchiveLogPublish;
import kd.bos.archive.repository.ArchiveConfigRefbdRepository;
import kd.bos.archive.repository.ArchiveConfigRepository;
import kd.bos.archive.repository.ArchiveEntityRepository;
import kd.bos.archive.repository.ArchiveLogRepository;
import kd.bos.archive.repository.ArchiveScheduleRecordRepository;
import kd.bos.archive.repository.ArchiveSplitTaskRepository;
import kd.bos.archive.repository.ArchiveSubTaskRepository;
import kd.bos.archive.repository.ArchiveTaskRepository;
import kd.bos.archive.service.config.ArchiveServiceConfig;
import kd.bos.archive.task.TaskContainer;
import kd.bos.archive.task.TaskContainerRunner;
import kd.bos.archive.util.Accounts;
import kd.bos.bundle.BosRes;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveInfo;
import kd.bos.db.archive.MCArchive;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.framework.instance.ClusterInstances;
import kd.bos.id.ID;
import kd.bos.instance.Instance;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.query.QFilter;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.impl.RequestContextRunnable;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.StringUtils;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.util.ConcurrentHashSet;

public class ArchiveService
implements ArchiveLogable,
ArchiveConstant {
    private static final long LOCK_TIMEOUT = 120000L;
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    private static final String ARCHIVE_TASK_EMPTY_CACHE_KEY = "archive_task_empty";
    private static final String ARCHIVE_TASK_ERROR_CACHE_KEY = "archive_task_error";
    private static Map<String, Boolean> errorAccountMap = new ConcurrentHashMap<String, Boolean>(3);
    private static ArchiveService instance = new ArchiveService();
    private volatile boolean terminal = false;
    private Timer timer;
    private ThreadPoolExecutor es = new ThreadPoolExecutor(ArchiveServiceConfig.getArchiveMovingThreads(), ArchiveServiceConfig.getArchiveMovingThreads(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private final Set<String> movingEntitySet = new ConcurrentHashSet();
    private final Set<String> serviceStartRetrySet = new ConcurrentHashSet();
    private final Set<String> unFinishedEntitySet = new ConcurrentHashSet();
    private final Object waitForTaskFinish = new Object();
    private final Object waitForTaskNew = new Object();
    private final AtomicInteger runningTaskCount = new AtomicInteger();
    private static ScheduledExecutorService ses = Executors.newScheduledThreadPool(1);
    private static Class<?> logBillEntityType;

    public static ArchiveService get() {
        return instance;
    }

    public static String getArchiveTaskLockKey(String accountId, String entityName) {
        return "/archive/task_dispatch/" + accountId + "/" + entityName;
    }

    public static String getArchiveServiceStartLockKey(String accountId) {
        return "/archive/service_start/" + accountId;
    }

    public void start() {
        if (!this.terminal) {
            ArchiveUtil.logInfo("start archive moving task service...");
            this.terminal = false;
            this.timer = new Timer("ARCHIVE-MOVE-TASK", true);
            this.timer.schedule(ThreadLifeCycleManager.wrapTimerTask(() -> {
                ArchiveServiceConfig.waitForArchiveMovingEnable();
                boolean allAccountTaskEmpty = true;
                for (RequestContext rc : Accounts.getAccountRequestContext()) {
                    Boolean errorBoolean = errorAccountMap.get(rc.getAccountId());
                    int taskEmptyLoopTimes = 0;
                    if (errorBoolean != null && errorBoolean.booleanValue()) {
                        String cacheErrorKey = ArchiveService.getTaskErrorCachkey(rc.getTenantId(), rc.getAccountId());
                        String cacheErrorValue = (String)cache.get(cacheErrorKey);
                        if (cacheErrorValue != null && !"null".equals(cacheErrorValue)) {
                            taskEmptyLoopTimes = Integer.parseInt(cacheErrorValue);
                        }
                    } else {
                        String cacheKey = ArchiveService.getTaskEmptyCachkey(rc.getTenantId(), rc.getAccountId());
                        String cacheValue = (String)cache.get(cacheKey);
                        if (cacheValue != null && !"null".equals(cacheValue)) {
                            taskEmptyLoopTimes = Integer.parseInt(cacheValue);
                        }
                    }
                    if ((long)taskEmptyLoopTimes > ArchiveServiceConfig.getTaskEmptyLoopTimes()) continue;
                    allAccountTaskEmpty = false;
                    break;
                }
                if (allAccountTaskEmpty) {
                    Object object = this.waitForTaskNew;
                    synchronized (object) {
                        try {
                            this.waitForTaskNew.wait(36060000L);
                        }
                        catch (InterruptedException rc) {
                            // empty catch block
                        }
                    }
                }
                for (RequestContext rc : Accounts.getAccountRequestContext()) {
                    String cacheErrorKey = ArchiveService.getTaskErrorCachkey(rc.getTenantId(), rc.getAccountId());
                    String cacheKey = ArchiveService.getTaskEmptyCachkey(rc.getTenantId(), rc.getAccountId());
                    try {
                        String userId = rc.getUserId();
                        if (userId == null) {
                            rc.setUserId("0");
                        }
                        RequestContext.copyAndSet((RequestContext)rc);
                        if (AccountEnable.isAccountEnable()) {
                            this.dispatchTask(rc);
                            errorAccountMap.put(rc.getAccountId(), false);
                            cache.remove(cacheErrorKey);
                            continue;
                        }
                        cache.inc(cacheKey, 2, TimeUnit.HOURS);
                    }
                    catch (Exception e) {
                        log.error("archive moving task run error,tenantId=" + rc.getTenantId() + ",accountId=" + rc.getAccountId() + ":\t\n" + e.getMessage(), (Throwable)e);
                        cache.inc(cacheErrorKey, 2, TimeUnit.HOURS);
                        cache.remove(cacheKey);
                        errorAccountMap.put(rc.getAccountId(), true);
                    }
                }
            }), 30000L, ArchiveServiceConfig.getMovingInterval());
        }
    }

    public void stop() {
        if (!this.terminal) {
            ArchiveUtil.logInfo("stop archive moving task service...");
            this.timer.cancel();
            this.terminal = true;
            this.fireTaskFinished();
            this.es.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHandOver(ArchiveTaskEntity taskEntity, DLock lock, RequestContext rc, boolean isFinish) {
        block9: {
            ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler onHandOver over, taskId:{0}, entitynumber:{1}, runningTaskCount:{2}, movingEntitySet:{3}, isFinish:{4}", taskEntity.getId(), rc.getAccountId() + "#" + taskEntity.getEntitynumber(), this.runningTaskCount, this.movingEntitySet.toString(), isFinish));
            try {
                if (!isFinish) break block9;
                Set<String> set = this.movingEntitySet;
                synchronized (set) {
                    this.movingEntitySet.remove(rc.getAccountId() + "#" + taskEntity.getEntitynumber());
                }
                set = this.unFinishedEntitySet;
                synchronized (set) {
                    this.unFinishedEntitySet.remove(rc.getAccountId() + "#" + taskEntity.getEntitynumber());
                }
                this.runningTaskCount.decrementAndGet();
                this.fireTaskFinished();
                ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler  onHandOver finish, taskId:{0}, entitynumber:{1}, runningTaskCount:{2}, movingEntitySet:{3}", taskEntity.getId(), rc.getAccountId() + "#" + taskEntity.getEntitynumber(), this.runningTaskCount, this.movingEntitySet.toString()));
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTaskFinished() {
        Object object = this.waitForTaskFinish;
        synchronized (object) {
            this.waitForTaskFinish.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHeartBeat(ArchiveChangeTaskInfo ai) {
        String cacheKey = ArchiveService.getTaskEmptyCachkey(ai.getTenantId(), ai.getAccountId());
        cache.remove(cacheKey);
        String cacheErrorKey = ArchiveService.getTaskErrorCachkey(ai.getTenantId(), ai.getAccountId());
        cache.remove(cacheErrorKey);
        Object object = this.waitForTaskNew;
        synchronized (object) {
            this.waitForTaskNew.notify();
        }
    }

    public void submitChangeTask(String recordName) {
        ArchiveChangeTaskNotifier.fireChangeTask(recordName);
    }

    public static String getTaskEmptyCachkey(String tenantId, String accountId) {
        return tenantId + "#" + accountId + "#" + ARCHIVE_TASK_EMPTY_CACHE_KEY + "#" + Instance.getInstanceId();
    }

    public static String getTaskErrorCachkey(String tenantId, String accountId) {
        return tenantId + "#" + accountId + "#" + ARCHIVE_TASK_ERROR_CACHE_KEY + "#" + Instance.getInstanceId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchTask(RequestContext rc) {
        int maxTaskCount = this.es.getMaximumPoolSize();
        String cacheKey = ArchiveService.getTaskEmptyCachkey(rc.getTenantId(), rc.getAccountId());
        while (!this.terminal && ArchiveServiceConfig.canMovingAccountId(rc.getAccountId())) {
            String cacheValue = (String)cache.get(cacheKey);
            int taskEmptyLoopTimes = 0;
            if (cacheValue != null && !"null".equals(cacheValue)) {
                taskEmptyLoopTimes = Integer.parseInt(cacheValue);
            }
            if ((long)taskEmptyLoopTimes > ArchiveServiceConfig.getTaskEmptyLoopTimes()) break;
            if (this.dispatchOneTask(rc)) {
                if (this.runningTaskCount.get() < maxTaskCount) {
                    try {
                        SecureRandom number = new SecureRandom();
                        Thread.sleep(number.nextInt(10000));
                        continue;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                Object object = this.waitForTaskFinish;
                synchronized (object) {
                    if (this.runningTaskCount.get() < maxTaskCount) {
                        continue;
                    }
                    try {
                        this.waitForTaskFinish.wait();
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
            cache.inc(cacheKey, 2, TimeUnit.HOURS);
            break;
        }
        if (!ArchiveServiceConfig.canMovingAccountId(rc.getAccountId())) {
            cache.inc(cacheKey, 2, TimeUnit.HOURS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dispatchOneTask(RequestContext rc) {
        try (TXHandle h = TX.notSupported((String)"archive.dispatchOneTask");){
            List<ArchiveTaskEntity> unexecutedTaskList;
            String serviceStartLockKey;
            DLock lock;
            List<ArchiveTaskEntity> collect;
            List<ArchiveTaskEntity> barrierTaskList = ArchiveTaskRepository.get().loadBarrierTaskList();
            if (!barrierTaskList.isEmpty() && this.doDispatchOneTask(collect = barrierTaskList.stream().filter(this::isBarrierRun).collect(Collectors.toList()), rc)) {
                boolean bl = true;
                return bl;
            }
            if (!this.serviceStartRetrySet.contains(rc.getAccountId()) && (lock = DLock.create((String)(serviceStartLockKey = ArchiveService.getArchiveServiceStartLockKey(rc.getAccountId())))).tryLock() && !this.serviceStartRetrySet.contains(rc.getAccountId())) {
                try {
                    List<ArchiveTaskEntity> failedArchiveTasks = ArchiveTaskRepository.get().loadFailedTaskList();
                    for (ArchiveTaskEntity failedArchiveTask : failedArchiveTasks) {
                        ArchiveService.setFailedTaskToUnexecuted(failedArchiveTask, "dispatchOneTask");
                    }
                    this.serviceStartRetrySet.add(rc.getAccountId());
                }
                catch (Exception e) {
                    log.info("ArchiveService dispatchOneTask occur an error: " + e.getMessage(), (Throwable)e);
                }
                finally {
                    lock.unlock();
                }
            }
            if (!(unexecutedTaskList = ArchiveTaskRepository.get().loadUnexecutedTaskList(null, null)).isEmpty()) {
                if (this.doDispatchOneTask(unexecutedTaskList, rc)) {
                    boolean bl = true;
                    return bl;
                }
                this.doTaskAbort(rc);
            } else {
                this.doTaskAbort(rc);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTaskAbort(RequestContext rc) {
        if (!ArchiveServiceConfig.isTaskAbortRetryEnable()) {
            return;
        }
        List<ArchiveTaskEntity> runningTaskEntities = ArchiveTaskRepository.get().loadRunningTaskList();
        for (ArchiveTaskEntity taskEntity : runningTaskEntities) {
            String lockKey;
            DLock lock;
            if (!this.isTaskAbort(taskEntity, rc) || !(lock = DLock.create((String)(lockKey = ArchiveService.getArchiveTaskLockKey(rc.getAccountId(), taskEntity.getEntitynumber())))).tryLock()) continue;
            try {
                ArchiveTaskEntity curTaskEntity = ArchiveTaskRepository.get().loadTask(taskEntity.getId());
                if (curTaskEntity.getTaskstatus() != ArchiveTaskStatusEnum.EXECUTING && curTaskEntity.getTaskstatus() != ArchiveTaskStatusEnum.PAUSE || !this.isTaskAbort(taskEntity, rc)) continue;
                TXHandle tx = TX.requiresNew();
                Throwable throwable = null;
                try {
                    List<ArchiveSplitTaskEntity> splitTaskEntityList = ArchiveSplitTaskRepository.get().loadSplitTaskList(taskEntity.getId());
                    List<Long> idList = splitTaskEntityList.stream().map(ArchiveSplitTaskEntity::getId).collect(Collectors.toList());
                    idList.add(taskEntity.getId());
                    ArchiveSplitTaskRepository.get().setSplitTaskUnexecuted(taskEntity.getId());
                    ArchiveSubTaskRepository.get().setSubTaskUnexecuted(idList);
                    ArchiveTaskRepository.get().setTaskUnexecuted(taskEntity.getId());
                    String runhost = NetAddressUtils.getLocalIpAddress();
                    String runinstance = Instance.getInstanceId();
                    String runNode = "instance=" + runinstance + "@" + runhost;
                    ArchiveLogRepository.get().insertLog(taskEntity.getId(), taskEntity.getEntitynumber(), BosRes.get((String)"bos-archive", (String)"ArchiveService_5", (String)"Background task retry operation, retry node: {0}", (Object[])new Object[]{runNode}), "MOVINGHANDLER");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private boolean isTaskAbort(ArchiveTaskEntity taskEntity, RequestContext rc) {
        String entityKey = rc.getAccountId() + "#" + taskEntity.getEntitynumber();
        if (this.movingEntitySet.contains(entityKey)) {
            return false;
        }
        List instanceNodes = ClusterInstances.getAllInstanceNodes();
        ArchiveLogEntity logEntity = ArchiveLogRepository.get().loadLatestLog(taskEntity.getEntitynumber());
        return !StringUtils.isEmpty((String)taskEntity.getRuninstance()) && !instanceNodes.contains(taskEntity.getRuninstance()) && logEntity != null && (System.currentTimeMillis() - logEntity.getCreatetime().getTime()) / 60000L > (long)ArchiveServiceConfig.getTaskRunningTimeOut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doDispatchOneTask(List<ArchiveTaskEntity> unexecutedTasks, RequestContext rc) {
        for (ArchiveTaskEntity taskEntity : unexecutedTasks) {
            String entityKey;
            if (!ArchiveServiceConfig.canMovingEntityName(rc.getAccountId(), taskEntity.getEntitynumber()) || !this.isCanRunMov(taskEntity, entityKey = rc.getAccountId() + "#" + taskEntity.getEntitynumber())) continue;
            Set<String> set = this.unFinishedEntitySet;
            synchronized (set) {
                List<ArchiveTaskEntity> unFinishedTaskList;
                if (this.unFinishedEntitySet.remove(entityKey) && (unFinishedTaskList = ArchiveTaskRepository.get().loadUnFinishedTaskList(taskEntity.getEntitynumber())).size() > 0) {
                    this.unFinishedEntitySet.add(entityKey);
                    continue;
                }
            }
            String lockKey = ArchiveService.getArchiveTaskLockKey(rc.getAccountId(), taskEntity.getEntitynumber());
            DLock lock = DLock.create((String)lockKey);
            if (!lock.tryLock(120000L)) continue;
            ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler doDispatchOneTask lock into,entitynumber:{0}, taskId:{1}", taskEntity.getEntitynumber(), taskEntity.getId()));
            ArchiveTaskEntity curTaskEntity = ArchiveTaskRepository.get().loadUnexecutedTask(taskEntity.getId());
            if (curTaskEntity == null || !this.isCanRunMov(curTaskEntity, entityKey)) {
                this.onHandOver(taskEntity, lock, rc, false);
                continue;
            }
            List<ArchiveTaskEntity> unFinishedTaskList = ArchiveTaskRepository.get().loadUnFinishedTaskList(curTaskEntity.getEntitynumber());
            if (unFinishedTaskList.size() > 0) {
                Set<String> set2 = this.unFinishedEntitySet;
                synchronized (set2) {
                    this.unFinishedEntitySet.add(entityKey);
                }
                this.onHandOver(taskEntity, lock, rc, false);
                continue;
            }
            List<ArchiveTaskEntity> abortList = ArchiveTaskRepository.get().loadAbortTaskList(taskEntity.getEntitynumber());
            if ((abortList = abortList.stream().filter(item -> item.getTasknode() != ArchiveTaskNodeEnum.TASKSTART).collect(Collectors.toList())).size() > 0 && abortList.get(0).getId() != curTaskEntity.getId()) {
                this.onHandOver(taskEntity, lock, rc, false);
                continue;
            }
            String runhost = NetAddressUtils.getLocalIpAddress();
            if (!StringUtils.isEmpty((String)taskEntity.getHost()) && !runhost.equals(taskEntity.getHost())) {
                this.onHandOver(taskEntity, lock, rc, false);
                continue;
            }
            Set<String> set3 = this.movingEntitySet;
            synchronized (set3) {
                if (this.movingEntitySet.contains(entityKey)) {
                    this.onHandOver(taskEntity, lock, rc, false);
                    continue;
                }
                this.movingEntitySet.add(entityKey);
            }
            String runinstance = Instance.getInstanceId();
            String runNode = "instance=" + runinstance + "@" + runhost;
            int c = 0;
            if (taskEntity.getTaskstatus() == ArchiveTaskStatusEnum.UNEXECUTED) {
                c = ArchiveTaskRepository.get().updateExecuting(taskEntity.getId(), runNode, runhost, runinstance);
            } else if (taskEntity.getTaskstatus() == ArchiveTaskStatusEnum.CASCADE) {
                c = ArchiveTaskRepository.get().updateCascadeExecuting(taskEntity.getId(), runNode, runhost, runinstance);
            }
            if (c <= 0) {
                this.onHandOver(taskEntity, lock, rc, false);
                Set<String> set4 = this.movingEntitySet;
                synchronized (set4) {
                    this.movingEntitySet.remove(entityKey);
                    continue;
                }
            }
            this.es.submit(this.wrapRunnable(new TaskContainerRunner(new TaskContainer(this, curTaskEntity, lock, rc), curTaskEntity), rc));
            this.runningTaskCount.incrementAndGet();
            ArchiveLogPublish.get().publishLog(taskEntity.getId(), taskEntity.getEntitynumber(), BosRes.get((String)"bos-archive", (String)"ArchiveService_2", (String)"Execution Node: {0}, runningTaskCount:{1}, movingEntitySet:{2}", (Object[])new Object[]{runNode, this.runningTaskCount, this.movingEntitySet.toString()}), "MOVINGHANDLER");
            ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler archive task executing submit on handler, taskId:{0}, entitynumber:{1}, runningTaskCount:{2}, movingEntitySet:{3}", taskEntity.getId(), taskEntity.getEntitynumber(), this.runningTaskCount, this.movingEntitySet.toString()));
            return true;
        }
        return false;
    }

    private boolean isCanRunMov(ArchiveTaskEntity taskEntity, String entityKey) {
        if (taskEntity.getTaskstatus() == ArchiveTaskStatusEnum.PAUSE) {
            IDataEntityType rootDT = ORMConfiguration.innerGetDataEntityType((String)taskEntity.getEntitynumber(), null);
            ArchiveManager.get().notifyTaskPaused(true, rootDT.getAlias());
            return false;
        }
        if (this.movingEntitySet.contains(entityKey)) {
            return false;
        }
        if (taskEntity.getTaskstatus() == ArchiveTaskStatusEnum.CASCADE && taskEntity.getBarriercount() == 0L) {
            if (taskEntity.getBarriercount() > 0L) {
                return false;
            }
            return this.isBarrierRun(taskEntity);
        }
        return taskEntity.getTaskstatus() == ArchiveTaskStatusEnum.UNEXECUTED;
    }

    private boolean isBarrierRun(ArchiveTaskEntity curTaskEntity) {
        if (curTaskEntity.getBarriercount() > 0L) {
            return false;
        }
        List<ArchiveTaskEntity> barrierTaskList = ArchiveTaskRepository.get().loadBarrierTask(curTaskEntity.getRootid());
        if (!barrierTaskList.isEmpty()) {
            for (ArchiveTaskEntity archiveTaskEntity : barrierTaskList) {
                if (archiveTaskEntity.getBarriercount() > 0L) {
                    return false;
                }
                if (curTaskEntity.getParentid() != 0L || archiveTaskEntity.getId() == curTaskEntity.getId() || archiveTaskEntity.getTasknode() == ArchiveTaskNodeEnum.TASKEND) continue;
                return false;
            }
        }
        return true;
    }

    public static List<String> loadHasArchiveEntity(String entityNumber) {
        ArrayList<String> allList = new ArrayList<String>();
        List<String> entityList = ArchiveEntityRepository.get().loadArchiveRouteList(entityNumber);
        if (null != entityList) {
            allList.addAll(entityList);
        }
        if (allList.size() > 0) {
            return allList;
        }
        return null;
    }

    public static String loadArchivePlanName(String archiveRouteKey) {
        try (DataSet dataSet = ORM.create().queryDataSet("ArchiveServiceLoadPlanName", "bos_cbs_archi_database", "name", new QFilter("archiveroute", "=", (Object)archiveRouteKey).toArray());){
            Iterator iterator = dataSet.iterator();
            if (iterator.hasNext()) {
                String string = ((Row)iterator.next()).getString("name");
                return string;
            }
        }
        return null;
    }

    public static Boolean isLogEntity(String entityNumber) {
        IDataEntityType itemDT = ORM.create().getDataEntityType(entityNumber);
        Class<?> cls = itemDT.getClass();
        if (logBillEntityType.isAssignableFrom(cls)) {
            return true;
        }
        return false;
    }

    public static void scheduleArchiveTask(long scheduleId) {
        log.info("archi unit test begin create task, schema id : " + scheduleId);
        long recordId = ID.genLongId();
        String batchnum = ID.longTo36Radix((long)recordId);
        String recordDesc = BosRes.get((String)"bos-archive", (String)"ArchiveService_3", (String)"There are unfinished migration subtasks.", (Object[])new Object[0]);
        int size = 0;
        if (ArchiveTaskRepository.get().checkLastScheduleEnd(scheduleId)) {
            ArchiveUtil.logInfo("insertTask scheduleId: " + scheduleId);
            List<ArchiveConfigEntity> scheduleConfigList = ArchiveConfigRepository.get().loadScheduleConfigList(scheduleId);
            size = ArchiveTaskRepository.get().insertTask(recordId, batchnum, scheduleId, scheduleConfigList);
            ArchiveService.syncConfigRefbd(recordId, batchnum, scheduleConfigList);
            recordDesc = BosRes.get((String)"bos-archive", (String)"ArchiveService_4", (String)"This schedule generates {0} archive task", (Object[])new Object[]{size});
        } else {
            List<ArchiveTaskEntity> failedArchiveTasks = ArchiveTaskRepository.get().loadFailedTaskListByScheduleId(scheduleId);
            for (ArchiveTaskEntity failedArchiveTask : failedArchiveTasks) {
                ArchiveService.setFailedTaskToUnexecuted(failedArchiveTask, "scheduleArchiveTask");
            }
        }
        ArchiveScheduleRecordRepository.get().insertScheduleRecord(recordId, scheduleId, batchnum, size, recordDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFailedTaskToUnexecuted(ArchiveTaskEntity task, String cause) {
        String entityNumber = task.getEntitynumber();
        long primaryKeyValue = task.getId();
        task = ArchiveTaskRepository.get().loadTask(primaryKeyValue);
        log.info("task:{}, entity:{}, start to update status to unexecuted", (Object)primaryKeyValue, (Object)task.getEntitynumber());
        if (!ArchiveService.isCanRetry(task)) {
            log.info("task:{}, entity:{}\uff0c\u4e0d\u6ee1\u8db3\u91cd\u8bd5\u6761\u4ef6\uff0c\u9000\u51fa\u91cd\u8bd5", (Object)primaryKeyValue, (Object)task.getEntitynumber());
            return;
        }
        String lockKey = ArchiveService.getArchiveTaskLockKey(RequestContext.get().getAccountId(), entityNumber);
        DLock lock = DLock.create((String)lockKey);
        if (lock.tryLock()) {
            try {
                task = ArchiveTaskRepository.get().loadTask(primaryKeyValue);
                if (!ArchiveService.isCanRetry(task)) {
                    log.info("task:{}, entity:{}\uff0c\u4e0d\u6ee1\u8db3\u91cd\u8bd5\u6761\u4ef6\uff0c\u9000\u51fa\u91cd\u8bd5", (Object)primaryKeyValue, (Object)task.getEntitynumber());
                    return;
                }
                ArchiveService.get().submitChangeTask(entityNumber);
                ArchiveSplitTaskRepository.get().setSplitTaskUnexecuted(primaryKeyValue);
                List<ArchiveSplitTaskEntity> splitTaskEntityList = ArchiveSplitTaskRepository.get().loadSplitTaskList(primaryKeyValue);
                List<Long> idList = splitTaskEntityList.stream().map(ArchiveSplitTaskEntity::getId).collect(Collectors.toList());
                idList.add(primaryKeyValue);
                ArchiveSubTaskRepository.get().setSubTaskUnexecuted(idList);
                ArchiveTaskRepository.get().setTaskUnexecuted(primaryKeyValue);
                ArchiveTaskRepository.get().updateTaskRetryInfo(task.getRetrytimes() + 1, primaryKeyValue);
                log.info("task:{}, entity:{}, update failed status to unexecuted status success", (Object)primaryKeyValue, (Object)task.getEntitynumber());
            }
            finally {
                lock.unlock();
            }
        } else {
            log.info(lockKey + " \u5206\u5e03\u5f0f\u9501\u88ab\u5360\u7528\uff0cretry\u5df2\u7ecf\u5728\u88ab\u6267\u884c\u4e2d");
            return;
        }
    }

    public static boolean isCanRetry(ArchiveTaskEntity task) {
        long gapMillis;
        if (task.getTaskstatus() != ArchiveTaskStatusEnum.FAILED) {
            log.info("\u4efb\u52a1id:{}, scheduleid:{}, entitynumber:{}, retrytimes:{},\u72b6\u6001\u662f{}\uff0c\u4e0d\u8fdb\u884c\u91cd\u8bd5\uff1a", new Object[]{task.getId(), task.getScheduleid(), task.getEntitynumber(), task.getRetrytimes(), task.getTaskstatus()});
            return false;
        }
        if (task.getRetrytimes() >= ArchiveServiceConfig.getTaskRetryUpLimitTimes()) {
            log.info("\u4efb\u52a1id:{}, scheduleid:{}, entitynumber:{}, retrytimes:{},\u91cd\u8bd5\u6b21\u6570\u8fbe\u5230\u4e0a\u9650\uff0c\u5c06\u4e0d\u518d\u6267\u884c\uff1a", new Object[]{task.getId(), task.getScheduleid(), task.getEntitynumber(), task.getRetrytimes()});
            return false;
        }
        Date lastRetryTime = task.getLastretrytime();
        if (lastRetryTime != null && (gapMillis = System.currentTimeMillis() - lastRetryTime.getTime()) < ArchiveServiceConfig.getTaskRetryTimeInterval()) {
            log.info("\u4efb\u52a1id:{}, scheduleid:{}, entitynumber:{}, lastretrytime:{},\u6ca1\u6709\u8fbe\u5230gap\uff0c\u672c\u6b21\u4e0d\u6267\u884c\uff1a", new Object[]{task.getId(), task.getScheduleid(), task.getEntitynumber(), task.getLastretrytime().toString()});
            return false;
        }
        return true;
    }

    public void delayScheduleRetryTask(ArchiveTaskEntity task, RequestContext rc) {
        long delayTime = ArchiveServiceConfig.getTaskRetryDelayTime() * (long)(task.getRetrytimes() + 1);
        log.info("task:{}, entity:{}, \u5931\u8d25\u540e\u91cd\u8bd5\uff0c\u7b49\u5f85:{}\u6beb\u79d2\u540e\u6267\u884c", new Object[]{task.getId(), task.getEntitynumber(), delayTime});
        Runnable runnable = this.wrapRunnable(() -> ArchiveService.setFailedTaskToUnexecuted(task, "retry after exception"), rc);
        ses.schedule(runnable, delayTime, TimeUnit.MILLISECONDS);
    }

    private static void syncConfigRefbd(long recordId, String batchnum, List<ArchiveConfigEntity> scheduleConfigList) {
        for (ArchiveConfigEntity config : scheduleConfigList) {
            ArchiveConfigEntity curConfigEntity;
            if (ArchiveConfigMovingTypeEnum.CLEAR == config.getMovingType() || ArchiveConfigMovingTypeEnum.SYNC == config.getMovingType() || (curConfigEntity = ArchiveConfigRepository.get().loadConfig(config.getId())).getArchiveRoute() != null && curConfigEntity.getArchiveRoute().equals("cur_database")) continue;
            String number = config.getEntitynumber();
            ArrayList<IDataEntityType> dataEntityTypes = new ArrayList<IDataEntityType>();
            if (ArchiveUtil.isCascadeRootBill(number)) {
                ArchiveUtil.collectDataEntityType(number, dataEntityTypes);
            } else {
                IDataEntityType dt2 = ORM.create().getDataEntityType(number);
                dataEntityTypes.add(dt2);
            }
            HashSet<String> baseSet = new HashSet<String>();
            dataEntityTypes.forEach(dt -> {
                String dbRouteKey = dt.getDBRouteKey();
                DBRoute entityDB = DBRoute.of((String)dbRouteKey);
                ArchiveUtil.collectBaseDataName(dt, baseSet, entityDB);
            });
            List<ArchiveConfigRefbdEntity> configRefbdEntityList = ArchiveConfigRefbdRepository.get().loadConfigRefbdList(config.getId());
            Map<String, Long> entityLong = configRefbdEntityList.stream().collect(Collectors.toMap(ArchiveConfigRefbdEntity::getBdnumber, ArchiveConfigRefbdEntity::getEntryid, (key1, key2) -> key2));
            Map<String, String> entityCustomMap = configRefbdEntityList.stream().collect(Collectors.toMap(ArchiveConfigRefbdEntity::getBdnumber, ArchiveConfigRefbdEntity::getCustom, (key1, key2) -> key2));
            List<String> lackerNum = ArchiveService.findLacked(baseSet, entityLong);
            List<Long> findSurplus = ArchiveService.findSurplus(baseSet, entityLong, entityCustomMap);
            if (findSurplus.size() > 0) {
                ArchiveConfigRefbdRepository.get().delSurplusNum(findSurplus);
            }
            int max = 0;
            if (configRefbdEntityList.size() > 0) {
                max = configRefbdEntityList.stream().max(Comparator.comparingInt(ArchiveConfigRefbdEntity::getSeq)).get().getSeq();
            }
            if (lackerNum.size() > 0) {
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>(lackerNum.size());
                for (String entityNumber : lackerNum) {
                    String bdname = ArchiveUtil.getDisplayName(entityNumber);
                    Object[] obj = new Object[]{config.getId(), ID.genLongId(), ++max, entityNumber, bdname, entityNumber, "0", ""};
                    paramsList.add(obj);
                }
                ArchiveConfigRefbdRepository.get().insertLackedNum(paramsList);
            }
            configRefbdEntityList = ArchiveConfigRefbdRepository.get().loadConfigRefbdList(config.getId());
            Set<String> newBaseSet = configRefbdEntityList.stream().map(ArchiveConfigRefbdEntity::getBdnumber).collect(Collectors.toSet());
            ArchiveTaskRepository.get().insertBdDatasyncTask(recordId, batchnum, config.getId(), newBaseSet);
        }
    }

    private static List<String> findLacked(Set<String> baseSet, Map<String, Long> entityLong) {
        ArrayList<String> lackerNum = new ArrayList<String>();
        for (String outer : baseSet) {
            if (null != entityLong.get(outer)) continue;
            lackerNum.add(outer);
        }
        return lackerNum;
    }

    private static List<Long> findSurplus(Set<String> baseSet, Map<String, Long> entityLong, Map<String, String> entityCustomMap) {
        ArrayList<Long> surplusNum = new ArrayList<Long>(entityLong.size());
        entityLong.forEach((k, v) -> {
            boolean isSurplus = true;
            for (String inner : baseSet) {
                if (!inner.equals(k)) continue;
                isSurplus = false;
                break;
            }
            if (isSurplus && "0".equals(entityCustomMap.get(k))) {
                surplusNum.add((Long)v);
            }
        });
        return surplusNum;
    }

    private Runnable wrapRunnable(Runnable r, RequestContext rc) {
        OperationContext oc = new OperationContext();
        oc.setAppId("archive");
        return ThreadLifeCycleManager.wrapRunnable((Runnable)new RequestContextRunnable(r, rc, oc));
    }

    public static void initArchiveDB() {
        List routeInfos = MCArchive.get();
        routeInfos.forEach(routeInfo -> {
            String routeKey = routeInfo.getRouteKey();
            List<ArchiveInfo> archiveInfos = routeInfo.getArchiveInfo();
            archiveInfos = archiveInfos.stream().filter(archiveInfo -> !routeKey.equalsIgnoreCase(archiveInfo.getKey())).collect(Collectors.toList());
            archiveInfos.forEach(archiveInfo -> {
                String databaseKey = archiveInfo.getKey();
                if (!ArchiveService.existsArchiveDB(databaseKey)) {
                    ArchiveService.addArchiveDatabase(archiveInfo.getName(), archiveInfo.getKey());
                }
            });
        });
    }

    private static void addArchiveDatabase(String name, String databaseKey) {
        try {
            Throwable throwable = null;
            try (DLock dLock = DLock.create((String)"ArchiveService#addArchiveDatabase");){
                if (dLock.tryLock(120000L) && !ArchiveService.existsArchiveDB(databaseKey)) {
                    long id = ID.genLongId();
                    String number = (databaseKey + "_AA").toUpperCase();
                    String archiveRoute = databaseKey + "$aa";
                    Object groupId = ArchiveService.getGroupId();
                    String sql = "insert into t_cbs_archi_database (fid,fnumber,fname,fstatus,fenable,fmasterid,fgroupid,flogicsuffix,fdatabase,farchiveroute,fdatabase_type,fcreatetime,fmodifytime) values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{id, number, name, "C", "1", id, groupId, "$aa", databaseKey, archiveRoute, "db", new Date(), new Date()});
                    String sqlL = "insert into t_cbs_archi_database_l (fpkid,fid,flocaleid,fname) values (?,?,?,?)";
                    DB.execute((DBRoute)DBRoute.base, (String)sqlL, (Object[])new Object[]{ID.genStringId(), id, "zh_CN", name});
                    return;
                }
                try {
                    throw kd.bos.archive.exception.ExceptionUtil.wrap(ResManager.loadKDString((String)"Failed to get Dlock", (String)"ArchiveService_6", (String)"bos-archive", (Object[])new Object[0]));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        catch (Exception e) {
            throw kd.bos.archive.exception.ExceptionUtil.wrap(e);
        }
    }

    private static Object getGroupId() {
        QFilter qFilter = new QFilter("number", "=", (Object)"auto");
        DynamicObject queryObj = ORM.create().queryOne("bos_cbs_archi_group_rule", qFilter.toArray());
        if (queryObj == null) {
            String sql = "insert into t_cbs_archi_group_rule (fid,fnumber,fname,fstatus,fenable,fmasterid,flongnumber,flevel,fisleaf,fparentid,fcreatetime,fmodifytime) values (?,?,?,?,?,?,?,?,?,?,?,?)";
            long id = ID.genLongId();
            String number = "auto";
            String groupName = "auto";
            DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{id, number, groupName, "C", "1", id, number, 1, "1", 0, new Date(), new Date()});
            String sqlL = "insert into t_cbs_archi_group_rule_l (fpkid,fid,flocaleid,fname) values (?,?,?,?)";
            DB.execute((DBRoute)DBRoute.base, (String)sqlL, (Object[])new Object[]{ID.genStringId(), id, "zh_CN", groupName});
            return id;
        }
        return queryObj.getPkValue();
    }

    private static boolean existsArchiveDB(String databaseKey) {
        QFilter databaseFilter = new QFilter("database", "=", (Object)databaseKey);
        return ORM.create().exists("bos_cbs_archi_database", databaseFilter.toArray());
    }

    static {
        try {
            logBillEntityType = Class.forName("kd.bos.entity.LogBillEntityType");
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap((Throwable)e);
        }
    }
}

