/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.sync;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RetryUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RetryUtil.class);
    private static final long MAX_SLEEP_MILLISECOND = 256000L;

    public static <T> T executeWithRetry(Callable<T> callable, int retryTimes, long sleepTimeInMilliSecond, boolean exponential) throws Exception {
        Retry retry = new Retry();
        return retry.doRetry(callable, retryTimes, sleepTimeInMilliSecond, exponential, null);
    }

    public static <T> T executeWithRetry(Callable<T> callable, int retryTimes, long sleepTimeInMilliSecond, boolean exponential, List<Class<?>> retryExceptionClasss) throws Exception {
        Retry retry = new Retry();
        return retry.doRetry(callable, retryTimes, sleepTimeInMilliSecond, exponential, retryExceptionClasss);
    }

    public static <T> T asyncExecuteWithRetry(Callable<T> callable, int retryTimes, long sleepTimeInMilliSecond, boolean exponential, long timeoutMs, ThreadPoolExecutor executor) throws Exception {
        AsyncRetry retry = new AsyncRetry(timeoutMs, executor);
        return retry.doRetry(callable, retryTimes, sleepTimeInMilliSecond, exponential, null);
    }

    public static ThreadPoolExecutor createThreadPoolExecutor() {
        return new ThreadPoolExecutor(0, 5, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    private static class AsyncRetry
    extends Retry {
        private long timeoutMs;
        private ThreadPoolExecutor executor;

        public AsyncRetry(long timeoutMs, ThreadPoolExecutor executor) {
            this.timeoutMs = timeoutMs;
            this.executor = executor;
        }

        @Override
        protected <T> T call(Callable<T> callable) throws Exception {
            Future<T> future = this.executor.submit(callable);
            try {
                T t = future.get(this.timeoutMs, TimeUnit.MILLISECONDS);
                return t;
            }
            catch (Exception e) {
                LOG.warn("Try once failed", (Throwable)e);
                throw e;
            }
            finally {
                if (!future.isDone()) {
                    future.cancel(true);
                    LOG.warn("Try once task not done, cancel it, active count: " + this.executor.getActiveCount());
                }
            }
        }
    }

    private static class Retry {
        private Retry() {
        }

        public <T> T doRetry(Callable<T> callable, int retryTimes, long sleepTimeInMilliSecond, boolean exponential, List<Class<?>> retryExceptionClasss) throws Exception {
            if (null == callable) {
                throw new IllegalArgumentException("callable can not be null ! ");
            }
            if (retryTimes < 1) {
                throw new IllegalArgumentException(String.format("retrytime[%d] value incorrect(<1).", retryTimes));
            }
            Exception saveException = null;
            for (int i = 0; i < retryTimes; ++i) {
                try {
                    return this.call(callable);
                }
                catch (Exception e) {
                    long timeToSleep;
                    saveException = e;
                    if (i == 0) {
                        LOG.error(String.format("Exception when calling callable, Msg:%s", saveException.getMessage()), (Throwable)saveException);
                    }
                    if (null != retryExceptionClasss && !retryExceptionClasss.isEmpty()) {
                        boolean needRetry = false;
                        for (Class<?> eachExceptionClass : retryExceptionClasss) {
                            if (eachExceptionClass != e.getClass()) continue;
                            needRetry = true;
                            break;
                        }
                        if (!needRetry) {
                            throw saveException;
                        }
                    }
                    if (i + 1 >= retryTimes || sleepTimeInMilliSecond <= 0L) continue;
                    long startTime = System.currentTimeMillis();
                    if (exponential) {
                        timeToSleep = sleepTimeInMilliSecond * (long)Math.pow(2.0, i);
                        if (timeToSleep >= 256000L) {
                            timeToSleep = 256000L;
                        }
                    } else {
                        timeToSleep = sleepTimeInMilliSecond;
                        if (timeToSleep >= 256000L) {
                            timeToSleep = 256000L;
                        }
                    }
                    try {
                        Thread.sleep(timeToSleep);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    long realTimeSleep = System.currentTimeMillis() - startTime;
                    LOG.error(String.format("Exception when calling callable, try to ecextue the %s times.plan to wait [%s]ms,real wait[%s]ms, Error Msg:[%s]", i + 1, timeToSleep, realTimeSleep, e.getMessage()));
                    continue;
                }
            }
            throw saveException;
        }

        protected <T> T call(Callable<T> callable) throws Exception {
            return callable.call();
        }
    }
}

