/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.sync.service;

import java.text.MessageFormat;
import kd.bos.archive.ArchiveConstant;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveTaskEntity;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.repository.ArchiveTaskRepository;
import kd.bos.archive.service.config.ArchiveServiceConfig;
import kd.bos.archive.tablemanager.TableManager;
import kd.bos.archive.task.config.WriterConfiguration;
import kd.bos.archive.task.service.TaskServiceAbst;
import kd.bos.db.archive.ArchiveName;

public class SyncTempCleanService
extends TaskServiceAbst {
    private WriterConfiguration configuration;

    public SyncTempCleanService(ArchiveTaskEntity taskEntity, WriterConfiguration configuration) {
        super(taskEntity, ArchiveTaskNodeEnum.TEMPCLEAN);
        this.configuration = configuration;
    }

    @Override
    public boolean doArchive() throws Exception {
        long nextIndex;
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SyncTempCleanService doArchive begin,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
        long cnt = this.taskEntity.getTotalcount();
        String mainMvTable = ArchiveName.of((String)this.configuration.getMainTable()).getArchivePkmTable((long)this.configuration.getConfigEntity().getSuffix());
        TableManager.get().dropTable(this.configuration.getRoute(), mainMvTable);
        if (this.configuration.getArchivePlugin() == null && cnt >= (long)ArchiveConstant.EXCEED_LIMIT_SIZE) {
            if (ArchiveServiceConfig.isEnableRelay() || this.configuration.isXdb()) {
                ArchiveTaskRepository.get().insertTaskByCopy(this.configuration.getTaskEntity());
            }
        } else if (this.configuration.isXdb() && (nextIndex = this.configuration.getNextShardingIndex(this.taskEntity.getIndex())) != -1L) {
            ArchiveTaskRepository.get().insertNextIndexTaskByCopy(this.configuration.getTaskEntity(), nextIndex);
        }
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SyncTempCleanService doArchive end,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
        return false;
    }
}

