/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.sync.service.split.work;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import kd.bos.archive.ArchiveConfigUtil;
import kd.bos.archive.ArchiveConstant;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.entity.ArchiveSubTaskEntity;
import kd.bos.archive.exception.ExceptionUtil;
import kd.bos.archive.mq.ArchiveLogPublish;
import kd.bos.archive.progress.SubTaskProgress;
import kd.bos.archive.repository.ArchiveSubTaskRepository;
import kd.bos.archive.sync.service.taskgroup.split.SyncCrossDataReader;
import kd.bos.archive.sync.service.taskgroup.split.SyncCrossDataWriter;
import kd.bos.archive.tablemanager.TableManager;
import kd.bos.archive.task.config.WriterConfiguration;
import kd.bos.archive.task.enums.State;
import kd.bos.archive.task.service.db.split.move.work.IWork;
import kd.bos.archive.task.taskgroup.TaskGroupExecutor;
import kd.bos.archive.task.taskgroup.communication.Communication;
import kd.bos.bundle.BosRes;
import kd.bos.db.archive.config.ArchiveConfig;
import kd.bos.db.archive.config.ChildrenArchiveConfig;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.tablemanager.meta.Column;

public class SyncSplitMoveWork
implements IWork,
ArchiveLogable {
    protected ArchiveSplitTaskEntity splitTaskEntity;
    protected ArchiveSubTaskEntity subTaskEntity;
    protected WriterConfiguration configuration;
    protected SubTaskProgress sp;
    protected Object prePk = null;

    public SyncSplitMoveWork(ArchiveSplitTaskEntity splitTaskEntity, ArchiveSubTaskEntity subTaskEntity, WriterConfiguration configuration, SubTaskProgress sp) {
        this.splitTaskEntity = splitTaskEntity;
        this.subTaskEntity = subTaskEntity;
        this.configuration = configuration;
        this.sp = sp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doWork() throws Exception {
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SyncSplitMoveWork begin,entitynumber:{0}, taskType:{1}, taskId:{2}, subTaskId:{3}", this.subTaskEntity.getEntitynumber(), this.subTaskEntity.getTasktype().getKey(), this.splitTaskEntity.getId(), this.subTaskEntity.getId()));
        if (Thread.currentThread().isInterrupted()) {
            ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SyncSplitMoveWork interrupted,entitynumber:{0}, taskType:{1}, taskId:{2}, subTaskId:{3}", this.subTaskEntity.getEntitynumber(), this.subTaskEntity.getTasktype().getKey(), this.splitTaskEntity.getId(), this.subTaskEntity.getId()));
            return false;
        }
        try (TXHandle tx = TX.notSupported((String)"SyncSplitMoveWork.doWork");){
            int c = ArchiveSubTaskRepository.get().updateSubTaskExecuting(this.subTaskEntity.getId());
            if (c <= 0) {
                ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SyncSplitMoveWork updateSubTaskExecuting error,entitynumber:{0}, taskType:{1},taskId:{2}, subTaskId:{3}", this.subTaskEntity.getEntitynumber(), this.subTaskEntity.getTasktype().getKey(), this.splitTaskEntity.getId(), this.subTaskEntity.getId()));
                boolean bl = false;
                return bl;
            }
            boolean isContinue = false;
            if (this.sp.getToPk() != null) {
                this.prePk = this.sp.getToPk();
                isContinue = true;
            }
            if (isContinue) {
                this.sp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"SyncSplitMoveWork_0", (String)"Synchronous migration, continue migration, mvtable: {0} , lastIndex: {1} , lastPk: {2}", (Object[])new Object[]{this.subTaskEntity.getMvtable(), this.splitTaskEntity.getIndex(), this.prePk}));
            } else {
                this.sp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"SyncCrossMoveWork_1", (String)"Sync migrations, start migrations, mvtable: {0}", (Object[])new Object[]{this.subTaskEntity.getMvtable()}));
            }
            this.sp.store();
            ArchiveConfig config = this.getArchiveConfig();
            ArchiveConfig keyConfig = this.getKeyArchiveConfig(config);
            String pkField = config.getPrimaryKey();
            String oriTable = config.getTable();
            String tranTable = this.configuration.isXdb() ? TableName.of((String)oriTable).getPrototypeTable() : oriTable;
            String fieldsString = this.getColumns(tranTable, pkField);
            SyncCrossDataReader pkReader = new SyncCrossDataReader(this.splitTaskEntity, this.configuration, config, keyConfig, fieldsString, this.prePk);
            SyncCrossDataWriter pkWriter = new SyncCrossDataWriter(this.splitTaskEntity, this.configuration, config, fieldsString, this.sp);
            pkWriter.setBufferSize(ArchiveConstant.CROSS_INSERT_PAGE_SIZE);
            Communication runnerCommunication = new Communication();
            TaskGroupExecutor pkGroupExecutor = TaskGroupExecutor.taskGroup(pkWriter, pkReader, this.configuration, runnerCommunication, "SPLIT#" + this.subTaskEntity.getTasktype().getKey(), true);
            pkGroupExecutor.doStart();
            if (runnerCommunication.getState() == State.FAILED) {
                StringWriter sw = new StringWriter();
                runnerCommunication.getThrowable().printStackTrace(new PrintWriter(sw));
                String error = MessageFormat.format("ArchiveTaskHandler SyncSplitMoveWork stateReturnFailed,entitynumber:{0}, taskType:{1}, taskId:{2}, subTaskId:{3}, errorinfo:{4}", this.splitTaskEntity.getEntitynumber(), this.subTaskEntity.getTasktype().getKey(), this.splitTaskEntity.getId(), this.subTaskEntity.getId(), sw.toString());
                ArchiveUtil.logError(error, runnerCommunication.getThrowable());
                ArchiveLogPublish.get().publishLog(this.subTaskEntity.getId(), this.splitTaskEntity.getEntitynumber(), error, "SPLIT#" + this.subTaskEntity.getTasktype().getKey());
                throw ExceptionUtil.asRuntimeException(sw.toString(), runnerCommunication.getThrowable());
            }
            this.sp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"SyncCrossMoveWork_6", (String)"Synchronous migration, mvtable: {0} , migration complete", (Object[])new Object[]{this.subTaskEntity.getMvtable()}));
            this.sp.setExecSql(null);
            this.sp.store();
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String runtimeException = sw.toString();
            ArchiveUtil.logError(MessageFormat.format("ArchiveTaskHandler SplitMoveWork error, entitynumber:{0}, taskType:{1}, taskId:{2}, subTaskId:{3}, errorinfo:{4}", this.splitTaskEntity.getEntitynumber(), this.subTaskEntity.getTasktype().getKey(), this.splitTaskEntity.getId(), this.subTaskEntity.getId(), runtimeException), e);
            ArchiveSubTaskRepository.get().setSubTaskFailedBySubTaskId(this.subTaskEntity.getId());
            throw ExceptionUtil.asRuntimeException(runtimeException, e);
        }
        ArchiveSubTaskRepository.get().updateSubTaskSuccess(this.subTaskEntity.getId());
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SyncSplitMoveWork end,entitynumber:{0}, taskType:{1}, taskId:{2}, subTaskId:{3}", this.subTaskEntity.getEntitynumber(), this.subTaskEntity.getTasktype().getKey(), this.splitTaskEntity.getId(), this.subTaskEntity.getId()));
        return false;
    }

    private ArchiveConfig getArchiveConfig() {
        for (ArchiveConfig config : this.configuration.getConfigs()) {
            if (!config.getTable().equalsIgnoreCase(this.subTaskEntity.getMvtable())) continue;
            return config;
        }
        throw new RuntimeException(this.subTaskEntity.getMvtable() + ":ArchiveConfigruntime is null.");
    }

    private ArchiveConfig getKeyArchiveConfig(ArchiveConfig config) {
        if (ArchiveConfigUtil.isLangOrGroupTableDBConfig(config) || ArchiveConfigUtil.isLkTableDBConfig(config)) {
            return ((ChildrenArchiveConfig)config).getParent();
        }
        return config;
    }

    private String getColumns(String table, String pkField) throws SQLException {
        List<Column> columnList = TableManager.get().getColumns(this.configuration.getRoute(), table);
        StringBuilder columnStr = new StringBuilder();
        int n = columnList.size();
        for (int i = 0; i < n; ++i) {
            String columnName = columnList.get(i).getColumnName();
            if (columnName.equalsIgnoreCase(pkField)) {
                if (i != n - 1) continue;
                columnStr.delete(columnStr.length() - 1, columnStr.length());
                continue;
            }
            columnStr.append(columnList.get(i).getColumnName());
            if (i == n - 1) continue;
            columnStr.append(',');
        }
        columnStr.insert(0, pkField + ',');
        return columnStr.toString();
    }
}

