/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.sync.service.taskgroup;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.archive.ArchiveConstant;
import kd.bos.archive.progress.IProgress;
import kd.bos.archive.service.config.ArchiveServiceConfig;
import kd.bos.archive.sync.DBUtil;
import kd.bos.archive.sync.DestinationConfig;
import kd.bos.archive.task.config.WriterConfiguration;
import kd.bos.archive.task.taskgroup.Writer;
import kd.bos.archive.transport.exchanger.RecordReceiver;
import kd.bos.archive.transport.record.Record;
import kd.bos.archive.transport.record.RowRecord;

public abstract class SyncCrossWriterAbst
implements Writer {
    protected IProgress progress;
    protected int bufferSize;
    protected WriterConfiguration configuration;

    public SyncCrossWriterAbst(WriterConfiguration configuration, IProgress progress) {
        this.configuration = configuration;
        this.progress = progress;
        this.bufferSize = ArchiveConstant.INSERT_PAGE_SIZE;
    }

    @Override
    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startWrite(RecordReceiver recordReceiver) throws SQLException {
        DestinationConfig destinationConfig = this.configuration.getDestinationConfig();
        Connection connection = DBUtil.getConnection(this.configuration.getConnectionType(), destinationConfig.getJdbcUrl(), destinationConfig.getUsername(), destinationConfig.getPassword());
        try {
            Record record;
            ArrayList<RowRecord> writerBuffer = new ArrayList<RowRecord>(this.bufferSize);
            while ((record = recordReceiver.getFromReader()) != null && !Thread.currentThread().isInterrupted()) {
                writerBuffer.add((RowRecord)record);
                if (writerBuffer.size() < this.bufferSize) continue;
                this.doBatchInsert(connection, writerBuffer);
                writerBuffer.clear();
            }
            if (!writerBuffer.isEmpty()) {
                this.doBatchInsert(connection, writerBuffer);
                writerBuffer.clear();
            }
        }
        finally {
            DBUtil.closeDBResources(null, null, connection);
        }
    }

    protected abstract void doBatchInsert(Connection var1, List<RowRecord> var2) throws SQLException;

    protected List<List> deleteSplitList(List<Object> pks) {
        ArrayList<List> ranges = new ArrayList<List>(10);
        int pageSize = ArchiveConstant.DELETE_SPLIT_SIZE;
        if (!ArchiveServiceConfig.isArchiveSplitDelEnable() || pks.size() <= pageSize) {
            ranges.add(pks);
        } else {
            int toIndex;
            int total = pks.size();
            int i = 0;
            do {
                int fromIndex = i;
                toIndex = Math.min(i += pageSize, total) - 1;
                List<Object> range = pks.subList(fromIndex, toIndex + 1);
                ranges.add(range);
            } while (toIndex != total - 1);
        }
        return ranges;
    }
}

