/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.sync.service.taskgroup.split;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.progress.IProgress;
import kd.bos.archive.sync.DBUtil;
import kd.bos.archive.sync.service.taskgroup.SyncCrossWriterAbst;
import kd.bos.archive.task.config.WriterConfiguration;
import kd.bos.archive.transport.record.RowRecord;
import kd.bos.bundle.BosRes;
import kd.bos.db.archive.config.ArchiveConfig;
import kd.bos.db.archive.config.ChildrenArchiveConfig;

public class SyncCrossDataWriter
extends SyncCrossWriterAbst {
    private ArchiveSplitTaskEntity splitTaskEntity;
    private String targetTable;
    private String pkField;
    private boolean isLang;
    private boolean isReplace;
    private String columnFields;
    private String crossInsetSql;

    public SyncCrossDataWriter(ArchiveSplitTaskEntity splitTaskEntity, WriterConfiguration configuration, ArchiveConfig config, String columnFields, IProgress progress) {
        super(configuration, progress);
        this.splitTaskEntity = splitTaskEntity;
        this.configuration = configuration;
        this.columnFields = columnFields;
        this.pkField = config.getPrimaryKey();
        this.isLang = config instanceof ChildrenArchiveConfig && ((ChildrenArchiveConfig)config).isLangTableConfig();
        this.isReplace = "mysql".equalsIgnoreCase(configuration.getConnectionType().getConnectionTypeCode());
        this.targetTable = config.getTable();
        this.crossInsetSql = this.getCrossInsetSql(this.columnFields, this.targetTable);
    }

    @Override
    public void doBatchInsert(Connection connection, List<RowRecord> writerBuffer) throws SQLException {
        Object fromPK = writerBuffer.get(0).getPk();
        Object toPK = writerBuffer.get(writerBuffer.size() - 1).getPk();
        int bufferSize = writerBuffer.size();
        StringBuilder sql = new StringBuilder(128);
        sql.setLength(0);
        if (!this.isReplace) {
            List<Object> pks = this.isLang ? writerBuffer.stream().map(RowRecord::getPkId).collect(Collectors.toList()) : writerBuffer.stream().map(RowRecord::getPk).collect(Collectors.toList());
            List<List> splitList = this.deleteSplitList(pks);
            for (List range : splitList) {
                StringBuilder delSql = new StringBuilder();
                delSql.append("delete from ").append(this.targetTable).append(" where ");
                if (this.isLang) {
                    delSql.append("fpkid");
                } else {
                    delSql.append(this.pkField);
                }
                delSql.append(" in (");
                int n = range.size();
                for (int i = 0; i < n; ++i) {
                    delSql.append("?");
                    if (i == n - 1) continue;
                    delSql.append(",");
                }
                delSql.append(")");
                DBUtil.execute(connection, delSql.toString(), range.toArray());
            }
        }
        List<Object[]> fieldValuesList = writerBuffer.stream().map(RowRecord::getColumns).collect(Collectors.toList());
        DBUtil.executeBatch(connection, this.crossInsetSql, fieldValuesList);
        this.progress.setProgressDesc_2(BosRes.get((String)"bos-archive", (String)"CrossMoveWork_3", (String)"Cross-database migration, mvtable:{0},index={1},fromPK={2},toPK={3},size={4}", (Object[])new Object[]{this.targetTable, this.splitTaskEntity.getIndex(), fromPK, toPK, bufferSize}));
        this.progress.setExecSql(sql.toString());
        this.progress.setToPk(toPK);
        this.progress.store();
    }

    private String getCrossInsetSql(String fieldsString, String targetTable) {
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        if (this.isReplace) {
            sql.append("replace into ").append(targetTable);
        } else {
            sql.append("insert into ").append(targetTable);
        }
        sql.append(" (").append(fieldsString).append(") values (");
        int n = fieldsString.split(",").length;
        for (int i = 0; i < n; ++i) {
            sql.append("?");
            if (i == n - 1) continue;
            sql.append(",");
        }
        sql.append(")");
        return sql.toString();
    }
}

