/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.sync.spi.destination.impl;

import com.google.common.base.Preconditions;
import java.util.Locale;
import kd.bos.archive.sync.spi.destination.Destination;
import kd.bos.xdb.tablemanager.meta.Column;
import kd.bos.xdb.tablemanager.meta.IndexColumnString;
import kd.bos.xdb.tablemanager.meta.PkInfo;

public class HanaDestinationImpl
implements Destination {
    private static final String EXIST_TABLE_SQL = "select 1 from sys.tables where schema_name=current_schema and table_name='%s'";
    private static final String QUERY_COLUMN_SQL = "select position as column_id, column_name as column_name, data_type_name as data_type,default_value as data_default, length as data_length, length as data_precision, scale as data_scale, is_nullable as nullable from sys.table_columns where schema_name = current_schema and table_name = '%s'";

    @Override
    public String getExistTableSql(String tableName) {
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName can not be null");
        return String.format(EXIST_TABLE_SQL, tableName.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public String getCreatePkIndexSql(String tableName, PkInfo pkInfo) {
        StringBuilder createTablePK = new StringBuilder(256);
        createTablePK.append("ALTER TABLE ").append(tableName.toUpperCase(Locale.ENGLISH)).append(" ADD ");
        createTablePK.append(" PRIMARY KEY(");
        int n = pkInfo.getColumnNameList().size();
        for (int i = 0; i < n; ++i) {
            String column = ((IndexColumnString)pkInfo.getColumnNameList().get(i)).getColumn();
            if (i > 0) {
                createTablePK.append(",");
            }
            createTablePK.append(column);
        }
        createTablePK.append(")");
        return createTablePK.toString();
    }

    @Override
    public String getQueryColumnsSql(String tableName) {
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName can not be null");
        return String.format(QUERY_COLUMN_SQL, tableName.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public String decorateDataDefault(Object dataDefaultStr) {
        if (dataDefaultStr != null && dataDefaultStr.toString().length() > 0) {
            String dataDefault;
            int seq = (dataDefault = String.valueOf(dataDefaultStr)).indexOf("::");
            return dataDefault.substring(0, seq > 0 ? seq : dataDefault.length());
        }
        return null;
    }

    @Override
    public String getDialectColumnDesc(Column column) {
        StringBuilder columnDesc = new StringBuilder(1024);
        columnDesc.append(column.getColumnName()).append(" ");
        String dataType = column.getDataType();
        long dataLength = column.getDataLength();
        int dataScale = column.getDataScale();
        int dataPrecision = column.getDataPrecision();
        Object dataDefault = column.getDataDefault();
        if (dataType.equalsIgnoreCase("SMALLINT")) {
            columnDesc.append("SMALLINT");
        } else if (dataType.equalsIgnoreCase("INT")) {
            columnDesc.append("INTEGER");
        } else if (dataType.equalsIgnoreCase("BIGINT")) {
            columnDesc.append("BIGINT");
        } else if (dataType.equalsIgnoreCase("CHAR")) {
            columnDesc.append("VARCHAR (");
            columnDesc.append(dataLength);
            columnDesc.append(")");
        } else if (dataType.equalsIgnoreCase("NCHAR")) {
            columnDesc.append("CHAR (");
            columnDesc.append(dataLength);
            columnDesc.append(")");
        } else if (dataType.equalsIgnoreCase("VARCHAR")) {
            columnDesc.append("VARCHAR (");
            columnDesc.append(dataLength);
            columnDesc.append(")");
        } else if (dataType.equalsIgnoreCase("NVARCHAR")) {
            columnDesc.append("NVARCHAR (");
            columnDesc.append(dataLength);
            columnDesc.append(")");
        } else if (dataType.equalsIgnoreCase("NCLOB")) {
            columnDesc.append("LONGTEXT");
        } else if (dataType.equalsIgnoreCase("BLOB")) {
            columnDesc.append("LONGBLOB");
        } else if (dataType.equalsIgnoreCase("CLOB")) {
            columnDesc.append("LONGTEXT");
        } else if (dataType.equalsIgnoreCase("DATETIME")) {
            columnDesc.append("TIMESTAMP");
        } else if (dataType.equalsIgnoreCase("DECIMAL")) {
            columnDesc.append("DECIMAL (");
            columnDesc.append(dataPrecision);
            columnDesc.append(", ");
            columnDesc.append(dataScale);
            columnDesc.append(")");
        } else {
            columnDesc.append(dataType);
        }
        columnDesc.append(column.isNullable() ? " NULL" : " NOT NULL");
        dataDefault = this.decorateDataDefault(dataDefault);
        if (dataDefault != null) {
            columnDesc.append(" DEFAULT ");
            columnDesc.append(dataDefault.toString().trim().length() == 0 ? "' '" : dataDefault);
        }
        return columnDesc.toString();
    }
}

