/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.tablemanager.meta;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.tablemanager.meta.MetaAbs;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveName;
import kd.bos.xdb.tablemanager.meta.Column;
import kd.bos.xdb.tablemanager.meta.CreateIndexSqlInfo;
import kd.bos.xdb.tablemanager.meta.IndexColumnString;
import kd.bos.xdb.tablemanager.meta.IndexInfo;
import kd.bos.xdb.tablemanager.meta.PkInfo;

public final class PgMetaImpl
extends MetaAbs {
    public static final PgMetaImpl instance = new PgMetaImpl();

    @Override
    public List<Column> queryColumns(DBRoute dbRoute, String table) {
        table = table.toLowerCase(Locale.ENGLISH);
        StringBuilder sql = new StringBuilder();
        sql.append(" select s.column_name,t.typname as data_type ,s.character_maximum_length,s.numeric_precision,s.numeric_scale,s.is_nullable,s.column_default,s.ordinal_position ");
        sql.append(" ,col_description((table_schema||'.'||table_name)::regclass::oid, ordinal_position) as column_comment ");
        sql.append(" from information_schema.columns s,pg_attribute a, pg_class c, pg_type t ");
        sql.append(" where  table_schema = current_schema () and s.table_name = c.relname and s.ordinal_position = a.attnum ");
        sql.append(" and a.attrelid = c.oid and a.atttypid = t.oid and s.table_name=? order by s.ordinal_position ");
        return (List)DB.query((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{table}, rs -> {
            ArrayList<Column> columnList = new ArrayList<Column>(50);
            while (rs.next()) {
                Column column = new Column();
                String column_name = rs.getString("column_name");
                String dataType = rs.getString("data_type");
                long data_length = this.parseLongNullAsZero(rs.getString("character_maximum_length"));
                int data_precision = this.parseIntNullAsZero(rs.getString("numeric_precision"));
                int data_scale = this.parseIntNullAsZero(rs.getString("numeric_scale"));
                boolean nullable = "YES".equals(rs.getString("is_nullable"));
                int column_id = rs.getInt("ordinal_position");
                String column_default = rs.getString("column_default");
                String column_comment = rs.getString("column_comment");
                column.setColumnId(column_id);
                column.setColumnName(column_name);
                column.setDataType(dataType);
                column.setDataDefault((Object)column_default);
                column.setDataLength(data_length);
                column.setDataPrecision(data_precision);
                column.setDataScale(data_scale);
                column.setNullable(nullable);
                column.setColumnComment(column_comment);
                columnList.add(column);
            }
            return columnList;
        });
    }

    @Override
    public void addColumn(DBRoute dbRoute, String table, Column column) {
        table = table.toLowerCase(Locale.ENGLISH);
        StringBuilder addColumnSql = new StringBuilder(1024);
        addColumnSql.append("alter table ").append(table).append(" add ").append(this.getColumnDesc(column, true));
        DB.execute((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(addColumnSql.toString(), true, true));
    }

    @Override
    public String createTableSql(String table, List<Column> columnList) {
        table = table.toLowerCase(Locale.ENGLISH);
        StringBuilder createTableSQL = new StringBuilder(1024);
        createTableSQL.append("CREATE TABLE ").append(table).append("(");
        int n = columnList.size();
        for (int i = 0; i < n; ++i) {
            Column column = columnList.get(i);
            if (i > 0) {
                createTableSQL.append(",");
            }
            createTableSQL.append(this.getColumnDesc(column, false));
        }
        createTableSQL.append(")");
        return createTableSQL.toString();
    }

    @Override
    public String alterCommentSql(String table, Column column) {
        table = table.toLowerCase(Locale.ENGLISH);
        StringBuilder sql = new StringBuilder();
        sql.append("COMMENT ON COLUMN ");
        sql.append(table).append(".").append(column.getColumnName());
        sql.append("  IS '");
        sql.append(column.getColumnComment()).append("'");
        return sql.toString();
    }

    @Override
    public String getColumnDesc(Column column, boolean isAddColumn) {
        StringBuilder columnDesc = new StringBuilder(1024);
        columnDesc.append(column.getColumnName()).append(" ");
        String dataType = column.getDataType();
        long dataLength = column.getDataLength();
        int dataScale = column.getDataScale();
        int dataPrecision = column.getDataPrecision();
        columnDesc.append(dataType);
        switch (dataType) {
            case "numeric": {
                if (dataScale != 0) {
                    columnDesc.append('(').append(dataPrecision).append(',').append(dataScale).append(')');
                    break;
                }
                if (dataPrecision == 0) break;
                columnDesc.append('(').append(dataPrecision).append(")");
                break;
            }
            default: {
                if (dataLength == 0L) break;
                columnDesc.append('(').append(dataLength).append(')');
            }
        }
        columnDesc.append(column.isNullable() ? " NULL" : " NOT NULL");
        if (column.getDataDefault() != null && column.getDataDefault().toString().length() > 0) {
            columnDesc.append(" DEFAULT ");
            String dataDefault = String.valueOf(column.getDataDefault());
            if (isAddColumn) {
                int seq = dataDefault.indexOf("::");
                columnDesc.append(dataDefault, 0, seq > 0 ? seq : dataDefault.length());
            } else {
                columnDesc.append(dataDefault.trim().length() == 0 ? "' '" : dataDefault);
            }
        }
        return columnDesc.toString();
    }

    @Override
    public PkInfo queryPkInfo(DBRoute dbRoute, String table) {
        table = table.toLowerCase(Locale.ENGLISH);
        String pkSql = "select b.conname from pg_class a,pg_constraint b where a.oid=b.conrelid and a.relname =? and b.contype = 'p'";
        String pkName = (String)DB.query((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(pkSql, true, true), (Object[])new Object[]{table}, rs -> {
            if (rs.next()) {
                return rs.getString(1);
            }
            return null;
        });
        PkInfo pkInfo = new PkInfo();
        if (pkName != null) {
            String columnSql = "select constraint_name,column_name from information_schema.key_column_usage  where table_schema = current_schema () and constraint_name = ?";
            return (PkInfo)DB.query((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(columnSql, true, true), (Object[])new Object[]{pkName}, rs -> {
                while (rs.next()) {
                    String constraint_name = rs.getString("constraint_name");
                    String column_name = rs.getString("column_name");
                    pkInfo.setIndexName(constraint_name);
                    pkInfo.addColumn(column_name, true);
                }
                return pkInfo;
            });
        }
        return pkInfo;
    }

    @Override
    public String createPkIndexSql(String table, PkInfo pkInfo, String strSuffix, String logicSuffix) {
        table = table.toLowerCase(Locale.ENGLISH);
        StringBuilder createTablePK = new StringBuilder(256);
        createTablePK.append("ALTER TABLE ").append(table).append(" ADD CONSTRAINT ");
        String constraint_name = pkInfo.getIndexName();
        String indexName = ArchiveName.of((String)constraint_name).getArchiveIndex(strSuffix, logicSuffix);
        createTablePK.append(indexName).append(" PRIMARY KEY(");
        int n = pkInfo.getColumnNameList().size();
        for (int i = 0; i < n; ++i) {
            String column = ((IndexColumnString)pkInfo.getColumnNameList().get(i)).getColumn();
            if (i > 0) {
                createTablePK.append(",");
            }
            createTablePK.append(column);
        }
        createTablePK.append(")");
        return createTablePK.toString();
    }

    @Override
    public List<CreateIndexSqlInfo> createIndexSql(DBRoute dbRoute, String table, String likeTable, PkInfo pkInfo, String strSuffix, String logicSuffix) {
        likeTable = likeTable.toLowerCase(Locale.ENGLISH);
        List<String> indexNameList = this.queryIndexNameList(dbRoute, likeTable);
        String queryCreateIndexSql = "select pg_get_indexdef('#indexname#'::regclass)";
        ArrayList<CreateIndexSqlInfo> createIndexSqlInfoList = new ArrayList<CreateIndexSqlInfo>(50);
        for (String indexName : indexNameList) {
            if (indexName.equalsIgnoreCase(pkInfo.getIndexName())) continue;
            CreateIndexSqlInfo createIndexSqlInfo = new CreateIndexSqlInfo();
            createIndexSqlInfo.setIndexName(indexName);
            String queryCreateSql = queryCreateIndexSql.replaceFirst("#indexname#", Matcher.quoteReplacement(indexName));
            String createIndexSql = (String)DB.query((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(queryCreateSql, true, true), rs -> {
                if (rs.next()) {
                    String returnCreateSql = rs.getString(1);
                    return this.assembleCreateIndexSql(returnCreateSql, table.toLowerCase(), strSuffix, logicSuffix);
                }
                return null;
            });
            createIndexSqlInfo.setCreateIndexSql(createIndexSql);
            createIndexSqlInfoList.add(createIndexSqlInfo);
        }
        return createIndexSqlInfoList;
    }

    private String assembleCreateIndexSql(String returnCreateSql, String table, String strSuffix, String logicSuffix) {
        table = table.toLowerCase(Locale.ENGLISH);
        StringBuilder sb = new StringBuilder(returnCreateSql.length());
        int p0 = returnCreateSql.indexOf("INDEX");
        int p1 = returnCreateSql.indexOf("ON");
        int p2 = returnCreateSql.indexOf("USING");
        String oriIndexName = ArchiveUtil.unWrapSQLTableName(returnCreateSql.substring(p0 + 6, p1).trim());
        String indexName = ArchiveName.of((String)oriIndexName).getArchiveIndex(strSuffix, logicSuffix);
        sb.append(returnCreateSql, 0, p0).append(" INDEX ").append(indexName);
        sb.append(" ON ").append(table).append(' ');
        sb.append(returnCreateSql.substring(p2));
        return sb.toString();
    }

    @Override
    public List<IndexInfo> queryIndexInfos(DBRoute dbRoute, String likeTable) {
        likeTable = likeTable.toLowerCase(Locale.ENGLISH);
        List<String> indexNameList = this.queryIndexNameList(dbRoute, likeTable);
        String queryCreateIndexSql = "select pg_get_indexdef('#indexname#'::regclass)";
        ArrayList<IndexInfo> indexInfoList = new ArrayList<IndexInfo>(50);
        for (String indexName : indexNameList) {
            IndexInfo indexInfo = new IndexInfo();
            indexInfoList.add(indexInfo);
            indexInfo.setIndexName(indexName);
            String queryCreateSql = queryCreateIndexSql.replaceFirst("#indexname#", Matcher.quoteReplacement(indexName));
            DB.query((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(queryCreateSql, true, true), rs -> {
                while (rs.next()) {
                    String[] columnArray;
                    String returnCreateSql = rs.getString(1);
                    indexInfo.setCreateIndexSql(returnCreateSql);
                    int p1 = returnCreateSql.indexOf("INDEX");
                    String uniqueStr = returnCreateSql.substring(6, p1).trim();
                    if (uniqueStr.equals("UNIQUE")) {
                        indexInfo.setUnique(true);
                    }
                    int p2 = returnCreateSql.indexOf(40);
                    int p3 = returnCreateSql.indexOf(41);
                    String columnList = returnCreateSql.substring(p2 + 1, p3);
                    for (String columnDesc : columnArray = columnList.split(",")) {
                        String[] column = columnDesc.trim().split(" ");
                        IndexColumnString columnString = column.length > 1 ? new IndexColumnString(column[0], false) : new IndexColumnString(column[0], true);
                        indexInfo.addIndexColumn(columnString);
                    }
                }
                return null;
            });
        }
        return indexInfoList;
    }

    private List<String> queryIndexNameList(DBRoute dbRoute, String likeTable) {
        likeTable = likeTable.toLowerCase(Locale.ENGLISH);
        String queryIndexNameSql = "select i.relname,ix.indisunique,ix.indisprimary,ix.indkey from pg_class i, pg_index ix,pg_class t where i.relkind = 'i' and i.oid = ix.indexrelid  and t.oid = ix.indrelid and t.relname = ? ";
        return (List)DB.query((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(queryIndexNameSql, true, true), (Object[])new Object[]{likeTable}, rs -> {
            ArrayList<String> indexNames = new ArrayList<String>(50);
            while (rs.next()) {
                String indexName = rs.getString(1);
                indexNames.add(indexName);
            }
            return indexNames;
        });
    }

    @Override
    public void dropIndex(DBRoute dbRoute, String table, String index) {
        table = table.toLowerCase(Locale.ENGLISH);
        DB.execute((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL("drop index " + index, true, true));
    }

    @Override
    public void dropPkIndex(DBRoute dbRoute, String table, String index) {
        table = table.toLowerCase(Locale.ENGLISH);
        DB.execute((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL("alter table " + table + " drop constraint " + index, true, true));
    }

    @Override
    public void addIndex(DBRoute dbRoute, String table, IndexInfo index) throws SQLException {
        table = table.toLowerCase(Locale.ENGLISH);
        String createIndexSql = this.assembleCreateIndexSql(index.getCreateIndexSql(), table, null, "");
        DB.execute((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(createIndexSql, true, true));
    }

    @Override
    public void rnameTable(DBRoute dbRoute, String tableName, String backName) throws SQLException {
        tableName = tableName.toLowerCase(Locale.ENGLISH);
        backName = backName.toLowerCase(Locale.ENGLISH);
        String sql = "alter table " + tableName + " rename to " + backName;
        DB.execute((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(sql, true, true));
    }

    @Override
    public void convertDialectToKsqlDataType(Column column) {
        String dataType = column.getDataType();
        String ksqlType = column.getDataType();
        if (dataType.equalsIgnoreCase("SMALLINT") || dataType.equalsIgnoreCase("INT4")) {
            ksqlType = "SMALLINT";
        } else if (dataType.equalsIgnoreCase("INTEGER")) {
            ksqlType = "INT";
        } else if (dataType.equalsIgnoreCase("BIGINT") || dataType.equalsIgnoreCase("INT8")) {
            ksqlType = "BIGINT";
        } else if (dataType.equalsIgnoreCase("CHAR") || dataType.equalsIgnoreCase("BPCHAR")) {
            ksqlType = "CHAR";
        } else if (dataType.equalsIgnoreCase("CHARACTER")) {
            ksqlType = "NCHAR";
        } else if (dataType.equalsIgnoreCase("CHARACTER VARYING")) {
            ksqlType = "VARCHAR";
        } else if (dataType.equalsIgnoreCase("VARCHAR")) {
            ksqlType = "NVARCHAR";
        } else if (dataType.equalsIgnoreCase("TEXT")) {
            ksqlType = "NCLOB";
        } else if (dataType.equalsIgnoreCase("BYTEA")) {
            ksqlType = "BLOB";
        } else if (dataType.equalsIgnoreCase("DATETIME") || dataType.equalsIgnoreCase("TIMESTAMP")) {
            ksqlType = "DATETIME";
        } else if (dataType.equalsIgnoreCase("NUMERIC")) {
            ksqlType = "DECIMAL";
        }
        column.setDataType(ksqlType);
    }
}

