/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.tablemanager.meta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.tablemanager.meta.OracleMetaImpl;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveName;
import kd.bos.xdb.tablemanager.meta.Column;
import kd.bos.xdb.tablemanager.meta.CreateIndexSqlInfo;
import kd.bos.xdb.tablemanager.meta.IndexColumnString;
import kd.bos.xdb.tablemanager.meta.IndexInfo;
import kd.bos.xdb.tablemanager.meta.PkInfo;

public final class YasdbMetaImpl
extends OracleMetaImpl {
    public static final YasdbMetaImpl instance = new YasdbMetaImpl();

    @Override
    public List<Column> queryColumns(DBRoute dbRoute, String table) {
        table = table.toUpperCase(Locale.ENGLISH);
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        sql.append(" select c.column_name,c.data_type,c.data_length,c.data_precision,c.data_scale,c.nullable,c.data_default,c.column_id,co.comments ");
        sql.append(" from user_tab_columns  c left join user_col_comments co on c.table_name=co.table_name and c.column_name = co.column_name ");
        sql.append(" where c.table_name= ? ");
        ArrayList<String> params = new ArrayList<String>(2);
        params.add(table);
        sql.append(" order by c.column_id ");
        return (List)DB.query((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), (Object[])params.toArray(new String[params.size()]), rs -> {
            ArrayList<Column> columnList = new ArrayList<Column>(50);
            while (rs.next()) {
                Column column = new Column();
                String column_name = rs.getString("column_name");
                String data_type = rs.getString("data_type");
                String data_default = rs.getString("data_default");
                data_default = data_default != null ? data_default.trim() : data_default;
                long data_length = this.parseLongNullAsZero(rs.getString("data_length"));
                int data_precision = this.parseIntNullAsZero(rs.getString("data_precision"));
                int data_scale = this.parseIntNullAsZero(rs.getString("data_scale"));
                boolean nullable = "Y".equals(rs.getString("nullable"));
                int column_id = rs.getInt("column_id");
                String comments = rs.getString("comments");
                column.setColumnId(column_id);
                column.setColumnName(column_name);
                column.setDataType(data_type);
                column.setDataLength(data_length);
                column.setDataPrecision(data_precision);
                column.setDataScale(data_scale);
                column.setNullable(nullable);
                column.setDataDefault((Object)data_default);
                column.setColumnComment(comments);
                columnList.add(column);
            }
            return columnList;
        });
    }

    @Override
    public List<CreateIndexSqlInfo> createIndexSql(DBRoute dbRoute, String table, String likeTable, PkInfo pkInfo, String suffix, String logicSuffix) {
        table = table.toUpperCase(Locale.ENGLISH);
        likeTable = likeTable.toUpperCase(Locale.ENGLISH);
        List<IndexInfo> indexInfoList = this.queryIndexInfos(dbRoute, likeTable);
        ArrayList<CreateIndexSqlInfo> createIndexSqlInfos = new ArrayList<CreateIndexSqlInfo>(indexInfoList.size());
        for (IndexInfo indexInfo : indexInfoList) {
            String indexName = indexInfo.getIndexName();
            if (pkInfo.getIndexName().equalsIgnoreCase(indexName)) continue;
            CreateIndexSqlInfo createIndex = this.assembleCreateIndexSql(indexInfo, table, suffix, logicSuffix);
            createIndexSqlInfos.add(createIndex);
        }
        return createIndexSqlInfos;
    }

    @Override
    public List<IndexInfo> queryIndexInfos(DBRoute dbRoute, String likeTable) {
        likeTable = likeTable.toUpperCase(Locale.ENGLISH);
        StringBuilder queryIndexSql = new StringBuilder();
        queryIndexSql.append("SELECT U.INDEX_NAME, C.COLUMN_NAME,U.UNIQUENESS,U.INDEX_TYPE FROM USER_INDEXES U ");
        queryIndexSql.append("INNER JOIN ALL_IND_COLUMNS C ON U.INDEX_NAME = C.INDEX_NAME AND U.TABLE_OWNER = C.TABLE_OWNER ");
        queryIndexSql.append("WHERE U.TABLE_NAME = ? AND U.GENERATED ='N' ");
        queryIndexSql.append("ORDER BY U.INDEX_NAME, C.COLUMN_POSITION ");
        return (List)DB.query((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(queryIndexSql.toString(), true, true), (Object[])new Object[]{likeTable}, rs -> {
            ArrayList<IndexInfo> indexInfoList = new ArrayList<IndexInfo>(50);
            HashMap<String, IndexInfo> temp = new HashMap<String, IndexInfo>();
            while (rs.next()) {
                String indexName = rs.getString(1);
                String columnName = rs.getString(2);
                if (temp.get(indexName) == null) {
                    IndexInfo indexInfo = new IndexInfo();
                    indexInfoList.add(indexInfo);
                    indexInfo.setIndexName(indexName);
                    String nonUnique = rs.getString(3);
                    String indexType = rs.getString(4);
                    indexInfo.setIndexType(indexType);
                    if ("Y".equalsIgnoreCase(nonUnique)) {
                        indexInfo.setUnique(true);
                    } else {
                        indexInfo.setUnique(false);
                    }
                    temp.put(indexName, indexInfo);
                }
                ((IndexInfo)temp.get(indexName)).addColumn(columnName, true);
            }
            return indexInfoList;
        });
    }

    private CreateIndexSqlInfo assembleCreateIndexSql(IndexInfo indexInfo, String table, String suffix, String logicSuffix) {
        table = table.toUpperCase(Locale.ENGLISH);
        StringBuilder createIndexSql = new StringBuilder(256);
        String oriIndexName = indexInfo.getIndexName();
        createIndexSql.append("CREATE  ");
        if ("FULLTEXT".equalsIgnoreCase(indexInfo.getIndexType())) {
            createIndexSql.append("FULLTEXT ");
        } else if (indexInfo.isUnique()) {
            createIndexSql.append("UNIQUE ");
        }
        String indexName = ArchiveName.of((String)oriIndexName).getArchiveIndex(suffix, logicSuffix);
        createIndexSql.append("INDEX ").append(indexName).append(" ON ").append(table).append(" (");
        int n = indexInfo.getColumnNameList().size();
        for (int i = 0; i < n; ++i) {
            String column = ((IndexColumnString)indexInfo.getColumnNameList().get(i)).getColumn();
            if (i > 0) {
                createIndexSql.append(",");
            }
            createIndexSql.append(column);
        }
        createIndexSql.append(")");
        CreateIndexSqlInfo createIndex = new CreateIndexSqlInfo();
        createIndex.setIndexName(indexName);
        createIndex.setCreateIndexSql(createIndexSql.toString());
        return createIndex;
    }
}

