/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.config;

import kd.bos.archive.entity.ArchiveConfigEntity;
import kd.bos.archive.entity.ArchiveTaskEntity;
import kd.bos.archive.exception.ExceptionUtil;
import kd.bos.archive.framework.plugin.ArchivePlugin;
import kd.bos.archive.framework.plugin.EntityArchivePlugin;
import kd.bos.archive.framework.plugin.TableArchivePlugin;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DBRoute;

public abstract class BaseConfiguration {
    protected ArchiveTaskEntity taskEntity;
    protected ArchiveConfigEntity configEntity;
    protected String mainTable;
    protected String entitynumber;
    protected IDataEntityType rootDT;
    protected DBRoute route;
    protected DBRoute fromRoute;

    public BaseConfiguration(ArchiveTaskEntity taskEntity) {
    }

    public ArchiveTaskEntity getTaskEntity() {
        return this.taskEntity;
    }

    public ArchiveConfigEntity getConfigEntity() {
        return this.configEntity;
    }

    public String getMainTable() {
        return this.mainTable;
    }

    public String getEntitynumber() {
        return this.entitynumber;
    }

    public IDataEntityType getRootDT() {
        return this.rootDT;
    }

    public DBRoute getRoute() {
        return this.route;
    }

    public DBRoute getFromRoute() {
        return this.fromRoute;
    }

    protected ArchivePlugin cast2ArchivePlugin(String archivePluginStr) {
        try {
            Object instance = Class.forName(archivePluginStr).newInstance();
            if (!ArchivePlugin.class.isAssignableFrom(instance.getClass())) {
                throw new ClassCastException(instance.getClass().getSimpleName() + "didn't implement ArchivePlugin.");
            }
            if (EntityArchivePlugin.class.isAssignableFrom(instance.getClass())) {
                return (EntityArchivePlugin)instance;
            }
            if (TableArchivePlugin.class.isAssignableFrom(instance.getClass())) {
                return (TableArchivePlugin)instance;
            }
            return null;
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(new RuntimeException("Class " + archivePluginStr + " cast to ArchivePlugin error."));
        }
    }
}

