/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.config;

import kd.bos.archive.entity.ArchiveTaskEntity;
import kd.bos.archive.enums.ArchiveTaskTypeEnum;
import kd.bos.archive.service.ArchiveService;
import kd.bos.archive.task.config.BaseConfiguration;
import kd.bos.archive.task.config.DBConfiguration;
import kd.bos.archive.task.config.ESConfiguration;
import kd.bos.archive.task.config.WriterConfiguration;
import kd.bos.archive.task.service.elasticsearch.config.ESConfig;

public class ConfigurationFactory {
    public static BaseConfiguration createConfig(ArchiveTaskEntity taskEntity) {
        if (ArchiveService.isLogEntity(taskEntity.getEntitynumber()).booleanValue() && ESConfig.getDcESServer().isEslogEnable()) {
            return new ESConfiguration(taskEntity);
        }
        if (taskEntity.getTasktype() == ArchiveTaskTypeEnum.ARCHIVESYNC) {
            return new WriterConfiguration(taskEntity);
        }
        return new DBConfiguration(taskEntity);
    }
}

