/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.config;

import com.google.common.collect.Multimap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveTaskEntity;
import kd.bos.archive.enums.ArchiveConfigFilterTypeEnum;
import kd.bos.archive.enums.ArchiveTaskTypeEnum;
import kd.bos.archive.exception.ExceptionUtil;
import kd.bos.archive.framework.plugin.ArchivePlugin;
import kd.bos.archive.repository.ArchiveConfigRepository;
import kd.bos.archive.sync.DestinationConfig;
import kd.bos.archive.sync.spi.connection.ConnectionType;
import kd.bos.archive.sync.spi.connection.ConnectionTypeFactory;
import kd.bos.archive.sync.spi.destination.Destination;
import kd.bos.archive.task.config.BaseConfiguration;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.config.ArchiveConfig;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.tablemanager.TableManager;
import kd.bos.xdb.tablemanager.TableName;

public class WriterConfiguration
extends BaseConfiguration {
    private List<ArchiveConfig> configs;
    private Multimap<ArchiveConfig, ArchiveConfig> multimap;
    private TreeSet<ArchiveConfig> sortKey;
    private ArchiveConfig mainArchiveConfig;
    private boolean isXdb;
    private ArchivePlugin archivePlugin;
    private ConnectionType connectionType;
    private DestinationConfig destinationConfig;
    private Destination destination;
    private boolean isSourceDestinationSame;
    private transient Semaphore splitTempCleanSemaphore = new Semaphore(1);

    public WriterConfiguration(ArchiveTaskEntity taskEntity) {
        super(taskEntity);
        this.taskEntity = taskEntity;
        this.entitynumber = taskEntity.getEntitynumber();
        this.configEntity = ArchiveConfigRepository.get().loadConfigToSync(taskEntity.getConfigid());
        this.configs = this.configEntity.toArchiveConfigs();
        this.rootDT = ORMConfiguration.innerGetDataEntityType((String)this.entitynumber, null);
        this.fromRoute = this.route = DBRoute.of((String)this.rootDT.getDBRouteKey());
        this.multimap = this.configEntity.getGroupConfigs(this.configs);
        this.sortKey = this.configEntity.getSortConfigKey(this.multimap);
        this.mainArchiveConfig = this.configs.get(0);
        this.mainTable = this.mainArchiveConfig.getTable();
        if (ArchiveConfigFilterTypeEnum.CUSTOM == this.configEntity.getFilterType()) {
            this.archivePlugin = this.cast2ArchivePlugin(ArchiveUtil.getCondition(this.configEntity));
            if (ArchiveTaskTypeEnum.ARCHIVE == taskEntity.getTasktype() && this.archivePlugin != null) {
                try {
                    this.archivePlugin.callScheduleInfo(taskEntity.getEntitynumber(), taskEntity.getId(), taskEntity.getSchedulercdid(), this.configEntity.getArchiveRoute() + this.configEntity.getLogicSuffix());
                }
                catch (Throwable e) {
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    String error = MessageFormat.format("ArchiveTaskHandler callScheduleInfo error, taskId:{0}, entitynumber:{1}, errorinfo:{2}", taskEntity.getId(), taskEntity.getEntitynumber(), sw.toString());
                    ArchiveUtil.logError(error, e);
                }
            }
        }
        this.isXdb = this.isXdbEntity();
        String targetType = this.configEntity.getTargetType();
        this.connectionType = ConnectionTypeFactory.getConnectionType(targetType);
        if (this.connectionType == null) {
            throw ExceptionUtil.wrap(String.format("the target connect type %s is null,please check your config.", targetType));
        }
    }

    public final boolean isXdbEntity() {
        ShardingConfig mainConfig;
        return DB.isXDBEnable() && (mainConfig = XDBConfig.getShardingConfigProvider().getConfig(this.mainTable)) != null && mainConfig.isEnabled();
    }

    public final long getFirstShardingIndex() throws Exception {
        List<Long> indexList = this.getShardingIndexs();
        if (indexList.isEmpty()) {
            return -1L;
        }
        return indexList.get(0);
    }

    public final long getNextShardingIndex(long curIndex) throws Exception {
        List<Long> indexList = this.getShardingIndexs();
        if (indexList.isEmpty()) {
            return -1L;
        }
        int size = indexList.size();
        int curSize = 0;
        for (int i = 0; i < size; ++i) {
            if (indexList.get(i) != curIndex) continue;
            curSize = i;
            break;
        }
        if (curSize < size - 1) {
            return indexList.get(curSize + 1);
        }
        return -1L;
    }

    public final List<Long> getShardingIndexs() throws Exception {
        if (DB.isXDBEnable()) {
            return (List)DB.__setupExtContextForUsingXdbTableManager((DBRoute)this.getFromRoute(), (boolean)false, () -> {
                TableManager tm = XDBConfig.getTableManager();
                List<String> shardingTables = Arrays.asList(tm.getShardingTable(this.mainTable));
                ArrayList indexList = new ArrayList(1);
                shardingTables.forEach(item -> indexList.add(TableName.of((String)item).getShardingIndex()));
                Collections.sort(indexList);
                return indexList;
            });
        }
        return new ArrayList<Long>(1);
    }

    public List<ArchiveConfig> getConfigs() {
        return this.configs;
    }

    public Multimap<ArchiveConfig, ArchiveConfig> getMultimap() {
        return this.multimap;
    }

    public TreeSet<ArchiveConfig> getSortKey() {
        return this.sortKey;
    }

    public ArchiveConfig getMainArchiveConfig() {
        return this.mainArchiveConfig;
    }

    @Override
    public DBRoute getRoute() {
        return this.route;
    }

    public ArchivePlugin getArchivePlugin() {
        return this.archivePlugin;
    }

    public boolean isXdb() {
        return this.isXdb;
    }

    public void setDestinationConfig(DestinationConfig destinationConfig) {
        this.destinationConfig = destinationConfig;
    }

    public DestinationConfig getDestinationConfig() {
        return this.destinationConfig;
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public Semaphore getSplitTempCleanSemaphore() {
        return this.splitTempCleanSemaphore;
    }

    public void setSourceDestinationSame(boolean sourceDestinationSame) {
        this.isSourceDestinationSame = sourceDestinationSame;
    }

    public boolean isSourceDestinationSame() {
        return this.isSourceDestinationSame;
    }
}

