/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.resultnotify.mq;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.service.config.ArchiveServiceConfig;
import kd.bos.archive.task.resultnotify.mq.ArchiveResultBody;
import kd.bos.archive.task.resultnotify.mq.ArchiveResultNotifyServiceListener;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;

public class ArchiveResultNotifyConsumer
implements MessageConsumer,
ArchiveLogable {
    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        try {
            String str = (String)body;
            if (log.isInfoEnabled() || ArchiveServiceConfig.isEnableLog()) {
                log.info(MessageFormat.format("ArchiveResultNotify ArchiveResultNotifyConsumer body:{0}", str));
            }
            ObjectMapper objectMapper = new ObjectMapper();
            ArchiveResultBody mqBody = (ArchiveResultBody)objectMapper.readValue(str, ArchiveResultBody.class);
            for (ArchiveResultNotifyServiceListener.ArchiveResultNotifyListener notifyListener : ArchiveResultNotifyServiceListener.getClList()) {
                try {
                    String serviceAppId = ServiceLookup.getServiceAppId((String)notifyListener.getAppid());
                    DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)serviceAppId);
                    service.invoke(notifyListener.getFactory(), notifyListener.getServiceName(), "onReceiveResultNotify", new Object[]{mqBody});
                }
                catch (Throwable e) {
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    String error = MessageFormat.format("ArchiveResultNotify ArchiveResultNotifyConsumer invoke error, messageId:{0}, discard:{1}, errorinfo:{2}", messageId, sw.toString());
                    log.error(error, e);
                }
            }
            acker.ack(messageId);
        }
        catch (Throwable e) {
            boolean discard = e instanceof IOException;
            if (discard) {
                acker.discard(messageId);
            } else {
                acker.deny(messageId);
            }
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String error = MessageFormat.format("ArchiveResultNotify ArchiveResultNotifyConsumer onMessage error, messageId:{0}, discard:{1}, errorinfo:{2}", messageId, discard, sw.toString());
            log.error(error, e);
        }
    }
}

