/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.service;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.entity.ArchiveTaskEntity;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.enums.ArchiveTaskStatusEnum;
import kd.bos.archive.enums.ArchiveTaskTypeEnum;
import kd.bos.archive.exception.ArchiveException;
import kd.bos.archive.mq.ArchiveLogPublish;
import kd.bos.archive.repository.ArchiveSplitTaskRepository;
import kd.bos.archive.repository.ArchiveTaskRepository;
import kd.bos.archive.task.config.BaseConfiguration;
import kd.bos.archive.task.config.DBConfiguration;
import kd.bos.archive.task.service.db.split.SplitPkInsertService;
import kd.bos.archive.task.service.db.split.SplitTempCleanService;
import kd.bos.archive.task.service.db.split.move.SplitBarrierService;
import kd.bos.archive.task.service.db.split.move.SplitCrossMoveService;
import kd.bos.archive.task.service.db.split.move.SplitDataCleanService;
import kd.bos.archive.task.service.db.split.move.SplitDataMoveService;

public class SplitTaskContainer {
    private final ArchiveSplitTaskEntity splitTaskEntity;
    private final BaseConfiguration configuration;

    public SplitTaskContainer(ArchiveSplitTaskEntity splitTaskEntity, BaseConfiguration configuration) {
        this.splitTaskEntity = splitTaskEntity;
        this.configuration = configuration;
    }

    public void start() {
        block9: {
            try {
                SplitPkInsertService splitPkInsertService = new SplitPkInsertService(this.splitTaskEntity, (DBConfiguration)this.configuration);
                SplitDataMoveService splitDataMoveService = new SplitDataMoveService(this.splitTaskEntity, (DBConfiguration)this.configuration);
                SplitCrossMoveService splitCrossMoveService = new SplitCrossMoveService(this.splitTaskEntity, (DBConfiguration)this.configuration);
                SplitDataCleanService splitDataCleanService = new SplitDataCleanService(this.splitTaskEntity, (DBConfiguration)this.configuration);
                SplitTempCleanService splitTempCleanService = new SplitTempCleanService(this.splitTaskEntity, (DBConfiguration)this.configuration);
                SplitBarrierService splitBarrierService = new SplitBarrierService(this.splitTaskEntity);
                if (this.configuration.getTaskEntity().getTasktype() == ArchiveTaskTypeEnum.ARCHIVE || this.configuration.getTaskEntity().getTasktype() == ArchiveTaskTypeEnum.UNARCHIVE) {
                    ArchiveTaskEntity curTaskEntity = ArchiveTaskRepository.get().loadTask(this.configuration.getTaskEntity().getId());
                    if (curTaskEntity.getTasknode() == ArchiveTaskNodeEnum.DATACLEAN) {
                        splitDataCleanService.setNext(splitTempCleanService);
                        splitDataCleanService.archive();
                    } else {
                        splitPkInsertService.setNext(splitDataMoveService);
                        splitDataMoveService.setNext(splitCrossMoveService);
                        splitCrossMoveService.setNext(splitBarrierService);
                        splitPkInsertService.archive();
                    }
                    break block9;
                }
                if (this.configuration.getTaskEntity().getTasktype() == ArchiveTaskTypeEnum.DATASYNC) {
                    splitPkInsertService.setNext(splitDataMoveService);
                    splitDataMoveService.setNext(splitDataCleanService);
                    splitDataCleanService.setNext(splitCrossMoveService);
                    splitCrossMoveService.setNext(splitTempCleanService);
                    splitPkInsertService.archive();
                    break block9;
                }
                if (this.configuration.getTaskEntity().getTasktype() == ArchiveTaskTypeEnum.DATACLEAN) {
                    splitPkInsertService.setNext(splitDataCleanService);
                    splitDataCleanService.setNext(splitTempCleanService);
                    splitPkInsertService.archive();
                    break block9;
                }
                throw new ArchiveException("task type miss match");
            }
            catch (Throwable e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                String error = MessageFormat.format("ArchiveTaskHandler SplitTaskContainer error, taskId:{0}, entitynumber:{1}, errorinfo:{2}", this.splitTaskEntity.getId(), this.splitTaskEntity.getEntitynumber(), sw.toString());
                ArchiveUtil.logError(error, e);
                ArchiveSplitTaskEntity curTaskEntity = ArchiveSplitTaskRepository.get().loadSplitTask(this.splitTaskEntity.getId());
                if (ArchiveTaskStatusEnum.UNEXECUTED == curTaskEntity.getTaskstatus()) {
                    ArchiveSplitTaskRepository.get().setNextSplitTaskstatus(this.splitTaskEntity.getId(), ArchiveTaskStatusEnum.UNEXECUTED, ArchiveTaskStatusEnum.FAILED);
                } else {
                    ArchiveSplitTaskRepository.get().setNextSplitTaskstatus(this.splitTaskEntity.getId(), ArchiveTaskStatusEnum.EXECUTING, ArchiveTaskStatusEnum.FAILED);
                }
                ArchiveLogPublish.get().publishLog(this.configuration.getTaskEntity().getId(), this.splitTaskEntity.getEntitynumber(), error, "MOVINGHANDLER");
            }
        }
    }
}

