/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.service;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.text.MessageFormat;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveTaskEntity;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.enums.ArchiveTaskStatusEnum;
import kd.bos.archive.mq.ArchiveLogPublish;
import kd.bos.archive.progress.MainTaskProgress;
import kd.bos.archive.repository.ArchiveTaskRepository;
import kd.bos.archive.service.ArchiveService;
import kd.bos.archive.service.config.ArchiveServiceConfig;
import kd.bos.archive.task.service.IArchiveTask;
import kd.bos.bundle.BosRes;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.threads.ThreadPools;

public abstract class TaskServiceAbst
implements IArchiveTask,
ArchiveLogable {
    protected ArchiveTaskEntity taskEntity;
    protected ArchiveTaskNodeEnum taskNodeEnum;
    public MainTaskProgress mp;
    private TaskServiceAbst next;

    public TaskServiceAbst getNext() {
        return this.next;
    }

    public void setNext(TaskServiceAbst next) {
        this.next = next;
    }

    public TaskServiceAbst(ArchiveTaskEntity taskEntity, ArchiveTaskNodeEnum taskNodeEnum) {
        this.taskEntity = taskEntity;
        this.taskNodeEnum = taskNodeEnum;
    }

    @Override
    public void archive() throws Exception {
        if (log.isInfoEnabled() || ArchiveServiceConfig.isEnableLog()) {
            log.info(MessageFormat.format("ArchiveTaskHandler TaskServiceAbst archive begin,entitynumber:{0}, taskId:{1}, taskNode:{2}", new Object[]{this.taskEntity.getEntitynumber(), this.taskEntity.getId(), this.taskEntity.getTasknode()}));
        }
        this.flushTaskEntity();
        if (this.taskEntity.getTasknode() == this.taskNodeEnum) {
            this.archiveInit();
            if (!this.doArchive()) {
                try {
                    if (this.getNext() != null) {
                        ArchiveUtil.newThreadAndCall(true, () -> {
                            try (TXHandle tx = TX.requiresNew((String)"setNextTaskNode");){
                                ArchiveTaskRepository.get().setNextTaskNode(this.taskEntity.getId(), this.taskEntity.getTasknode(), this.getNext().taskNodeEnum);
                                if (this.taskEntity.getParentid() != 0L && this.getNext().taskNodeEnum == ArchiveTaskNodeEnum.CASCADEBARRIER) {
                                    ArchiveTaskRepository.get().decrBarriercount(this.taskEntity.getParentid());
                                }
                                this.mp.setCurStepExecuted(false);
                                this.mp.setMovingShardingIndex(-1L);
                                this.mp.store(false);
                            }
                            return null;
                        });
                    } else {
                        if (ArchiveTaskNodeEnum.CASCADEBARRIER == this.taskNodeEnum) {
                            ArchiveTaskRepository.get().updateCascade(this.taskEntity.getId());
                        } else {
                            ArchiveTaskRepository.get().setNextTaskNode(this.taskEntity.getId(), this.taskEntity.getTasknode(), ArchiveTaskNodeEnum.TASKEND);
                            ArchiveTaskRepository.get().updateSuccess(this.taskEntity.getId());
                        }
                        ThreadPools.executeOnce((String)"submitChangeTask", () -> {
                            for (int i = 0; i < 3; ++i) {
                                ArchiveService.get().submitChangeTask(this.taskEntity.getEntitynumber());
                                try {
                                    Thread.sleep(21000L);
                                    continue;
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                    }
                    if (ArchiveTaskNodeEnum.TASKSTART != this.taskNodeEnum) {
                        ArchiveLogPublish.get().publishLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), (Object)((Object)this.taskEntity.getTasknode()) + BosRes.get((String)"bos-archive", (String)"ArchiveService_0", (String)"Task Node Execution Completed", (Object[])new Object[0]), this.getProgressType());
                    }
                }
                catch (Throwable e) {
                    if (this.getNext() != null) {
                        ArchiveTaskRepository.get().setNextTaskNode(this.taskEntity.getId(), this.getNext().taskNodeEnum, this.taskEntity.getTasknode());
                    }
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    String error = MessageFormat.format("TaskServiceAbst Setting next step to <{0}> error, taskId:{1}, entitynumber:{2}, errorinfo:{3}", new Object[]{this.getNext().taskNodeEnum, this.taskEntity.getId(), this.taskEntity.getEntitynumber(), sw.toString()});
                    log.error(error, e);
                    ArchiveTaskRepository.get().setNextTaskstatus(this.taskEntity.getId(), ArchiveTaskStatusEnum.EXECUTING, ArchiveTaskStatusEnum.FAILED);
                    ArchiveLogPublish.get().publishLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), error, "TASKSWITCHERROR");
                }
            }
        }
        if (this.getNext() != null) {
            this.getNext().archive();
        }
        if (log.isInfoEnabled() || ArchiveServiceConfig.isEnableLog()) {
            log.info(MessageFormat.format("ArchiveTaskHandler TaskServiceAbst archive end,entitynumber:{0}, taskId:{1}, taskNode:{2}", new Object[]{this.taskEntity.getEntitynumber(), this.taskEntity.getId(), this.taskEntity.getTasknode()}));
        }
    }

    protected void flushTaskEntity() throws SQLException {
        this.taskEntity = ArchiveTaskRepository.get().loadTask(this.taskEntity.getId());
        this.mp = MainTaskProgress.of(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), this.taskEntity.getProgresssign());
        this.mp.setProgressType(this.getProgressType());
    }

    protected abstract boolean doArchive() throws Exception;

    protected void archiveInit() throws SQLException {
    }

    public String getProgressType() {
        return (Object)((Object)this.taskEntity.getTasktype()) + "#" + (Object)((Object)this.taskEntity.getTasknode());
    }
}

