/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.service.db.split;

import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.Semaphore;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveCascadeConfigEntity;
import kd.bos.archive.entity.ArchiveEntityEntity;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.enums.ArchiveTaskTypeEnum;
import kd.bos.archive.repository.ArchiveBasedataRepository;
import kd.bos.archive.repository.ArchiveEntityRepository;
import kd.bos.archive.repository.ArchiveTaskRepository;
import kd.bos.archive.service.config.ArchiveServiceConfig;
import kd.bos.archive.tablemanager.TableManager;
import kd.bos.archive.task.config.DBConfiguration;
import kd.bos.archive.task.service.SplitTaskServiceAbst;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveName;
import kd.bos.db.archive.DBArchiveManager;
import kd.bos.db.archive.config.ArchiveConfig;
import kd.bos.id.ID;

public class SplitTempCleanService
extends SplitTaskServiceAbst {
    private DBConfiguration configuration;

    public SplitTempCleanService(ArchiveSplitTaskEntity splitTaskEntity, DBConfiguration configuration) {
        super(splitTaskEntity, ArchiveTaskNodeEnum.TEMPCLEAN);
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doArchive() throws Exception {
        String mapName;
        String mainSeqMvTable;
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SplitTempCleanService doArchive begin,entitynumber:{0}, taskId:{1}", this.splitTaskEntity.getEntitynumber(), this.splitTaskEntity.getId()));
        long cnt = 0L;
        String string = mainSeqMvTable = ArchiveTaskTypeEnum.UNARCHIVE == this.configuration.getTaskEntity().getTasktype() ? ArchiveName.of((String)this.configuration.getMainTable()).getArchiveTranTable((long)this.splitTaskEntity.getSeq()) : ArchiveName.of((String)this.configuration.getMainTable()).getArchivePkmTable((long)this.splitTaskEntity.getSeq());
        if (!this.mp.isCurStepExecuted()) {
            StringBuilder sql = new StringBuilder();
            sql.append(" select count(*) from ").append(mainSeqMvTable);
            cnt = (Long)DB.query((DBRoute)this.configuration.getFromRoute(), (String)sql.toString(), rs -> {
                if (rs.next()) {
                    return rs.getLong(1);
                }
                return 0L;
            });
            Semaphore sp = this.configuration.getSplitTempCleanSemaphore();
            sp.acquire();
            try {
                Object entityEntity;
                ArchiveTaskRepository.get().incTotalCount(this.configuration.getTaskEntity().getId(), cnt);
                String archiveKey = null;
                if (ArchiveTaskTypeEnum.DATACLEAN != this.configuration.getTaskEntity().getTasktype()) {
                    archiveKey = this.configuration.getConfigEntity().getArchiveRoute() + this.configuration.getConfigEntity().getLogicSuffix();
                }
                if (ArchiveTaskTypeEnum.ARCHIVE == this.configuration.getTaskEntity().getTasktype()) {
                    if (cnt > 0L) {
                        if (this.configuration.isCascadeConfigRoot()) {
                            List<ArchiveCascadeConfigEntity> cascadeConfigList = this.configuration.getCascadeConfigEntity().toArchiveCascadeConfigs();
                            for (ArchiveCascadeConfigEntity iterConfigEntity : cascadeConfigList) {
                                if (iterConfigEntity.getEntitynumber().equalsIgnoreCase(this.splitTaskEntity.getEntitynumber())) continue;
                                this.insertEntity(iterConfigEntity.getEntitynumber(), archiveKey, 0L);
                            }
                        }
                        this.insertEntity(this.splitTaskEntity.getEntitynumber(), archiveKey, cnt);
                    }
                } else if (ArchiveTaskTypeEnum.DATASYNC == this.configuration.getTaskEntity().getTasktype()) {
                    if (cnt > 0L && null == (entityEntity = ArchiveBasedataRepository.get().loadArchiveBasedata(this.splitTaskEntity.getEntitynumber(), archiveKey))) {
                        ArchiveBasedataRepository.get().insertBasedata(this.splitTaskEntity.getEntitynumber(), archiveKey);
                    }
                } else if (ArchiveTaskTypeEnum.UNARCHIVE == this.configuration.getTaskEntity().getTasktype() && cnt > 0L) {
                    entityEntity = ArchiveEntityRepository.get().loadArchiveEntity(this.splitTaskEntity.getEntitynumber(), archiveKey);
                    ArchiveEntityRepository.get().incReverseCount(((ArchiveEntityEntity)entityEntity).getId(), cnt);
                }
                this.mp.setCurStepExecuted(true);
                this.mp.store(false);
            }
            finally {
                sp.release();
            }
        }
        boolean isBack = false;
        StringBuilder sql = new StringBuilder();
        if (this.configuration.getTaskEntity().getTasktype() == ArchiveTaskTypeEnum.UNARCHIVE || this.configuration.getTaskEntity().getTasktype() == ArchiveTaskTypeEnum.ARCHIVE) {
            ArchiveName tn = ArchiveName.of((String)this.configuration.getMainTable());
            String tableNameMapTable = tn.getArchiveMapTable();
            boolean isExist = TableManager.get().existTable(this.configuration.getFromRoute(), tableNameMapTable);
            if (!isExist) {
                TableManager.get().createMapTable(this.configuration.getFromRoute(), this.configuration.getMainTable());
            }
            sql.append("insert into ").append(tableNameMapTable);
            sql.append("(fid ,ftaskid,ftable_name,fmap_name,fcleanstatus)").append(" values (?,?,?,?,?)");
            isBack = true;
        }
        for (ArchiveConfig archiveConfig : this.configuration.getSortKey()) {
            String pkmTable = ArchiveName.of((String)archiveConfig.getTable()).getArchivePkmTable((long)this.splitTaskEntity.getSeq());
            if (ArchiveServiceConfig.isEnableTrantbBack() && isBack && cnt > 0L) {
                mapName = "archi_" + ID.longTo36Radix((long)ID.genLongId()).toLowerCase();
                TableManager.get().backTable(this.configuration.getFromRoute(), pkmTable, mapName);
                DB.execute((DBRoute)this.configuration.getFromRoute(), (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{ID.genLongId(), this.configuration.getTaskEntity().getId(), pkmTable, mapName, Character.valueOf('0')});
                continue;
            }
            TableManager.get().dropTable(this.configuration.getFromRoute(), pkmTable);
        }
        for (ArchiveConfig ac : this.configuration.getConfigs()) {
            String tranTable = ArchiveName.of((String)ac.getTable()).getArchiveTranTable((long)this.splitTaskEntity.getSeq());
            if (ArchiveServiceConfig.isEnableTrantbBack() && isBack && cnt > 0L) {
                mapName = "archi_" + ID.longTo36Radix((long)ID.genLongId()).toLowerCase();
                TableManager.get().backTable(this.configuration.getFromRoute(), tranTable, mapName);
                DB.execute((DBRoute)this.configuration.getFromRoute(), (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{ID.genLongId(), this.configuration.getTaskEntity().getId(), tranTable, mapName, Character.valueOf('0')});
                continue;
            }
            TableManager.get().dropTable(this.configuration.getFromRoute(), tranTable);
        }
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SplitTempCleanService doArchive end,entitynumber:{0}, taskId:{1}", this.splitTaskEntity.getEntitynumber(), this.splitTaskEntity.getId()));
        return false;
    }

    private void insertEntity(String entityNumber, String archiveKey, long archiveCount) {
        ArchiveEntityEntity entityEntity = ArchiveEntityRepository.get().loadArchiveEntity(entityNumber, archiveKey);
        if (null == entityEntity) {
            ArchiveEntityRepository.get().insertEntity(entityNumber, archiveKey, archiveCount, this.configuration.getConfigEntity().getRouteType());
            DBArchiveManager.get().notifyReloadArchiveConfig(entityNumber);
        } else if (archiveCount > 0L) {
            ArchiveEntityRepository.get().incArchiveCount(entityEntity.getId(), archiveCount);
        }
    }
}

