/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.service.db.split.move;

import java.sql.SQLException;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.enums.ArchiveSubTaskTypeEnum;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.enums.ArchiveTaskTypeEnum;
import kd.bos.archive.repository.ArchiveSubTaskRepository;
import kd.bos.archive.tablemanager.TableManager;
import kd.bos.archive.task.config.DBConfiguration;
import kd.bos.archive.task.service.db.split.move.SplitMoveServiceAbst;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveName;
import kd.bos.db.archive.DBArchiveManager;
import kd.bos.db.archive.config.ArchiveConfig;

public class SplitDataCleanService
extends SplitMoveServiceAbst {
    public SplitDataCleanService(ArchiveSplitTaskEntity splitTaskEntity, DBConfiguration configuration) {
        super(splitTaskEntity, ArchiveTaskNodeEnum.DATACLEAN, configuration);
    }

    @Override
    protected void archiveInit() throws SQLException {
        super.archiveInit();
        if (this.configuration.getArchiveIndexDefines() != null && this.configuration.getArchiveIndexDefines().length > 0 && (this.configuration.getTaskEntity().getTasktype() == ArchiveTaskTypeEnum.ARCHIVE || this.configuration.getTaskEntity().getTasktype() == ArchiveTaskTypeEnum.UNARCHIVE)) {
            DBRoute oriRoute = this.configuration.getTaskEntity().getTasktype() == ArchiveTaskTypeEnum.ARCHIVE ? this.configuration.getFromRoute() : this.configuration.getToRoute();
            boolean isExist = TableManager.get().existTable(oriRoute, ArchiveName.of((String)this.configuration.getMainTable()).getArchivePkTable());
            if (!isExist) {
                TableManager.get().createPkTable(oriRoute, this.configuration.getMainTable(), ArchiveUtil.getPkTypeEnum(this.configuration.getEntitynumber()), this.configuration.getArchiveIndexDefines());
                DBArchiveManager.get().notifyReloadArchiveIndexConfig(this.configuration.getEntitynumber());
            }
        }
        for (ArchiveConfig archiveConfig : this.configuration.getSortKey()) {
            if (ArchiveSubTaskRepository.get().checkExistsSubTask(this.splitTaskEntity.getId(), archiveConfig.getTable(), ArchiveSubTaskTypeEnum.CLEAN)) continue;
            ArchiveSubTaskRepository.get().insertSubTask(this.splitTaskEntity.getId(), archiveConfig.getTable(), this.splitTaskEntity.getEntitynumber(), ArchiveSubTaskTypeEnum.CLEAN);
        }
    }
}

