/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.service.db.split.move;

import java.sql.SQLException;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.enums.ArchiveSubTaskTypeEnum;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.enums.ArchiveTaskTypeEnum;
import kd.bos.archive.repository.ArchiveSubTaskRepository;
import kd.bos.archive.tablemanager.TableManager;
import kd.bos.archive.task.config.DBConfiguration;
import kd.bos.archive.task.service.db.split.move.SplitMoveServiceAbst;
import kd.bos.db.archive.ArchiveName;
import kd.bos.db.archive.config.ArchiveConfig;

public class SplitDataMoveService
extends SplitMoveServiceAbst {
    public SplitDataMoveService(ArchiveSplitTaskEntity splitTaskEntity, DBConfiguration configuration) {
        super(splitTaskEntity, ArchiveTaskNodeEnum.DATAMOVE, configuration);
    }

    @Override
    protected void archiveInit() throws SQLException {
        super.archiveInit();
        for (ArchiveConfig archiveConfig : this.configuration.getSortKey()) {
            if (ArchiveSubTaskRepository.get().checkExistsSubTask(this.splitTaskEntity.getId(), archiveConfig.getTable(), ArchiveSubTaskTypeEnum.SAME)) continue;
            ArchiveSubTaskRepository.get().insertSubTask(this.splitTaskEntity.getId(), archiveConfig.getTable(), this.splitTaskEntity.getEntitynumber(), ArchiveSubTaskTypeEnum.SAME);
        }
        for (ArchiveConfig ac : this.configuration.getConfigs()) {
            boolean isExist = TableManager.get().existTable(this.configuration.getFromRoute(), ArchiveName.of((String)ac.getTable()).getArchiveTranTable((long)this.splitTaskEntity.getSeq()));
            if (isExist) continue;
            String likeTable = ac.getTable();
            TableManager.get().createTranTable(this.configuration.getFromRoute(), likeTable, this.splitTaskEntity.getSeq(), this.configuration.getConfigEntity().getLogicSuffix(), this.configuration.getTaskEntity().getTasktype() == ArchiveTaskTypeEnum.UNARCHIVE);
        }
    }
}

