/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.service.db.split.move.work;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import kd.bos.archive.ArchiveConstant;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.entity.ArchiveSubTaskEntity;
import kd.bos.archive.enums.ArchiveSubTaskTypeEnum;
import kd.bos.archive.exception.ExceptionUtil;
import kd.bos.archive.mq.ArchiveLogPublish;
import kd.bos.archive.progress.SubTaskProgress;
import kd.bos.archive.repository.ArchiveSubTaskRepository;
import kd.bos.archive.tablemanager.TableManager;
import kd.bos.archive.task.config.DBConfiguration;
import kd.bos.archive.task.enums.State;
import kd.bos.archive.task.service.db.split.move.work.IWork;
import kd.bos.archive.task.taskgroup.DBWriterAbst;
import kd.bos.archive.task.taskgroup.Reader;
import kd.bos.archive.task.taskgroup.TaskGroupExecutor;
import kd.bos.archive.task.taskgroup.communication.Communication;
import kd.bos.archive.task.taskgroup.split.CrossDataReader;
import kd.bos.archive.task.taskgroup.split.CrossDataWriter;
import kd.bos.archive.task.taskgroup.split.DataCleanWriter;
import kd.bos.archive.task.taskgroup.split.DataMoveWriter;
import kd.bos.archive.task.taskgroup.split.PkKeyTableReader;
import kd.bos.bundle.BosRes;
import kd.bos.db.archive.ArchiveName;
import kd.bos.db.archive.config.ArchiveConfig;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.xdb.tablemanager.meta.Column;

public class SplitMoveWork
implements IWork,
ArchiveLogable {
    protected ArchiveSplitTaskEntity splitTaskEntity;
    protected ArchiveSubTaskEntity subTaskEntity;
    protected DBConfiguration configuration;
    protected SubTaskProgress sp;
    protected Object prePk = null;

    public SplitMoveWork(ArchiveSplitTaskEntity splitTaskEntity, ArchiveSubTaskEntity subTaskEntity, DBConfiguration configuration, SubTaskProgress sp) {
        this.splitTaskEntity = splitTaskEntity;
        this.subTaskEntity = subTaskEntity;
        this.configuration = configuration;
        this.sp = sp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doWork() throws Exception {
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SplitMoveWork begin,entitynumber:{0}, taskType:{1}, taskId:{2}, subTaskId:{3}", this.subTaskEntity.getEntitynumber(), this.subTaskEntity.getTasktype().getKey(), this.splitTaskEntity.getId(), this.subTaskEntity.getId()));
        if (Thread.currentThread().isInterrupted()) {
            ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SplitMoveWork interrupted,entitynumber:{0}, taskType:{1}, taskId:{2}, subTaskId:{3}", this.subTaskEntity.getEntitynumber(), this.subTaskEntity.getTasktype().getKey(), this.splitTaskEntity.getId(), this.subTaskEntity.getId()));
            return false;
        }
        try (TXHandle tx = TX.notSupported((String)"SplitMoveWork.doWork");){
            DBWriterAbst pkWriter;
            Reader pkReader;
            block37: {
                block39: {
                    int c = ArchiveSubTaskRepository.get().updateSubTaskExecuting(this.subTaskEntity.getId());
                    if (c <= 0) {
                        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SplitMoveWork updateSubTaskExecuting error,entitynumber:{0}, taskType:{1},taskId:{2}, subTaskId:{3}", this.subTaskEntity.getEntitynumber(), this.subTaskEntity.getTasktype().getKey(), this.splitTaskEntity.getId(), this.subTaskEntity.getId()));
                        boolean bl = false;
                        return bl;
                    }
                    boolean isContinue = false;
                    if (this.sp.getToPk() != null) {
                        this.prePk = this.sp.getToPk();
                        isContinue = true;
                    }
                    if (!isContinue) break block39;
                    if (ArchiveSubTaskTypeEnum.CLEAN == this.subTaskEntity.getTasktype()) {
                        this.sp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"DataCleanWork_0", (String)"Data cleaning, continue cleaning, task table: {0}, lastIndex: {1}, lastPk: {2}", (Object[])new Object[]{this.subTaskEntity.getMvtable(), this.splitTaskEntity.getIndex(), this.prePk}));
                        break block37;
                    } else if (ArchiveSubTaskTypeEnum.CROSS == this.subTaskEntity.getTasktype()) {
                        this.sp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"CrossMoveWork_0", (String)"Cross-database migration, continue migration, mvtable: {0}, lastIndex: {1}, lastPk: {2}", (Object[])new Object[]{this.subTaskEntity.getMvtable(), this.splitTaskEntity.getIndex(), this.prePk}));
                        break block37;
                    } else {
                        this.sp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"DataMoveWork_0", (String)"Same database migration, continue migration, task table: {0}, lastIndex: {1}, lastPk: {2}", (Object[])new Object[]{this.subTaskEntity.getMvtable(), this.splitTaskEntity.getIndex(), this.prePk}));
                    }
                    break block37;
                }
                if (ArchiveSubTaskTypeEnum.CLEAN == this.subTaskEntity.getTasktype()) {
                    this.sp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"DataCleanWork_1", (String)"Data cleaning, start cleaning, task table: {0}", (Object[])new Object[]{this.subTaskEntity.getMvtable()}));
                } else if (ArchiveSubTaskTypeEnum.CROSS == this.subTaskEntity.getTasktype()) {
                    this.sp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"CrossMoveWork_1", (String)"Cross-database migration, start migration, mvtable: {0}", (Object[])new Object[]{this.subTaskEntity.getMvtable()}));
                } else {
                    this.sp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"DataMoveWork_1", (String)"Same database migration, start migration, task list: {0}", (Object[])new Object[]{this.subTaskEntity.getMvtable()}));
                }
            }
            this.sp.store();
            ArchiveConfig config = this.getArchiveConfig();
            boolean isCross = false;
            if (ArchiveSubTaskTypeEnum.CLEAN == this.subTaskEntity.getTasktype()) {
                pkReader = new PkKeyTableReader(this.splitTaskEntity, this.configuration, config, this.prePk);
                pkWriter = new DataCleanWriter(this.splitTaskEntity, this.configuration, config, this.sp);
            } else if (ArchiveSubTaskTypeEnum.CROSS == this.subTaskEntity.getTasktype()) {
                String pkField = config.getPrimaryKey();
                String tranTable = ArchiveName.of((String)this.subTaskEntity.getMvtable()).getArchiveTranTable((long)this.splitTaskEntity.getSeq());
                String fieldsString = this.getColumns(tranTable, pkField);
                pkReader = new CrossDataReader(this.splitTaskEntity, this.configuration, config, fieldsString, this.prePk);
                pkWriter = new CrossDataWriter(this.splitTaskEntity, this.configuration, config, fieldsString, this.sp);
                pkWriter.setBufferSize(ArchiveConstant.CROSS_INSERT_PAGE_SIZE);
                isCross = true;
            } else {
                pkReader = new PkKeyTableReader(this.splitTaskEntity, this.configuration, config, this.prePk);
                pkWriter = new DataMoveWriter(this.splitTaskEntity, this.configuration, config, this.sp);
            }
            Communication runnerCommunication = new Communication();
            TaskGroupExecutor pkGroupExecutor = TaskGroupExecutor.taskGroup(pkWriter, pkReader, this.configuration, runnerCommunication, "SPLIT#" + this.subTaskEntity.getTasktype().getKey(), isCross);
            pkGroupExecutor.doStart();
            if (runnerCommunication.getState() == State.FAILED) {
                StringWriter sw = new StringWriter();
                runnerCommunication.getThrowable().printStackTrace(new PrintWriter(sw));
                String error = MessageFormat.format("ArchiveTaskHandler SplitMoveWork stateReturnFailed,entitynumber:{0}, taskType:{1}, taskId:{2}, subTaskId:{3}, errorinfo:{4}", this.splitTaskEntity.getEntitynumber(), this.subTaskEntity.getTasktype().getKey(), this.splitTaskEntity.getId(), this.subTaskEntity.getId(), sw.toString());
                ArchiveUtil.logError(error, runnerCommunication.getThrowable());
                ArchiveLogPublish.get().publishLog(this.subTaskEntity.getId(), this.splitTaskEntity.getEntitynumber(), error, "SPLIT#" + this.subTaskEntity.getTasktype().getKey());
                throw ExceptionUtil.asRuntimeException(sw.toString(), runnerCommunication.getThrowable());
            }
            if (ArchiveSubTaskTypeEnum.CLEAN == this.subTaskEntity.getTasktype()) {
                this.sp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"DataCleanWork_5", (String)"Data cleaning, task table: {0}, cleaning completed", (Object[])new Object[]{this.subTaskEntity.getMvtable()}));
            } else if (ArchiveSubTaskTypeEnum.CROSS == this.subTaskEntity.getTasktype()) {
                this.sp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"CrossMoveWork_6", (String)"Cross-database migration, mvtable: {0}, migration completed", (Object[])new Object[]{this.subTaskEntity.getMvtable()}));
            } else {
                this.sp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"DataMoveWork_6", (String)"Same database migration, task table: {0}, migration completed", (Object[])new Object[]{this.subTaskEntity.getMvtable()}));
            }
            this.sp.setExecSql(null);
            this.sp.store();
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String runtimeException = sw.toString();
            ArchiveUtil.logError(MessageFormat.format("ArchiveTaskHandler SplitMoveWork error, entitynumber:{0}, taskType:{1}, taskId:{2}, subTaskId:{3}, errorinfo:{4}", this.splitTaskEntity.getEntitynumber(), this.subTaskEntity.getTasktype().getKey(), this.splitTaskEntity.getId(), this.subTaskEntity.getId(), runtimeException), e);
            ArchiveSubTaskRepository.get().setSubTaskFailedBySubTaskId(this.subTaskEntity.getId());
            throw ExceptionUtil.asRuntimeException(runtimeException, e);
        }
        ArchiveSubTaskRepository.get().updateSubTaskSuccess(this.subTaskEntity.getId());
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SplitMoveWork end,entitynumber:{0}, taskType:{1}, taskId:{2}, subTaskId:{3}", this.subTaskEntity.getEntitynumber(), this.subTaskEntity.getTasktype().getKey(), this.splitTaskEntity.getId(), this.subTaskEntity.getId()));
        return false;
    }

    private ArchiveConfig getArchiveConfig() {
        for (ArchiveConfig config : this.configuration.getConfigs()) {
            if (!config.getTable().equalsIgnoreCase(this.subTaskEntity.getMvtable())) continue;
            return config;
        }
        throw new RuntimeException(this.subTaskEntity.getMvtable() + ":ArchiveConfigruntime is null.");
    }

    private String getColumns(String table, String pkField) throws SQLException {
        List<Column> columnList = TableManager.get().getColumns(this.configuration.getFromRoute(), table);
        StringBuilder columnStr = new StringBuilder();
        int n = columnList.size();
        for (int i = 0; i < n; ++i) {
            String columnName = columnList.get(i).getColumnName();
            if (columnName.equalsIgnoreCase(pkField)) {
                if (i != n - 1) continue;
                columnStr.delete(columnStr.length() - 1, columnStr.length());
                continue;
            }
            columnStr.append(columnList.get(i).getColumnName());
            if (i == n - 1) continue;
            columnStr.append(',');
        }
        columnStr.insert(0, pkField + ',');
        return columnStr.toString();
    }
}

