/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.service.elasticsearch;

import java.text.MessageFormat;
import java.util.List;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveEntityEntity;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.entity.ArchiveTaskEntity;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.enums.ArchiveTaskTypeEnum;
import kd.bos.archive.repository.ArchiveEntityRepository;
import kd.bos.archive.repository.ArchiveSplitTaskRepository;
import kd.bos.archive.repository.ArchiveTaskRepository;
import kd.bos.archive.task.config.ESConfiguration;
import kd.bos.archive.task.service.TaskServiceAbst;
import kd.bos.db.archive.DBArchiveManager;

public class EsTempCleanService
extends TaskServiceAbst {
    private ESConfiguration configuration;

    public EsTempCleanService(ArchiveTaskEntity taskEntity, ESConfiguration configuration) {
        super(taskEntity, ArchiveTaskNodeEnum.TEMPCLEAN);
        this.configuration = configuration;
    }

    @Override
    public boolean doArchive() throws Exception {
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler EsTempCleanService doArchive begin,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
        if (!this.mp.isCurStepExecuted() && this.taskEntity.getTasktype() == ArchiveTaskTypeEnum.ARCHIVE) {
            StringBuilder sql = new StringBuilder();
            List<ArchiveSplitTaskEntity> splitTaskEntities = ArchiveSplitTaskRepository.get().loadSplitTaskList(this.taskEntity.getId());
            long cnt = splitTaskEntities.stream().mapToLong(ArchiveSplitTaskEntity::getPagesize).sum();
            ArchiveTaskRepository.get().incTotalCount(this.configuration.getTaskEntity().getId(), cnt);
            String archiveKey = this.configuration.getConfigEntity().getArchiveRoute() + this.configuration.getConfigEntity().getLogicSuffix();
            if (cnt > 0L) {
                ArchiveEntityEntity entityEntity = ArchiveEntityRepository.get().loadArchiveEntity(this.taskEntity.getEntitynumber(), archiveKey);
                if (null == entityEntity) {
                    ArchiveEntityRepository.get().insertEntity(this.taskEntity.getEntitynumber(), archiveKey, cnt, this.configuration.getConfigEntity().getRouteType());
                    DBArchiveManager.get().notifyReloadArchiveConfig(this.taskEntity.getEntitynumber());
                } else {
                    ArchiveEntityRepository.get().incArchiveCount(entityEntity.getId(), cnt);
                }
            }
            this.mp.setCurStepExecuted(true);
            this.mp.store(false);
        }
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler EsTempCleanService doArchive end,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
        return false;
    }
}

