/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.service.elasticsearch;

import kd.bos.archive.task.config.ESConfiguration;

public class IndexNameUtil {
    static final String SCHEMA_PREFIX = "log-";
    static final String SCHEMA_PREFIX_ARCHIVE = "log-archive-";

    public static String getAcountIndexPrefix(ESConfiguration configuration, boolean isArchive) {
        return (isArchive ? SCHEMA_PREFIX_ARCHIVE : SCHEMA_PREFIX) + configuration.getDcESConfig().getAccountNumber() + IndexNameUtil.getArchiveIndexIdent(configuration, isArchive);
    }

    public static String getTableIndexPrefix(ESConfiguration configuration, boolean isArchive) {
        return IndexNameUtil.getAcountIndexPrefix(configuration, isArchive) + '-' + configuration.getMainTable() + '-';
    }

    public static String getTableIndex(ESConfiguration configuration, String dateSuffix, boolean isArchive) {
        return IndexNameUtil.getTableIndexPrefix(configuration, isArchive) + dateSuffix;
    }

    public static String getArchiveIndexIdent(ESConfiguration configuration, boolean isAschive) {
        if (!isAschive) {
            return "";
        }
        String logicSuffix = configuration.getConfigEntity().getLogicSuffix();
        int indexLg = logicSuffix.indexOf("$");
        if (indexLg != -1) {
            logicSuffix = logicSuffix.substring(indexLg + 1);
        }
        return '-' + logicSuffix;
    }
}

