/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.service.elasticsearch.config;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.JestResult;
import io.searchbox.client.config.HttpClientConfig;
import io.searchbox.core.Bulk;
import io.searchbox.core.Cat;
import io.searchbox.indices.CreateIndex;
import io.searchbox.indices.DeleteIndex;
import io.searchbox.indices.IndicesExists;
import io.searchbox.indices.aliases.AddAliasMapping;
import io.searchbox.indices.aliases.AliasMapping;
import io.searchbox.indices.aliases.GetAliases;
import io.searchbox.indices.aliases.ModifyAliases;
import io.searchbox.indices.aliases.RemoveAliasMapping;
import io.searchbox.indices.mapping.PutMapping;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESClient {
    private static final Logger log = LoggerFactory.getLogger(ESClient.class);
    private JestClient jestClient;

    public JestClient getClient() {
        return this.jestClient;
    }

    public void createClient(List<String> endpoint, String user, String passwd, boolean multiThread, int readTimeout, boolean discovery) {
        JestClientFactory factory = new JestClientFactory();
        HttpClientConfig.Builder httpClientConfig = (HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)new HttpClientConfig.Builder(endpoint).multiThreaded(multiThread)).connTimeout(30000)).readTimeout(readTimeout)).maxTotalConnection(200).discoveryEnabled(discovery)).discoveryFrequency(5L, TimeUnit.MINUTES);
        if (!"".equals(user) && !"".equals(passwd)) {
            httpClientConfig.defaultCredentials(user, passwd);
        }
        factory.setHttpClientConfig(httpClientConfig.build());
        this.jestClient = factory.getObject();
    }

    public boolean indicesExists(String indexName) throws Exception {
        boolean isIndicesExists = false;
        JestResult rst = this.jestClient.execute((Action)new IndicesExists.Builder(indexName).build());
        if (rst.isSucceeded()) {
            isIndicesExists = true;
        } else {
            switch (rst.getResponseCode()) {
                case 404: {
                    isIndicesExists = false;
                    break;
                }
                default: {
                    log.warn(rst.getErrorMessage());
                }
            }
        }
        return isIndicesExists;
    }

    public boolean deleteIndex(String indexName) throws Exception {
        log.info("delete index " + indexName);
        if (this.indicesExists(indexName)) {
            JestResult rst = this.jestClient.execute((Action)new DeleteIndex.Builder(indexName).build());
            if (!rst.isSucceeded()) {
                return false;
            }
        } else {
            log.info("index cannot found, skip delete " + indexName);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean createIndex(String indexName, String typeName, Object mappings, String settings, boolean dynamic) throws Exception {
        int idx;
        JestResult rst = null;
        if (!this.indicesExists(indexName)) {
            log.info("create index " + indexName);
            rst = this.jestClient.execute((Action)((CreateIndex.Builder)new CreateIndex.Builder(indexName).settings(settings).setParameter("master_timeout", (Object)"5m")).build());
            if (!rst.isSucceeded()) {
                if (this.getStatus(rst) == 400) {
                    log.info(String.format("index [%s] already exists", indexName));
                    return true;
                }
                log.error(rst.getErrorMessage());
                return false;
            }
            log.info(String.format("create [%s] index success", indexName));
        }
        for (idx = 0; idx < 5 && !this.indicesExists(indexName); ++idx) {
            Thread.sleep(2000L);
        }
        if (idx >= 5) {
            return false;
        }
        if (dynamic) {
            log.info("ignore mappings");
            return true;
        }
        log.info("create mappings for " + indexName + "  " + mappings);
        rst = this.jestClient.execute((Action)((PutMapping.Builder)new PutMapping.Builder(indexName, typeName, mappings).setParameter("master_timeout", (Object)"5m")).build());
        if (rst.isSucceeded()) {
            log.info(String.format("index [%s] put mappings success", indexName));
            return true;
        }
        if (this.getStatus(rst) == 400) {
            log.info(String.format("index [%s] mappings already exists", indexName));
            return true;
        }
        log.error(rst.getErrorMessage());
        return false;
    }

    public <T extends JestResult> T execute(Action<T> clientRequest) throws Exception {
        JestResult rst = null;
        rst = this.jestClient.execute(clientRequest);
        if (!rst.isSucceeded()) {
            // empty if block
        }
        return (T)rst;
    }

    public Integer getStatus(JestResult rst) {
        JsonObject jsonObject = rst.getJsonObject();
        if (jsonObject.has("status")) {
            return jsonObject.get("status").getAsInt();
        }
        return 600;
    }

    public boolean isBulkResult(JestResult rst) {
        JsonObject jsonObject = rst.getJsonObject();
        return jsonObject.has("items");
    }

    public boolean alias(String indexname, String aliasname, boolean needClean) throws IOException {
        ModifyAliases modifyAliases;
        GetAliases getAliases = ((GetAliases.Builder)new GetAliases.Builder().addIndex(aliasname)).build();
        AddAliasMapping addAliasMapping = new AddAliasMapping.Builder(indexname, aliasname).build();
        JestResult rst = this.jestClient.execute((Action)getAliases);
        log.info(rst.getJsonString());
        ArrayList<RemoveAliasMapping> list = new ArrayList<RemoveAliasMapping>();
        if (rst.isSucceeded()) {
            JsonParser jp = new JsonParser();
            JsonObject jo = (JsonObject)jp.parse(rst.getJsonString());
            for (Map.Entry entry : jo.entrySet()) {
                String tindex = (String)entry.getKey();
                if (indexname.equals(tindex)) continue;
                RemoveAliasMapping m = new RemoveAliasMapping.Builder(tindex, aliasname).build();
                String s = new Gson().toJson((Object)m.getData());
                log.info(s);
                if (!needClean) continue;
                list.add(m);
            }
        }
        if (!(rst = this.jestClient.execute((Action)(modifyAliases = ((ModifyAliases.Builder)new ModifyAliases.Builder((AliasMapping)addAliasMapping).addAlias(list).setParameter("master_timeout", (Object)"5m")).build()))).isSucceeded()) {
            log.error(rst.getErrorMessage());
            return false;
        }
        return true;
    }

    public JestResult bulkInsert(Bulk.Builder bulk, int trySize) throws Exception {
        JestResult rst = null;
        rst = this.jestClient.execute((Action)bulk.build());
        if (!rst.isSucceeded()) {
            log.warn(rst.getErrorMessage());
        }
        return rst;
    }

    public JestResult catIndices(String indexname) throws Exception {
        JestResult jestResult = this.jestClient.execute((Action)((Cat.IndicesBuilder)new Cat.IndicesBuilder().addIndex(indexname)).build());
        if (!jestResult.isSucceeded()) {
            log.warn(jestResult.getErrorMessage());
        }
        return jestResult;
    }

    public void closeJestClient() {
        if (this.jestClient != null) {
            this.jestClient.shutdownClient();
        }
    }
}

