/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.service.elasticsearch.split;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import kd.bos.archive.ArchiveConstant;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.exception.ExceptionUtil;
import kd.bos.archive.mq.ArchiveLogPublish;
import kd.bos.archive.task.config.ESConfiguration;
import kd.bos.archive.task.enums.State;
import kd.bos.archive.task.service.SplitTaskServiceAbst;
import kd.bos.archive.task.service.elasticsearch.IndexNameUtil;
import kd.bos.archive.task.taskgroup.TaskGroupExecutor;
import kd.bos.archive.task.taskgroup.communication.Communication;
import kd.bos.archive.task.taskgroup.elasticsearch.EsCrossDataReader;
import kd.bos.archive.task.taskgroup.elasticsearch.EsCrossDataWriter;
import kd.bos.bundle.BosRes;

public class SplitEsCrossMoveService
extends SplitTaskServiceAbst {
    private ESConfiguration configuration;

    public SplitEsCrossMoveService(ArchiveSplitTaskEntity splitTaskEntity, ESConfiguration configuration) {
        super(splitTaskEntity, ArchiveTaskNodeEnum.CROSSMOVE);
        this.configuration = configuration;
    }

    @Override
    public boolean doArchive() throws Exception {
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SplitEsCrossMoveService doArchive begin,entitynumber:{0}, splitTaskId:{1}", this.splitTaskEntity.getEntitynumber(), this.splitTaskEntity.getId()));
        ESConfiguration esConfiguration = this.configuration;
        String indexName = IndexNameUtil.getTableIndex(esConfiguration, String.valueOf(this.splitTaskEntity.getIndex()), false);
        boolean isContinue = false;
        Object prePk = null;
        if (this.mp.getToPk() != null) {
            prePk = this.mp.getToPk();
            isContinue = true;
        }
        if (isContinue) {
            this.mp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"SplitEsCrossMoveService_0", (String)"ES archive dump, continue migration, index: {0}, lastPk: {2}", (Object[])new Object[]{indexName, prePk}));
        } else {
            this.mp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"SplitEsCrossMoveService_1", (String)"ES archive dump, start migration, index: {0}", (Object[])new Object[]{indexName}));
        }
        EsCrossDataReader pkReader = new EsCrossDataReader(this.splitTaskEntity, esConfiguration, prePk);
        EsCrossDataWriter pkWriter = new EsCrossDataWriter(this.splitTaskEntity, esConfiguration, this.mp);
        pkWriter.setBufferSize(ArchiveConstant.ES_CROSS_INSERT_PAGE_SIZE);
        Communication runnerCommunication = new Communication();
        TaskGroupExecutor pkGroupExecutor = TaskGroupExecutor.taskGroup(pkWriter, pkReader, this.configuration, runnerCommunication, "SPLIT#" + this.splitTaskEntity.getTasknode().getKey(), true);
        pkGroupExecutor.doStart();
        if (runnerCommunication.getState() == State.FAILED) {
            StringWriter sw = new StringWriter();
            runnerCommunication.getThrowable().printStackTrace(new PrintWriter(sw));
            String error = MessageFormat.format("ArchiveTaskHandler SplitEsCrossMoveService stateReturnFailed,entitynumber:{0}, taskId:{1}, errorinfo:{2}", this.splitTaskEntity.getEntitynumber(), this.splitTaskEntity.getId(), sw.toString());
            ArchiveUtil.logError(error, runnerCommunication.getThrowable());
            ArchiveLogPublish.get().publishLog(this.splitTaskEntity.getId(), this.splitTaskEntity.getEntitynumber(), error, "SPLIT#" + this.splitTaskEntity.getTasknode().getKey());
            throw ExceptionUtil.asRuntimeException(sw.toString(), runnerCommunication.getThrowable());
        }
        this.mp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"SplitEsCrossMoveService_2", (String)"ES archive dump, index: {0}, migration complete", (Object[])new Object[]{indexName}));
        this.mp.setToPk(null);
        this.mp.store();
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SplitEsCrossMoveService doArchive  end,entitynumber:{0}, taskId:{1}", this.splitTaskEntity.getEntitynumber(), this.splitTaskEntity.getId()));
        return false;
    }
}

