/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.service.elasticsearch.split;

import io.searchbox.indices.DeleteIndex;
import java.text.MessageFormat;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.exception.ExceptionUtil;
import kd.bos.archive.mq.ArchiveLogPublish;
import kd.bos.archive.task.config.ESConfiguration;
import kd.bos.archive.task.service.SplitTaskServiceAbst;
import kd.bos.archive.task.service.elasticsearch.IndexNameUtil;
import kd.bos.bundle.BosRes;

public class SplitEsDataCleanService
extends SplitTaskServiceAbst {
    private ESConfiguration configuration;

    public SplitEsDataCleanService(ArchiveSplitTaskEntity splitTaskEntity, ESConfiguration configuration) {
        super(splitTaskEntity, ArchiveTaskNodeEnum.DATACLEAN);
        this.configuration = configuration;
    }

    @Override
    public boolean doArchive() throws Exception {
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SplitEsDataCleanService doArchive begin,entitynumber:{0}, splitTaskId:{1}", this.splitTaskEntity.getEntitynumber(), this.splitTaskEntity.getId()));
        String indexName = IndexNameUtil.getTableIndex(this.configuration, String.valueOf(this.splitTaskEntity.getIndex()), false);
        this.mp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"SplitEsDataCleanService_0", (String)"Index cleanup, index name: {0}", (Object[])new Object[]{indexName}));
        this.mp.store();
        if (this.configuration.getEsClient().indicesExists(indexName)) {
            Object rst = this.configuration.getEsClient().execute(new DeleteIndex.Builder(indexName).build());
            if (!rst.isSucceeded()) {
                String error = MessageFormat.format("ArchiveTaskHandler SplitEsDataCleanService doArchive Failed,entitynumber:{0}, taskId:{1}, errorinfo:{2}", this.splitTaskEntity.getEntitynumber(), this.splitTaskEntity.getId(), rst.getErrorMessage());
                ArchiveUtil.logInfo(error);
                ArchiveLogPublish.get().publishLog(this.splitTaskEntity.getId(), this.splitTaskEntity.getEntitynumber(), error, this.getProgressType());
                throw ExceptionUtil.asRuntimeException(new RuntimeException(error));
            }
            this.mp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"SplitEsDataCleanService_1", (String)"Index cleanup, index name: {0}, cleanup completed", (Object[])new Object[0]));
        } else {
            this.mp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"SplitEsDataCleanService_2", (String)"Index cleanup, index name: {0}, index does not exist", (Object[])new Object[0]));
        }
        this.mp.setToPk(null);
        this.mp.store();
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SplitEsDataCleanService doArchive  end,entitynumber:{0}, taskId:{1}", this.splitTaskEntity.getEntitynumber(), this.splitTaskEntity.getId()));
        return false;
    }
}

