/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.taskgroup.elasticsearch;

import io.searchbox.core.Bulk;
import io.searchbox.core.Index;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.exception.ExceptionUtil;
import kd.bos.archive.mq.ArchiveLogPublish;
import kd.bos.archive.progress.IProgress;
import kd.bos.archive.task.config.ESConfiguration;
import kd.bos.archive.task.service.elasticsearch.IndexNameUtil;
import kd.bos.archive.task.taskgroup.WriterAbst;
import kd.bos.archive.transport.record.RowRecord;
import kd.bos.bundle.BosRes;

public class EsCrossDataWriter
extends WriterAbst {
    private ESConfiguration configuration;
    private ArchiveSplitTaskEntity splitTaskEntity;
    private String indexName;
    private String oriIndexName;

    public EsCrossDataWriter(ArchiveSplitTaskEntity splitTaskEntity, ESConfiguration configuration, IProgress progress) {
        super(configuration, progress);
        this.splitTaskEntity = splitTaskEntity;
        this.configuration = configuration;
        this.indexName = IndexNameUtil.getTableIndex(this.configuration, String.valueOf(splitTaskEntity.getIndex()), true);
        this.oriIndexName = IndexNameUtil.getTableIndex(this.configuration, String.valueOf(splitTaskEntity.getIndex()), false);
    }

    @Override
    public void doBatchInsert(List<RowRecord> writerBuffer) throws SQLException {
        Object fromPK = writerBuffer.get(0).getPk();
        Object toPK = writerBuffer.get(writerBuffer.size() - 1).getPk();
        int bufferSize = writerBuffer.size();
        ArrayList<Index> indexList = new ArrayList<Index>(bufferSize);
        for (RowRecord rowRecord : writerBuffer) {
            String fid = rowRecord.getPk().toString();
            Object source = rowRecord.getColumns()[0];
            indexList.add(((Index.Builder)new Index.Builder(source).id(fid)).build());
        }
        Bulk bulk = new Bulk.Builder().defaultIndex(this.indexName).defaultType("_doc").addAction(indexList).build();
        try {
            Object bulkResult = this.configuration.getEsArchiveClient().execute(bulk);
            if (!bulkResult.isSucceeded()) {
                String error = MessageFormat.format("ArchiveTaskHandler EsCrossDataWriter Failed,entitynumber:{0}, taskId:{1}, errorinfo:{2}", this.splitTaskEntity.getEntitynumber(), this.splitTaskEntity.getId(), bulkResult.getErrorMessage());
                ArchiveUtil.logInfo(error);
                ArchiveLogPublish.get().publishLog(this.splitTaskEntity.getId(), this.splitTaskEntity.getEntitynumber(), error, "SPLIT#" + this.splitTaskEntity.getTasknode().getKey());
                throw ExceptionUtil.asRuntimeException(new RuntimeException(error));
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
        this.progress.setProgressDesc_2(BosRes.get((String)"bos-archive", (String)"EsCrossDataWriter_0", (String)"ES archive migration, index: {0}, fromPK={1}, toPK={2}, size={3}", (Object[])new Object[]{this.oriIndexName, fromPK, toPK, bufferSize}));
        this.progress.setToPk(toPK);
        this.progress.store();
    }
}

