/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.taskgroup.pk;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.archive.ArchiveConstant;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.enums.ArchiveTaskTypeEnum;
import kd.bos.archive.task.config.DBConfiguration;
import kd.bos.archive.task.taskgroup.Reader;
import kd.bos.archive.transport.exchanger.RecordSender;
import kd.bos.archive.transport.record.RowRecord;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveName;
import kd.bos.orm.ORM;

public class PkCascadeReader
implements Reader {
    private DBConfiguration configuration;
    private Object lastPk;
    private String mainMvTable;
    private String mainTable;
    private String joinField;
    private String pkField;

    public PkCascadeReader(DBConfiguration configuration, Object lastPk) {
        this.configuration = configuration;
        this.lastPk = lastPk;
        this.mainMvTable = ArchiveName.of((String)ORM.create().getDataEntityType(configuration.getParentCascadeConfigEntity().getEntitynumber()).getAlias()).getArchivePkmTable((long)configuration.getConfigEntity().getSuffix());
        this.mainTable = configuration.getMainTable() + (configuration.getTaskEntity().getTasktype() == ArchiveTaskTypeEnum.ARCHIVE ? "" : configuration.getConfigEntity().getLogicSuffix());
        this.joinField = ((IDataEntityProperty)configuration.getRootDT().getProperties().get((Object)configuration.getCascadeConfigEntity().getJoinfield())).getAlias();
        this.pkField = configuration.getRootDT().getPrimaryKey().getAlias();
    }

    @Override
    public void startRead(RecordSender recordSender) {
        AtomicInteger finalSize;
        Object fromPK = this.lastPk;
        do {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            ArrayList<Object> paramList = new ArrayList<Object>(2);
            StringBuilder sql = new StringBuilder(128);
            sql.append("select top ").append(ArchiveConstant.PAGE_SIZE).append(" B.").append(this.pkField);
            sql.append(" from ").append(this.mainMvTable);
            sql.append(" A inner join ").append(this.mainTable);
            sql.append(" B on B.").append(this.joinField).append(" = ").append("A.fid");
            if (fromPK != null) {
                sql.append(" where ");
                sql.append(" B.").append(this.pkField).append(" > ? ");
                paramList.add(fromPK);
            }
            sql.append(" order by ").append(" B.").append(this.pkField).append(" asc ");
            String s = ArchiveUtil.wrapSQL(sql.toString(), false, false);
            finalSize = new AtomicInteger();
            try (DataSet dataSet = DB.queryDataSet((String)"PkSplitDbReader", (DBRoute)this.configuration.getFromRoute(), (String)s, (Object[])paramList.toArray());){
                for (Row row : dataSet) {
                    Object pkValue;
                    RowRecord rowRecord = new RowRecord(1);
                    fromPK = pkValue = row.get(0);
                    rowRecord.setPk(pkValue);
                    rowRecord.setColumn(0, pkValue);
                    recordSender.sendToWriter(rowRecord);
                    finalSize.getAndIncrement();
                }
            }
        } while (finalSize.get() >= ArchiveConstant.PAGE_SIZE);
    }
}

