/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.taskgroup.pk;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.enums.ArchiveTaskTypeEnum;
import kd.bos.archive.progress.IProgress;
import kd.bos.archive.task.config.DBConfiguration;
import kd.bos.archive.task.taskgroup.DBWriterAbst;
import kd.bos.archive.transport.record.RowRecord;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.SqlBuilder;
import kd.bos.db.archive.ArchiveName;
import kd.bos.db.archive.config.ArchiveConfig;
import kd.bos.db.archive.config.MainArchiveConfig;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBExternal;
import kd.bos.xdb.cache.Cache;
import kd.bos.xdb.cache.CacheContext;
import kd.bos.xdb.engine.ShardingContext;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.bos.xdb.sharding.sql.StatementType;
import kd.bos.xdb.sharding.strategy.AbstractShardingStrategy;

public class PkReverseWriter
extends DBWriterAbst {
    private ShardingConfig mainShardingConfig;
    private String[] fields;
    private FilterType[] fts;
    private AbstractShardingStrategy mainShardingStrategy;
    private int bufferSize;
    private int loop = 0;

    public PkReverseWriter(DBConfiguration configuration, IProgress progress) {
        super(configuration, progress);
        if (this.configuration.isXdb()) {
            this.mainShardingConfig = XDBConfig.getShardingConfigProvider().getConfig(this.configuration.getMainTable());
            this.fields = this.mainShardingConfig.getShardingFields();
            this.fts = new FilterType[this.fields.length];
            for (int i = 0; i < this.fields.length; ++i) {
                this.fts[i] = FilterType.eq;
            }
            this.mainShardingStrategy = (AbstractShardingStrategy)this.mainShardingConfig.getShardingStrategy();
            try (XDBExternal xdbe = XDBExternal.notSupportedAlways((String)"PkReverseWriter");
                 Cache cc = CacheContext.get().createExecutorCache();){
                DB.__setupExtContextForUsingXdbTableManager((DBRoute)this.configuration.getToRoute(), (boolean)false, () -> {
                    this.mainShardingStrategy.ensureTableInited();
                    return null;
                });
            }
            catch (Exception e) {
                throw ExceptionUtil.asRuntimeException((Throwable)e);
            }
        }
    }

    @Override
    public void doBatchInsert(List<RowRecord> writerBuffer) throws SQLException {
        this.bufferSize = writerBuffer.size();
        if (this.configuration.isXdb()) {
            List<Object> pks = writerBuffer.stream().map(RowRecord::getPk).collect(Collectors.toList());
            List<RowRecord> rowRecordList = this.queryShardValues(pks);
            try (XDBExternal xdbe = XDBExternal.notSupportedAlways((String)"PkReverseWriter.doBatchInsert");
                 Cache cc = CacheContext.get().createExecutorCache();
                 ShardingContext ctx = ShardingContext.create();){
                ctx.setStatementType(StatementType.insert);
                DB.__setupExtContextForUsingXdbTableManager((DBRoute)this.configuration.getToRoute(), (boolean)false, () -> {
                    rowRecordList.forEach(item -> item.setIndex(this.mainShardingStrategy.shardingIndex(this.fts, item.getColumns())[0]));
                    return null;
                });
            }
            catch (Exception e) {
                throw ExceptionUtil.asRuntimeException((Throwable)e);
            }
            writerBuffer = rowRecordList;
        }
        if (writerBuffer.isEmpty()) {
            return;
        }
        ArchiveName mainTN = ArchiveName.of((String)this.configuration.getMainTable());
        String mainMvTable = mainTN.getArchivePkmTable((long)this.configuration.getConfigEntity().getSuffix());
        List paramsList = writerBuffer.stream().map(RowRecord::getPkAndIndex).collect(Collectors.toList());
        StringBuilder sql = new StringBuilder(128);
        sql.setLength(0);
        if (DBType.MySQL == this.dbType) {
            sql.append("replace into ").append(mainMvTable).append("(fid,findex) values(?,?)");
        } else {
            if (this.progress.isNeedDel()) {
                this.deleteDuplicate(mainMvTable, "fid", writerBuffer.stream().map(RowRecord::getPk).collect(Collectors.toList()));
            }
            sql.append("insert into ").append(mainMvTable).append("(fid,findex) values(?,?)");
        }
        DB.executeBatch((DBRoute)this.configuration.getFromRoute(), (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), paramsList);
        Object lastPk = writerBuffer.get(this.bufferSize - 1).getPk();
        if (this.progress.isNeedDel()) {
            ++this.loop;
            if (this.loop > 3) {
                this.progress.setNeedDel(false);
            }
        }
        this.progress.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"ArchivePkInsertService_5", (String)"pk intermediate table data generation:fromPK={0}, toPK={1}, pks={2}", (Object[])new Object[]{writerBuffer.get(0).getPk(), lastPk, this.bufferSize}));
        this.progress.setToPk(lastPk);
        this.progress.store();
    }

    private List<RowRecord> queryShardValues(List<Object> pks) {
        String pkField = this.configuration.getRootDT().getPrimaryKey().getAlias();
        String fieldsAppend = ArchiveUtil.joinArray(this.fields, ",");
        String fromTable = this.configuration.getMainTable();
        boolean isArchive = this.configuration.getTaskEntity().getTasktype() != ArchiveTaskTypeEnum.UNARCHIVE;
        for (ArchiveConfig config : this.configuration.getConfigs()) {
            if (!(config instanceof MainArchiveConfig)) continue;
            fromTable = isArchive ? config.getTable() : config.getLogicTable();
            break;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("/*XDB:NO_SHARDING*/", new Object[0]);
        sqlBuilder.append("select top ", new Object[0]).append(this.bufferSize + "", new Object[0]).append(" ", new Object[0]).append(pkField, new Object[0]).append(",", new Object[0]).append(fieldsAppend, new Object[0]).append(" from ", new Object[0]).append(fromTable, new Object[0]).append(" where ", new Object[0]).appendIn(pkField, pks);
        int n = this.fields.length + 1;
        return (List)DB.query((DBRoute)this.configuration.getFromRoute(), (SqlBuilder)sqlBuilder, rs -> {
            ArrayList<RowRecord> rowRecordList = new ArrayList<RowRecord>(this.bufferSize);
            while (rs.next()) {
                RowRecord rowRecord = new RowRecord(n - 1);
                Object pkValue = rs.getObject(1);
                rowRecord.setPk(pkValue);
                for (int i = 2; i <= n; ++i) {
                    rowRecord.setColumn(i - 2, rs.getObject(i));
                }
                rowRecordList.add(rowRecord);
            }
            return rowRecordList;
        });
    }
}

