/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.taskgroup.split;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.archive.ArchiveConstant;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.task.config.DBConfiguration;
import kd.bos.archive.task.taskgroup.Reader;
import kd.bos.archive.transport.exchanger.RecordSender;
import kd.bos.archive.transport.record.RowRecord;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveName;
import kd.bos.db.archive.config.ArchiveConfig;
import kd.bos.db.archive.config.ChildrenArchiveConfig;

public class CrossDataReader
implements Reader {
    private DBConfiguration configuration;
    private ArchiveSplitTaskEntity splitTaskEntity;
    private ArchiveConfig config;
    private Object lastPk;
    private String tranTable;
    private String pkField;
    private boolean isLang;
    private String columnFields;
    private int columnLength;
    private int pkidLength;

    public CrossDataReader(ArchiveSplitTaskEntity splitTaskEntity, DBConfiguration configuration, ArchiveConfig config, String columnFields, Object lastPk) {
        this.splitTaskEntity = splitTaskEntity;
        this.configuration = configuration;
        this.config = config;
        this.lastPk = lastPk;
        this.columnFields = columnFields;
        this.pkField = config.getPrimaryKey();
        this.tranTable = ArchiveName.of((String)this.config.getTable()).getArchiveTranTable((long)splitTaskEntity.getSeq());
        String[] fields = this.columnFields.split(",");
        this.columnLength = fields.length;
        boolean bl = this.isLang = config instanceof ChildrenArchiveConfig && ((ChildrenArchiveConfig)config).isLangTableConfig();
        if (this.isLang) {
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].equalsIgnoreCase("fpkid")) continue;
                this.pkidLength = i + 1;
                break;
            }
        } else {
            this.pkidLength = 1;
        }
    }

    @Override
    public void startRead(RecordSender recordSender) {
        AtomicInteger finalSize;
        Object fromPK = this.lastPk;
        do {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            ArrayList<Object> paramList = new ArrayList<Object>(2);
            StringBuilder sql = new StringBuilder(128);
            sql.append("select top ").append(ArchiveConstant.CROSS_PAGE_SIZE).append(" ").append(this.columnFields);
            sql.append(" from ").append(this.tranTable);
            if (fromPK != null) {
                sql.append(" where ").append(this.pkField);
                if (this.isLang) {
                    sql.append(" >= ?");
                } else {
                    sql.append(" > ?");
                }
                paramList.add(fromPK);
            }
            sql.append(" order by ").append(this.pkField).append(" asc ");
            String s = ArchiveUtil.wrapSQL(sql.toString(), false, true);
            finalSize = new AtomicInteger();
            try (DataSet dataSet = DB.queryDataSet((String)"CrossDataReader", (DBRoute)this.configuration.getFromRoute(), (String)s, (Object[])paramList.toArray());){
                for (Row row : dataSet) {
                    Object pkValue;
                    RowRecord rowRecord = new RowRecord(this.columnLength);
                    if (this.isLang) {
                        rowRecord.setPkId(row.get(this.pkidLength - 1));
                    }
                    fromPK = pkValue = row.get(0);
                    rowRecord.setPk(pkValue);
                    rowRecord.setColumn(0, pkValue);
                    rowRecord.setIndex(this.splitTaskEntity.getIndex());
                    for (int i = 1; i < this.columnLength; ++i) {
                        rowRecord.setColumn(i, row.get(i));
                    }
                    recordSender.sendToWriter(rowRecord);
                    finalSize.getAndIncrement();
                }
            }
        } while (finalSize.get() >= ArchiveConstant.CROSS_PAGE_SIZE);
    }
}

