/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.taskgroup.split;

import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.enums.ArchiveTaskTypeEnum;
import kd.bos.archive.progress.IProgress;
import kd.bos.archive.tablemanager.TableManager;
import kd.bos.archive.task.config.DBConfiguration;
import kd.bos.archive.task.taskgroup.DBWriterAbst;
import kd.bos.archive.transport.record.RowRecord;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.SqlBuilder;
import kd.bos.db.archive.ArchiveName;
import kd.bos.db.archive.config.ArchiveConfig;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.tablemanager.meta.Column;

public class DataCleanWriter
extends DBWriterAbst {
    private ArchiveSplitTaskEntity splitTaskEntity;
    private ArchiveConfig keyConfig;
    private List<ArchiveConfig> valueConfigs;
    private boolean isShardHandle;
    private boolean isNotUnarchive;
    private int loop = 0;
    private String keyMvTable;
    private String mainKeyField;
    private String apkTable;
    private String fieldsString;

    public DataCleanWriter(ArchiveSplitTaskEntity splitTaskEntity, DBConfiguration configuration, ArchiveConfig keyConfig, IProgress progress) throws SQLException {
        super(configuration, progress);
        this.splitTaskEntity = splitTaskEntity;
        this.keyConfig = keyConfig;
        this.valueConfigs = (List)this.configuration.getMultimap().get((Object)this.keyConfig);
        this.isNotUnarchive = this.configuration.getTaskEntity().getTasktype() != ArchiveTaskTypeEnum.UNARCHIVE;
        boolean bl = this.isShardHandle = this.configuration.isXdb() && this.isNotUnarchive;
        if (configuration.getIndexConfigEntity() != null && configuration.getIndexConfigEntity().getIndicesfields() != null && configuration.getIndexConfigEntity().getIndicesfields().length() > 0) {
            this.apkTable = ArchiveName.of((String)this.configuration.getMainTable()).getArchivePkTable();
            if (ArchiveTaskTypeEnum.ARCHIVE == this.configuration.getTaskEntity().getTasktype()) {
                this.keyMvTable = ArchiveName.of((String)this.keyConfig.getTable()).getArchivePkmTable((long)splitTaskEntity.getSeq());
                this.mainKeyField = configuration.getMainArchiveConfig().getPrimaryKey();
                this.fieldsString = this.getColumns(this.apkTable);
            }
        }
    }

    @Override
    public void doBatchInsert(List<RowRecord> writerBuffer) throws SQLException {
        Object fromPK = writerBuffer.get(0).getPk();
        Object toPk = writerBuffer.get(writerBuffer.size() - 1).getPk();
        int bufferSize = writerBuffer.size();
        for (ArchiveConfig archiveConfig : this.valueConfigs) {
            boolean isExist;
            String shardTable;
            String pkField = archiveConfig.getPrimaryKey();
            String oriTable = archiveConfig.getTable();
            String string = this.isShardHandle ? TableName.of((String)oriTable).getShardingTable((long)this.splitTaskEntity.getIndex()) : (shardTable = this.isNotUnarchive ? oriTable : archiveConfig.getLogicTable());
            if (this.isShardHandle && !(isExist = TableManager.get().existTable(this.configuration.getFromRoute(), shardTable))) continue;
            if (archiveConfig == this.configuration.getMainArchiveConfig() && this.configuration.getIndexConfigEntity() != null && this.configuration.getIndexConfigEntity().getIndicesfields() != null && this.configuration.getIndexConfigEntity().getIndicesfields().length() > 0 && ArchiveTaskTypeEnum.ARCHIVE == this.configuration.getTaskEntity().getTasktype()) {
                StringBuilder sql = new StringBuilder(128);
                sql.setLength(0);
                if (DBType.MySQL == this.dbType) {
                    sql.append("replace into ").append(this.apkTable);
                } else {
                    if (this.progress.isNeedDel()) {
                        this.deleteDuplicate(this.apkTable, "fpk", writerBuffer.stream().map(RowRecord::getPk).collect(Collectors.toList()));
                    }
                    sql.append("insert into ").append(this.apkTable);
                }
                sql.append(" (").append(this.fieldsString).append(") ").append(" select '").append(this.configuration.getConfigEntity().getArchiveRoute()).append(this.configuration.getConfigEntity().getLogicSuffix()).append("',").append(this.packJoinField(this.fieldsString, this.mainKeyField)).append(" from ").append(this.keyMvTable).append(" A inner join ").append(shardTable).append(" B on B.").append(pkField).append("=A.FID where A.FID>=? and A.FID<=? ");
                DB.execute((DBRoute)this.configuration.getFromRoute(), (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{fromPK, toPk});
            }
            List<Object> pks = writerBuffer.stream().map(RowRecord::getPk).collect(Collectors.toList());
            List<List> splitList = this.deleteSplitList(pks);
            for (List range : splitList) {
                SqlBuilder delSqlBuilder = new SqlBuilder();
                delSqlBuilder.append("/*dialect*/", new Object[0]).append("/*XDB:NO_SHARDING*/", new Object[0]);
                delSqlBuilder.append("delete from ", new Object[0]).append(shardTable, new Object[0]).append(" where ", new Object[0]);
                delSqlBuilder.appendIn(pkField, range);
                if (ArchiveTaskTypeEnum.DATASYNC == this.configuration.getTaskEntity().getTasktype()) {
                    ArchiveUtil.wrapSqlBuilderExecute(this.configuration.getToRoute(), delSqlBuilder);
                    continue;
                }
                ArchiveUtil.wrapSqlBuilderExecute(this.configuration.getFromRoute(), delSqlBuilder);
                if (archiveConfig != this.configuration.getMainArchiveConfig()) continue;
                if (this.isShardHandle && ArchiveTaskTypeEnum.ARCHIVE == this.configuration.getTaskEntity().getTasktype()) {
                    TableName tableName = TableName.of((String)this.configuration.getMainTable());
                    SqlBuilder pkDelSql = new SqlBuilder();
                    pkDelSql.append("/*dialect*/", new Object[0]).append("/*XDB:NO_SHARDING*/", new Object[0]);
                    pkDelSql.append("delete from ", new Object[0]).append(tableName.getPKTable(), new Object[0]).append(" where ", new Object[0]);
                    pkDelSql.appendIn("fpk", range);
                    ArchiveUtil.wrapSqlBuilderExecute(this.configuration.getFromRoute(), pkDelSql);
                }
                if (this.configuration.getIndexConfigEntity() == null || this.configuration.getIndexConfigEntity().getIndicesfields() == null || this.configuration.getIndexConfigEntity().getIndicesfields().length() <= 0 || ArchiveTaskTypeEnum.UNARCHIVE != this.configuration.getTaskEntity().getTasktype()) continue;
                SqlBuilder pkDelSql = new SqlBuilder();
                pkDelSql.append("/*dialect*/", new Object[0]).append("/*XDB:NO_SHARDING*/", new Object[0]);
                pkDelSql.append("delete from ", new Object[0]).append(this.apkTable, new Object[0]).append(" where ", new Object[0]);
                pkDelSql.appendIn("fpk", range);
                ArchiveUtil.wrapSqlBuilderExecute(this.configuration.getToRoute(), pkDelSql);
            }
            this.progress.setProgressDesc_2(BosRes.get((String)"bos-archive", (String)"DataCleanWork_2", (String)"Data cleaning, mvtable:{0},index={1},fromPK={2},toPK={3},size={4}", (Object[])new Object[]{shardTable, this.splitTaskEntity.getIndex(), fromPK, toPk, bufferSize}));
            this.progress.setExecSql(null);
            this.progress.store();
        }
        if (this.progress.isNeedDel()) {
            ++this.loop;
            if (this.loop > 3) {
                this.progress.setNeedDel(false);
            }
        }
        this.progress.setToPk(toPk);
        this.progress.setExecSql(null);
        this.progress.setProgressDesc_2(BosRes.get((String)"bos-archive", (String)"DataCleanWork_3", (String)"Data cleaning, task table: {0}, index={1}, fromPK={2} before data migration is completed, continue to the next stage of cleaning", (Object[])new Object[]{this.keyConfig.getTable(), this.splitTaskEntity.getIndex(), toPk}));
        this.progress.store();
    }

    private String getColumns(String table) throws SQLException {
        List<Column> columnList = TableManager.get().getColumns(this.configuration.getFromRoute(), table);
        StringBuilder columnStr = new StringBuilder();
        int n = columnList.size();
        for (int i = 0; i < n; ++i) {
            String columnName = columnList.get(i).getColumnName();
            if (columnName.equalsIgnoreCase("farchiveroute")) continue;
            columnStr.append(columnName);
            if (i == n - 1) continue;
            columnStr.append(',');
        }
        columnStr.insert(0, "farchiveroute,");
        return columnStr.toString();
    }

    private String packJoinField(String fieldsString, String mainKeyField) {
        StringBuilder sql = new StringBuilder();
        String[] columnList = fieldsString.split(",");
        int n = columnList.length;
        for (int i = 0; i < n; ++i) {
            String columnName = columnList[i];
            if (columnName.equalsIgnoreCase("fpk")) {
                columnName = mainKeyField;
            } else if (columnName.equalsIgnoreCase("farchiveroute")) continue;
            sql.append('B').append('.').append(columnName);
            if (i == n - 1) continue;
            sql.append(',');
        }
        return sql.toString();
    }
}

