/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.taskgroup.split;

import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.enums.ArchiveTaskTypeEnum;
import kd.bos.archive.progress.IProgress;
import kd.bos.archive.tablemanager.TableManager;
import kd.bos.archive.task.config.DBConfiguration;
import kd.bos.archive.task.taskgroup.DBWriterAbst;
import kd.bos.archive.transport.record.RowRecord;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.archive.ArchiveName;
import kd.bos.db.archive.config.ArchiveConfig;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.tablemanager.meta.Column;

public class DataMoveWriter
extends DBWriterAbst {
    private ArchiveSplitTaskEntity splitTaskEntity;
    private ArchiveConfig keyConfig;
    private List<ArchiveConfig> valueConfigs;
    private String keyMvTable;
    private boolean isShardHandle;
    private boolean isArchive;
    private int loop = 0;

    public DataMoveWriter(ArchiveSplitTaskEntity splitTaskEntity, DBConfiguration configuration, ArchiveConfig keyConfig, IProgress progress) {
        super(configuration, progress);
        this.splitTaskEntity = splitTaskEntity;
        this.keyConfig = keyConfig;
        this.valueConfigs = (List)this.configuration.getMultimap().get((Object)this.keyConfig);
        this.keyMvTable = ArchiveName.of((String)this.keyConfig.getTable()).getArchivePkmTable((long)splitTaskEntity.getSeq());
        this.isArchive = this.configuration.getTaskEntity().getTasktype() != ArchiveTaskTypeEnum.UNARCHIVE;
        this.isShardHandle = this.configuration.isXdb() && this.isArchive;
    }

    @Override
    public void doBatchInsert(List<RowRecord> writerBuffer) throws SQLException {
        Object fromPK = writerBuffer.get(0).getPk();
        Object toPk = writerBuffer.get(writerBuffer.size() - 1).getPk();
        int bufferSize = writerBuffer.size();
        for (ArchiveConfig archiveConfig : this.valueConfigs) {
            boolean isExist;
            String shardTable;
            String pkField = archiveConfig.getPrimaryKey();
            String table = archiveConfig.getTable();
            String logicTable = archiveConfig.getLogicTable();
            String oriTable = archiveConfig.getTable();
            String string = this.isShardHandle ? TableName.of((String)oriTable).getShardingTable((long)this.splitTaskEntity.getIndex()) : (shardTable = this.isArchive ? oriTable : logicTable);
            if (this.isShardHandle && !(isExist = TableManager.get().existTable(this.configuration.getFromRoute(), shardTable))) continue;
            String tranTable = ArchiveName.of((String)table).getArchiveTranTable((long)this.splitTaskEntity.getSeq());
            String fieldsString = this.getColumns(tranTable, pkField);
            StringBuilder sql = new StringBuilder(128);
            sql.setLength(0);
            if (DBType.MySQL == this.dbType) {
                sql.append("replace into ").append(tranTable);
            } else {
                if (this.progress.isNeedDel()) {
                    this.deleteDuplicate(tranTable, pkField, writerBuffer.stream().map(RowRecord::getPk).collect(Collectors.toList()));
                    this.progress.setProgressDesc_2(BosRes.get((String)"bos-archive", (String)"DataMoveWork_2", (String)"Abnormal recovery of data migration in the same database, clear abnormal data, mvtable:{0},fromPK={1},toPK={2},size={3}", (Object[])new Object[]{tranTable, fromPK, toPk, bufferSize}));
                    this.progress.store();
                }
                sql.append("insert into ").append(tranTable);
            }
            sql.append(" (").append(fieldsString).append(") ").append(" select ").append(this.packJoinField(fieldsString)).append(" from ").append(this.keyMvTable).append(" A inner join ").append(shardTable).append(" B on B.").append(pkField).append("=A.FID where A.FID>=? and A.FID<=? ");
            DB.execute((DBRoute)this.configuration.getFromRoute(), (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{fromPK, toPk});
            this.progress.setProgressDesc_2(BosRes.get((String)"bos-archive", (String)"DataMoveWork_3", (String)"Same database migration, mvtable:{0},index={1},fromPK={2},toPK={3},size={4}", (Object[])new Object[]{shardTable, this.splitTaskEntity.getIndex(), fromPK, toPk, bufferSize}));
            this.progress.setExecSql(sql.toString());
            this.progress.store();
        }
        if (this.progress.isNeedDel()) {
            ++this.loop;
            if (this.loop > 3) {
                this.progress.setNeedDel(false);
            }
        }
        this.progress.setToPk(toPk);
        this.progress.setExecSql(null);
        this.progress.setProgressDesc_2(BosRes.get((String)"bos-archive", (String)"DataMoveWork_4", (String)"Same database migration, task table: {0}, index={1}, fromPK={2} Before data migration is completed, continue to the next stage of migration", (Object[])new Object[]{this.keyConfig.getTable(), this.splitTaskEntity.getIndex(), toPk}));
        this.progress.store();
    }

    private String getColumns(String table, String pkField) throws SQLException {
        List<Column> columnList = TableManager.get().getColumns(this.configuration.getFromRoute(), table);
        StringBuilder columnStr = new StringBuilder();
        int n = columnList.size();
        for (int i = 0; i < n; ++i) {
            String columnName = columnList.get(i).getColumnName();
            if (columnName.equalsIgnoreCase(pkField)) {
                if (i != n - 1) continue;
                columnStr.delete(columnStr.length() - 1, columnStr.length());
                continue;
            }
            columnStr.append(columnList.get(i).getColumnName());
            if (i == n - 1) continue;
            columnStr.append(',');
        }
        columnStr.insert(0, pkField + ',');
        return columnStr.toString();
    }

    private String packJoinField(String fieldsString) {
        StringBuilder sql = new StringBuilder();
        String[] columnList = fieldsString.split(",");
        int n = columnList.length;
        for (int i = 0; i < n; ++i) {
            sql.append('B').append('.').append(columnList[i]);
            if (i == n - 1) continue;
            sql.append(',');
        }
        return sql.toString();
    }
}

