/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.taskpaused;

import kd.bos.archive.taskpaused.ArchiveTaskPausedListener;
import kd.bos.db.sharding.ZKWatchValueNotifier;
import kd.bos.db.sharding.taskpaused.ShardTaskPausedInfo;
import kd.bos.db.sharding.taskpaused.ShardTaskPausedListener;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.xdb.exception.ExceptionUtil;

public class ArchiveTaskPausedNotifier
extends ZKWatchValueNotifier {
    private static final String ARCHIVE_TASK_PAUSED_WATCHER = "archive.task.paused.watcher";
    private static final String FIRE_TASK_PAUSED_LOCK_KEY = "/archive/fire_task_paused";

    public static void registTaskPausedListener(final ShardTaskPausedListener l) {
        ConfigurationChangeListener listener = new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                try {
                    ShardTaskPausedInfo ti = ShardTaskPausedListener.fromKey((String)((String)newValue));
                    l.onReceiveChangeTableMV(ti);
                }
                catch (Throwable e) {
                    throw ExceptionUtil.wrap((Throwable)e);
                }
            }
        };
        ArchiveTaskPausedNotifier.observeChange((String)ARCHIVE_TASK_PAUSED_WATCHER, (ConfigurationChangeListener)listener);
    }

    public static void fireTaskPaused(String entityName, boolean paused) {
        String value = ArchiveTaskPausedListener.currentKey(entityName, paused);
        log.info("fireLimitTablePaused " + entityName + " " + value);
        ArchiveTaskPausedNotifier.fireLimit((String)FIRE_TASK_PAUSED_LOCK_KEY, (String)ARCHIVE_TASK_PAUSED_WATCHER, (String)value);
    }
}

