/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.serverscript.debug;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class DebugStartParameter
implements Serializable {
    private static final long serialVersionUID = -950084427074144248L;
    private Map<String, int[]> breakPointMap = new HashMap<String, int[]>();
    private Map<String, String[]> watchMap = new HashMap<String, String[]>();
    private boolean skipAllBreakPoint = false;

    public void setBreakPoints(String scriptName, int ... breakPointLines) {
        if (breakPointLines == null || breakPointLines.length == 0) {
            this.breakPointMap.remove(scriptName);
        } else {
            this.breakPointMap.put(scriptName, breakPointLines);
        }
    }

    public void setWatches(String scriptName, String ... expressions) {
        if (expressions == null || expressions.length == 0) {
            this.watchMap.remove(scriptName);
        } else {
            this.watchMap.put(scriptName, expressions);
        }
    }

    public void addWatch(String scriptName, String expression) {
        String[] exps = this.watchMap.get(scriptName);
        if (exps == null) {
            exps = new String[]{expression};
            this.watchMap.put(scriptName, exps);
        } else {
            HashSet<String> set = new HashSet<String>(Arrays.asList(exps));
            set.add(expression);
            this.watchMap.put(scriptName, set.toArray(new String[set.size()]));
        }
    }

    public Map<String, int[]> getBreakPointMap() {
        return this.breakPointMap;
    }

    public Map<String, String[]> getWatchMap() {
        return this.watchMap;
    }

    public boolean isSkipAllBreakPoint() {
        return this.skipAllBreakPoint;
    }

    public void setSkipAllBreakPoint(boolean skipAllBreakPoint) {
        this.skipAllBreakPoint = skipAllBreakPoint;
    }
}

