/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filestorage.swift;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.filestorage.spi.FileStorageConfig;
import kd.bos.filestorage.spi.FileStorageService;
import kd.bos.filestorage.swift.swiftclient.FilesClient;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class SwiftStorage
implements FileStorageService {
    public static final int DEFAULT_CONNECTION_TIMEOUT = 15000;
    private static final String USER_AGENT = "USER-AGENT";
    private static Log logger = LogFactory.getLog(SwiftStorage.class);
    private FileStorageConfig fileStorageConfig;
    private FilesClient filesClient;
    private String[] containers;

    public void setConfig(FileStorageConfig fileStorageConfig) {
        this.fileStorageConfig = fileStorageConfig;
        this.containers = fileStorageConfig.getContainer().split(",");
        if (StringUtils.isEmpty((String)this.fileStorageConfig.getContainer())) {
            throw new KDException(BosErrorCode.fileServerNotConfigured, new Object[]{"config-container cannot be empty."});
        }
        this.filesClient = new FilesClient(fileStorageConfig.getAuthType(), fileStorageConfig.getAuthUserName(), fileStorageConfig.getAuthPassword(), "", fileStorageConfig.getFileServerHttpUrl(), 15000, 1000 * fileStorageConfig.getUploadTimeout());
    }

    public List<String> getForbiddenExtensions() {
        return new ArrayList<String>();
    }

    public String getTicket() throws IOException {
        return this.filesClient.getAuthToken();
    }

    public String upload(InputStream inputStream, String path, String fileName, boolean isCreateNewFileWhenExists, Map<String, String> headers) throws IOException, URISyntaxException {
        String contentType = "";
        this.filesClient.login();
        String containerName = this.getRandomUploadContainer(this.fileStorageConfig.getContainer());
        String url = this.filesClient.storeObject(containerName, inputStream, contentType, path, headers);
        String fullUrl = containerName + url;
        return fullUrl;
    }

    public InputStream getInputStream(String path, String userAgent) throws IOException, URISyntaxException {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (userAgent != null) {
            headerMap.put(USER_AGENT, userAgent);
        }
        this.filesClient.login();
        return this.filesClient.getObjectAsStream(path, headerMap);
    }

    public void download(String path, OutputStream outputStream, String userAgent) throws IOException, URISyntaxException {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (userAgent != null) {
            headerMap.put(USER_AGENT, userAgent);
        }
        this.filesClient.login();
        try (InputStream inputStream = this.filesClient.getObjectAsStream(path, headerMap);){
            byte[] buffer = new byte[8192];
            int len = 0;
            while ((len = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, len);
            }
        }
    }

    public void delete(String path) throws IOException, URISyntaxException {
        this.filesClient.login();
        this.filesClient.deleteObject(path);
    }

    public void close() throws IOException {
        if (this.filesClient != null) {
            this.filesClient.close();
        }
    }

    private String getRandomUploadContainer(String containers) {
        String[] containerList = containers.split(",");
        SecureRandom random = new SecureRandom();
        int index = random.nextInt(containerList.length);
        return containerList[index].trim();
    }

    public boolean exists(String path) throws IOException, URISyntaxException {
        if (StringUtils.isEmpty((String)path)) {
            return false;
        }
        this.filesClient.login();
        return this.filesClient.exists(path, null);
    }
}

