/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filestorage.swift.swiftclient;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.filestorage.swift.swiftclient.FilesContainer;
import kd.bos.filestorage.swift.swiftclient.FilesContainerInfo;
import kd.bos.filestorage.swift.swiftclient.FilesObject;
import kd.bos.filestorage.swift.swiftclient.FilesObjectMetaData;
import kd.bos.filestorage.swift.swiftclient.IFilesTransferCallback;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.text.StrTokenizer;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class FilesClient
implements Closeable {
    public static final int DEFAULT_CONNECTION_TIMEOUT = 15000;
    public static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    public static final String STR_LIMIT = "limit";
    public static final String STR_MARKER = "marker";
    private int connectionTimeOut = 15000;
    private int socketTimeout = 60000;
    private String username = null;
    private String password = null;
    private String account = "";
    private String authType = "";
    private String authenticationURL;
    private String storageURL = null;
    private String authToken = null;
    private boolean isLoggedin = false;
    private static Log logger = LogFactory.getLog(FilesClient.class);

    public FilesClient() {
    }

    public FilesClient(String authType, String username, String password, String account, String url, int connectionTimeOut, int socketTimeout) {
        if (StringUtils.isEmpty((String)authType)) {
            authType = "none";
        }
        this.authType = authType;
        this.username = username;
        this.password = password;
        this.account = account;
        this.authenticationURL = url;
        this.connectionTimeOut = connectionTimeOut;
        this.socketTimeout = socketTimeout;
        if (logger.isDebugEnabled()) {
            logger.debug("Swift-ConnectionTimeOut: " + this.connectionTimeOut);
        }
    }

    public FilesClient(String authType, String username, String password, String account, String url) {
        this(authType, username, password, account, url, 15000, 60000);
    }

    /*
     * Unable to fully structure code
     */
    public boolean login() throws IOException {
        httpClient = HttpClients.createDefault();
        var2_2 = this.authType;
        var3_3 = -1;
        switch (var2_2.hashCode()) {
            case -1321855108: {
                if (!var2_2.equals("tempauth")) break;
                var3_3 = 0;
                break;
            }
            case 3387192: {
                if (!var2_2.equals("none")) break;
                var3_3 = 1;
            }
        }
        switch (var3_3) {
            case 0: {
                request = new HttpGet(this.authenticationURL);
                request.addHeader("x-auth-user", this.username);
                request.addHeader("x-auth-key", this.password);
                requestConfig = RequestConfig.custom().setConnectTimeout(this.connectionTimeOut).setSocketTimeout(this.socketTimeout).build();
                request.setConfig(requestConfig);
                response = httpClient.execute((HttpUriRequest)request);
                var7_7 = null;
                httpClient.close();
                if (!this.isHttpOK(response)) {
                    throw new IOException("login to swift server failed:" + response.getStatusLine().getReasonPhrase());
                }
                this.isLoggedin = true;
                this.storageURL = this.getHeader(response.getFirstHeader("X-Storage-Url"));
                this.authToken = this.getHeader(response.getFirstHeader("X-Auth-Token"));
                if (response == null) break;
                if (var7_7 == null) ** GOTO lbl36
                try {
                    response.close();
                }
                catch (Throwable var8_8) {
                    var7_7.addSuppressed(var8_8);
                }
                break;
lbl36:
                // 1 sources

                response.close();
                break;
                catch (Throwable var8_9) {
                    try {
                        var7_7 = var8_9;
                        throw var8_9;
                    }
                    catch (Throwable var9_10) {
                        if (response != null) {
                            if (var7_7 != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable var10_11) {
                                    var7_7.addSuppressed(var10_11);
                                }
                            } else {
                                response.close();
                            }
                        }
                        throw var9_10;
                    }
                }
            }
            case 1: {
                this.storageURL = this.authenticationURL;
                this.authToken = "";
                this.isLoggedin = true;
                break;
            }
            default: {
                throw new IOException("Wrong configuration,FileStorage unknown authentication type\uff1a" + this.authType);
            }
        }
        return this.isLoggedin;
    }

    public String getAuthToken() throws IOException {
        if (!this.isLoggedin) {
            this.login();
        }
        return this.authToken;
    }

    public List<FilesContainer> listContainers() {
        return this.listContainers(-1, null);
    }

    public List<FilesContainer> listContainers(int limit) {
        return this.listContainers(limit, null);
    }

    private CloseableHttpResponse getHttpResponse(HttpRequestBase request) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        this.prepareDoHttp(request);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
        httpClient.close();
        return response;
    }

    private CloseableHttpResponse doHttp(HttpRequestBase request) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        this.prepareDoHttp(request);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
        if (this.isHttpOK(response)) {
            logger.debug("response ok");
        } else if (response.getStatusLine().getStatusCode() == 401) {
            this.login();
            response = httpClient.execute((HttpUriRequest)request);
        } else {
            throw new KDException(BosErrorCode.fileserviceException, new Object[]{response.getStatusLine().getReasonPhrase()});
        }
        httpClient.close();
        return response;
    }

    private CloseableHttpResponse doHttpNoClose(HttpRequestBase request) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        this.prepareDoHttp(request);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
        if (this.isHttpOK(response)) {
            return response;
        }
        if (response.getStatusLine().getStatusCode() == 401) {
            this.login();
            return httpClient.execute((HttpUriRequest)request);
        }
        throw new KDException(BosErrorCode.fileserviceException, new Object[]{response.getStatusLine().getReasonPhrase()});
    }

    private void prepareDoHttp(HttpRequestBase request) throws IOException {
        if (!this.isLoggedin) {
            this.login();
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectionTimeOut).setSocketTimeout(this.socketTimeout).build();
        request.setConfig(requestConfig);
        request.addHeader("X-Auth-Token", this.authToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<FilesContainer> listContainers(int limit, String marker) {
        CloseableHttpResponse response = null;
        try {
            URIBuilder urlBuilder = new URIBuilder(this.storageURL);
            if (limit > 0) {
                urlBuilder.addParameter(STR_LIMIT, String.valueOf(limit));
            }
            if (marker != null) {
                urlBuilder.addParameter(STR_MARKER, marker);
            }
            HttpGet request = new HttpGet(urlBuilder.build());
            response = this.doHttp((HttpRequestBase)request);
            StrTokenizer tokenize = new StrTokenizer(EntityUtils.toString((HttpEntity)response.getEntity()));
            tokenize.setDelimiterString("\n");
            String[] containers = tokenize.getTokenArray();
            ArrayList<FilesContainer> containerList = new ArrayList<FilesContainer>();
            for (String container : containers) {
                containerList.add(new FilesContainer(container, this));
            }
            ArrayList<FilesContainer> arrayList = containerList;
            this.closeResponse(response);
            return arrayList;
        }
        catch (Exception e) {
            logger.error("Unexpected container-info tag:", (Throwable)e);
        }
        finally {
            this.closeResponse(response);
        }
        return null;
    }

    public List<FilesContainerInfo> listContainersInfo() throws IOException, URISyntaxException {
        return this.listContainersInfo(-1, null);
    }

    public List<FilesContainerInfo> listContainersInfo(int limit) throws IOException, URISyntaxException {
        return this.listContainersInfo(limit, null);
    }

    public List<FilesContainerInfo> listContainersInfo(int limit, String marker) throws URISyntaxException, IOException {
        URIBuilder urlBuilder = new URIBuilder(this.storageURL);
        if (limit > 0) {
            urlBuilder.addParameter(STR_LIMIT, String.valueOf(limit));
        }
        if (marker != null) {
            urlBuilder.addParameter(STR_MARKER, marker);
        }
        urlBuilder.addParameter("format", "json");
        HttpGet request = new HttpGet(urlBuilder.build());
        try (CloseableHttpResponse response = this.doHttp((HttpRequestBase)request);){
            List containerList;
            List list = containerList = JSON.parseArray((String)EntityUtils.toString((HttpEntity)response.getEntity()), FilesContainerInfo.class);
            return list;
        }
    }

    public List<FilesObject> listObjects(String container) throws IOException, URISyntaxException {
        return this.listObjectsStaringWith(container, null, null, -1, null);
    }

    private void validContainerName(String name) {
        if (name == null) {
            throw new KDException(BosErrorCode.fileserviceException, new Object[]{"name is null"});
        }
        int length = name.length();
        if (length == 0 || length > 256) {
            throw new KDException(BosErrorCode.fileserviceException, new Object[]{"name too big,name too short"});
        }
        if (name.indexOf(47) != -1) {
            throw new KDException(BosErrorCode.fileserviceException, new Object[]{"name contains /"});
        }
    }

    private void validObjectName(String name) {
        if (name == null) {
            throw new KDException(BosErrorCode.fileserviceException, new Object[]{"name is null"});
        }
        int length = name.length();
        if (length == 0 || length > 1024) {
            throw new KDException(BosErrorCode.fileserviceException, new Object[]{"name too big,name too short"});
        }
    }

    public List<FilesObject> listObjectsStaringWith(String container, String startsWith, String path, int limit, String marker) throws IOException, URISyntaxException {
        return this.listObjectsStaringWith(container, startsWith, path, limit, marker, null);
    }

    public List<FilesObject> listObjectsStaringWith(String container, String startsWith, String path, int limit, String marker, String delimiter) throws URISyntaxException, IOException {
        this.validContainerName(container);
        String url = FilesClient.getCombinedPath(this.storageURL, container);
        URIBuilder urlBuilder = new URIBuilder(url);
        urlBuilder.addParameter("format", "json");
        if (startsWith != null) {
            urlBuilder.addParameter("prefix", startsWith);
        }
        if (path != null) {
            urlBuilder.addParameter("path", path);
        }
        if (limit > 0) {
            urlBuilder.addParameter(STR_LIMIT, String.valueOf(limit));
        }
        if (delimiter != null) {
            urlBuilder.addParameter("delimiter", delimiter);
        }
        if (marker != null) {
            urlBuilder.addParameter(STR_MARKER, marker);
        }
        HttpGet request = new HttpGet(urlBuilder.build());
        try (CloseableHttpResponse response = this.doHttp((HttpRequestBase)request);){
            List objectList;
            String jsonStr = EntityUtils.toString((HttpEntity)response.getEntity());
            List list = objectList = JSON.parseArray((String)jsonStr, FilesObject.class);
            return list;
        }
    }

    public List<FilesObject> listObjects(String container, int limit) throws IOException, URISyntaxException {
        return this.listObjectsStaringWith(container, null, null, limit, null);
    }

    public List<FilesObject> listObjects(String container, String path) throws IOException, URISyntaxException {
        return this.listObjectsStaringWith(container, null, path, -1, null);
    }

    public List<FilesObject> listObjects(String container, String path, int limit) throws IOException, URISyntaxException {
        return this.listObjectsStaringWith(container, null, path, limit, null);
    }

    public List<FilesObject> listObjects(String container, String path, int limit, String marker) throws IOException, URISyntaxException {
        return this.listObjectsStaringWith(container, null, path, limit, marker);
    }

    public List<FilesObject> listObjects(String container, int limit, String marker) throws IOException, URISyntaxException {
        return this.listObjectsStaringWith(container, null, null, limit, marker);
    }

    public byte[] getObject(String container, String objName, Map<String, String> headerMap) throws IOException, URISyntaxException {
        try (InputStream inputStream = this.getObjectAsStream(container, objName, headerMap);){
            byte[] byt;
            byte[] byArray = byt = FilesClient.input2byte(inputStream);
            return byArray;
        }
    }

    public boolean exists(String fullObjName, Map<String, String> headerMap) throws URISyntaxException, IOException {
        this.validObjectName(fullObjName);
        String url = FilesClient.getCombinedPath(this.storageURL, fullObjName);
        URIBuilder urlBuilder = new URIBuilder(url);
        HttpHead request = new HttpHead(urlBuilder.build());
        if (headerMap != null) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue());
            }
        }
        Throwable throwable = null;
        try (CloseableHttpResponse response = this.getHttpResponse((HttpRequestBase)request);){
            if (this.isHttpOK(response) || response.getStatusLine().getStatusCode() == 404) {
                boolean bl = response.getStatusLine().getStatusCode() != 404;
                return bl;
            }
            try {
                throw new KDException(BosErrorCode.fileserviceException, new Object[]{response.getStatusLine().getReasonPhrase()});
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public InputStream getObjectAsStream(String fullObjName, Map<String, String> headerMap) throws URISyntaxException, IOException {
        CloseableHttpResponse response;
        this.validObjectName(fullObjName);
        String url = FilesClient.getCombinedPath(this.storageURL, fullObjName);
        URIBuilder urlBuilder = new URIBuilder(url);
        HttpGet request = new HttpGet(urlBuilder.build());
        if (headerMap != null) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (!this.isHttpOK(response = this.doHttpNoClose((HttpRequestBase)request))) {
            throw new KDException(BosErrorCode.fileserviceException, new Object[]{EntityUtils.toString((HttpEntity)response.getEntity())});
        }
        return response.getEntity().getContent();
    }

    public InputStream getObjectAsStream(String container, String objName, Map<String, String> headerMap) throws IOException, URISyntaxException {
        this.validContainerName(container);
        String ObjNameWithContainer = FilesClient.getCombinedPath(container, objName);
        return this.getObjectAsStream(ObjNameWithContainer, headerMap);
    }

    public void deleteObject(String fullObjName) throws URISyntaxException, IOException {
        this.validObjectName(fullObjName);
        String url = FilesClient.getCombinedPath(this.storageURL, fullObjName);
        URIBuilder urlBuilder = new URIBuilder(url);
        HttpDelete request = new HttpDelete(urlBuilder.build());
        try (CloseableHttpResponse response = this.doHttp((HttpRequestBase)request);){
            if (!this.isHttpOK(response)) {
                throw new KDException(BosErrorCode.fileserviceException, new Object[]{EntityUtils.toString((HttpEntity)response.getEntity())});
            }
        }
    }

    public void deleteObject(String container, String objName) throws IOException, URISyntaxException {
        this.validContainerName(container);
        String fullObjName = FilesClient.getCombinedPath(container, objName);
        this.deleteObject(fullObjName);
    }

    public String storeObjectAs(String container, File obj, String contentType, String name) throws IOException, URISyntaxException {
        return this.storeObjectAs(container, obj, contentType, name, new HashMap<String, String>(), null);
    }

    public String storeObjectAs(String container, File obj, String contentType, String name, IFilesTransferCallback callback) throws IOException, URISyntaxException {
        return this.storeObjectAs(container, obj, contentType, name, new HashMap<String, String>(), callback);
    }

    public String storeObjectAs(String container, File obj, String contentType, String name, Map<String, String> metadata) throws IOException, URISyntaxException {
        return this.storeObjectAs(container, obj, contentType, name, metadata, null);
    }

    public String storeObjectAs(String container, File obj, String contentType, String name, Map<String, String> metadata, IFilesTransferCallback callback) throws IOException, URISyntaxException {
        this.validContainerName(container);
        this.validObjectName(name);
        if (!obj.exists()) {
            throw new FileNotFoundException(name + " does not exist");
        }
        if (obj.isDirectory()) {
            throw new IOException("The alleged file was a directory");
        }
        String url = FilesClient.getCombinedPath(this.storageURL, container, name);
        URIBuilder urlBuilder = new URIBuilder(url);
        HttpPut request = new HttpPut(urlBuilder.build());
        if (metadata != null) {
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                request.addHeader("" + entry.getKey(), entry.getValue());
            }
        }
        FileEntity entity = new FileEntity(obj, contentType);
        request.setEntity((HttpEntity)entity);
        try (CloseableHttpResponse response = this.doHttp((HttpRequestBase)request);){
            if (!this.isHttpOK(response)) {
                throw new KDException(BosErrorCode.fileserviceException, new Object[]{EntityUtils.toString((HttpEntity)response.getEntity())});
            }
            String string = name;
            return string;
        }
    }

    public FilesObjectMetaData getObjectMetaData(String container, String objName) throws URISyntaxException, IOException {
        FilesObjectMetaData metaData = null;
        this.validContainerName(container);
        this.validObjectName(objName);
        String url = FilesClient.getCombinedPath(this.storageURL, container, objName);
        URIBuilder urlBuilder = new URIBuilder(url);
        HttpGet request = new HttpGet(urlBuilder.build());
        try (CloseableHttpResponse response = this.doHttp((HttpRequestBase)request);){
            if (this.isHttpOK(response)) {
                Header[] headers;
                String mimeType = response.getEntity().getContentType().getValue();
                String lastModified = this.getHeader(response.getFirstHeader("Last-Modified"));
                String eTag = this.getHeader(response.getFirstHeader("ETag"));
                String contentLength = this.getHeader(response.getFirstHeader("Content-Length"));
                metaData = new FilesObjectMetaData(mimeType, contentLength, eTag, lastModified);
                HashMap<String, String> map = new HashMap<String, String>(10);
                for (Header header : headers = response.getAllHeaders()) {
                    map.put(header.getName(), header.getValue());
                }
                metaData.setMetaData(map);
            }
            FilesObjectMetaData filesObjectMetaData = metaData;
            return filesObjectMetaData;
        }
    }

    private String guessMimeType(String path) {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String contentTypeFor = fileNameMap.getContentTypeFor(path);
        if (contentTypeFor == null) {
            contentTypeFor = "application/octet-stream";
        }
        return contentTypeFor;
    }

    public String storeObject(String container, File obj) throws IOException, URISyntaxException {
        return this.storeObjectAs(container, obj, this.guessMimeType(obj.getName()), obj.getName());
    }

    public String storeObject(String container, File obj, String contentType) throws IOException, URISyntaxException {
        return this.storeObjectAs(container, obj, contentType, obj.getName());
    }

    public String storeObject(String container, byte[] obj, String contentType, String name) throws IOException, URISyntaxException {
        return this.storeObject(container, obj, contentType, name, new HashMap<String, String>());
    }

    public String storeObject(String container, byte[] obj, String contentType, String name, Map<String, String> metadata) throws IOException, URISyntaxException {
        return this.storeObject(container, obj, contentType, name, metadata, null);
    }

    public String storeObject(String container, byte[] obj, String contentType, String name, Map<String, String> metadata, IFilesTransferCallback callback) throws URISyntaxException, IOException {
        this.validContainerName(container);
        this.validObjectName(name);
        String url = FilesClient.getCombinedPath(this.storageURL, container, name);
        URIBuilder urlBuilder = new URIBuilder(url);
        HttpPut request = new HttpPut(urlBuilder.build());
        if (metadata != null) {
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                request.addHeader("" + entry.getKey(), entry.getValue());
            }
        }
        ByteArrayEntity entity = new ByteArrayEntity(obj);
        entity.setContentType(contentType);
        request.setEntity((HttpEntity)entity);
        try (CloseableHttpResponse response = this.doHttp((HttpRequestBase)request);){
            if (!this.isHttpOK(response)) {
                throw new KDException(BosErrorCode.fileserviceException, new Object[]{EntityUtils.toString((HttpEntity)response.getEntity())});
            }
            String string = name;
            return string;
        }
    }

    public String storeObject(String container, InputStream data, String contentType, String name, Map<String, String> metadata) throws IOException, URISyntaxException {
        return this.storeObject(container, IOUtils.toByteArray((InputStream)data), contentType, name, metadata);
    }

    public void createContainer(String container) {
        throw new NotImplementedException();
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAuthenticationURL(String authenticationURL) {
        this.authenticationURL = authenticationURL;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    private boolean isHttpOK(CloseableHttpResponse response) {
        int code = response.getStatusLine().getStatusCode();
        return code >= 200 && code <= 299;
    }

    public static String getValidFilePath(String filePath) {
        String validFilePath;
        String string = validFilePath = filePath.charAt(0) == '/' ? filePath.substring(1) : filePath;
        if (validFilePath.startsWith("/")) {
            validFilePath = FilesClient.getValidFilePath(validFilePath);
        }
        return validFilePath;
    }

    public static String getCombinedPath(String path1, String path2) {
        path2 = FilesClient.getValidFilePath(path2);
        String url = "";
        url = path1.endsWith("/") || path2.startsWith("/") ? path1 + path2 : path1 + "/" + path2;
        return url;
    }

    public static String getCombinedPath(String path1, String path2, String path3) {
        String url = FilesClient.getCombinedPath(path1, path2);
        return FilesClient.getCombinedPath(url, path3);
    }

    private String getHeader(Header header) {
        return header == null ? "" : header.getValue();
    }

    private static final byte[] input2byte(InputStream inStream) throws IOException {
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[8192];
        int rc = 0;
        while ((rc = inStream.read(buff)) > 0) {
            swapStream.write(buff, 0, rc);
        }
        byte[] in2b = swapStream.toByteArray();
        return in2b;
    }

    @Override
    public void close() throws IOException {
    }

    private void closeResponse(CloseableHttpResponse response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException e) {
                logger.warn("closeResponse err: ", (Throwable)e);
            }
        }
    }

    public static String getValidFileName(String name) {
        if (name.contains(" ")) {
            name = name.replace(" ", "");
        }
        if (name.contains("//")) {
            name = name.replace("//", "/");
        }
        return name;
    }
}

