// TODO 翻译import的实现
//@see @afterburnerhq/babel-plugin-graaljs-java-imports
//未测试，用java实现了，更强大(+package别名)：kd.sdk.kingscript.transpiler.model.translator.ImportSegmentTranslator
function trans_import() {

  const SUPPORTED_REMAPPING_PREFIXES = ['jdk/', 'sdk/'];
  const GRAALJS_JAVA_GLOBAL = 'Java';
  const GRAALJS_JAVA_TYPE = 'type';

  function removePrefixes(source: string): string {
    let finalSource = source;
    for (const prefix of SUPPORTED_REMAPPING_PREFIXES) {
      finalSource = finalSource.replace(prefix, "");
    }
    return finalSource;
  }

  const visitor = (t: typeof types) => ({
    ImportDeclaration(path: NodePath<any>) {
      const source: string = path.node.source.value
      const identifiers: string[] = path.node.specifiers.map((item) => item.local.name)

      if (!SUPPORTED_REMAPPING_PREFIXES.some((item) => source.startsWith(item))) return

      path.replaceWithMultiple(
        identifiers.map((item) =>
          t.variableDeclaration('const', [
            t.variableDeclarator(
              t.identifier(item),
              t.callExpression(
                t.memberExpression(
                  t.identifier(GRAALJS_JAVA_GLOBAL),
                  t.identifier(GRAALJS_JAVA_TYPE)
                ), [
                t.stringLiteral(`${removePrefixes(source)}.${item}`),
              ])
            ),
          ])
        )
      )
    },
  })
  return { visitor: visitor };
}
Babel.registerPlugin("trans_import", trans_import);