var g;

var expended = {};

$(function () {
    initTable();
    changeMode();
    showExceptions();

    function retryCallback() {
        var xhr;

        // 设置5秒超时定时器
        var timer = setTimeout(function () {
            // 中断上一个请求
            xhr.abort();
            // 超时重试
            retryCallback();
        }, 5000)

        xhr = $.ajax({
            type: 'get',
            url: flinkServer + GetJobId(),
            success: function (data, status) {

                //请求数据成功不再重试
                clearTimeout(timer)

                appendinfos(data);

                var edges = [];
                var nodes = [];
                var vertices = data.vertices;
                var idMapping = vertices.reduce(function (acc, el, i) {
                    acc[el.id] = i;
                    return acc;
                }, {});

                data.plan.nodes.forEach(function (node) {
                    //===========处理节点内文本行样式============
                    var splits = []
                    if (node.description.indexOf("-&gt;") !== -1) {
                        splits = node.description.split("-&gt;")
                    } else {
                        splits.push(node.description)
                    }
                    var operator = node.operator;   //标题
                    var description = "";           //标题下的代码行信息
                    splits.forEach(function (s) {
                        var start = s.lastIndexOf("(") + 1;
                        s = s.substr(start);
                        var end = s.indexOf(")");
                        s = s.substring(0, end);
                        description += s + "\n" + "->" /*+ "\n"*/;
                        operator += "\n";
                    })
                    description = description.substring(0, description.length - 3)
                    operator = operator.substring(0, operator.length - 1)
                    //===========处理节点内文本行样式============

                    var vertice = vertices[idMapping[node.id]];
                    var status;
                    if (vertice.status === "FINISHED" || vertice.status === "RUNNING" || vertice.status === "FAILED") {
                        status = vertice.status;
                    } else {
                        status = "default";
                    }
                    nodes.push({
                        id: node.id,
                        name: operator,
                        description: description,
                        type: status,
                        conf: [
                            {
                                label: 'operator_strategy',
                                value: node.operator_strategy,
                            },
                            {
                                label: 'Status',
                                value: $(statusFormatter(vertice.status)).text(),
                            },
                            {
                                label: 'Parallelism',
                                value: vertice.parallelism,
                            },
                        ]
                    });
                    if (node.inputs) {
                        node.inputs.forEach(function (input) {
                            edges.push({source: input.id, target: node.id})
                        });
                    }

                });

                appendtable(vertices);

                //流程图
                drawFlow(nodes, edges);

                setupInterval(data, nodes);

            }
        })
    }

    retryCallback();

})

//填充导航栏信息
function appendinfos(data) {
    if (data.state === "FAILED") {
        $("#label-status").addClass("badge-danger");
        $("#progress-bar").addClass("progress-bar-danger");
    } else /*if (data.state === "FINISHED" || data.state === "RUNNING")*/{
        $("#label-status").addClass("badge-success");
        $("#progress-bar").addClass("progress-bar-success");
    }
    $("#jname").text(data.name)
    var split = data.name.split(".");
    $("#jtitle").text(split[split.length - 1])
    $("#jid").text(data.jid)
    var jtime = timeStamp2String(data['start-time']);
    jtime += ' ~ ';
    if (data['end-time'] > 0) {
        jtime += timeStamp2String(data['end-time']);
        jtime = jtime + '  Cost: ' + duration2String(data.duration);
    } else {
        jtime += 'now'
    }
    $("#jtime").text("Duration：" + jtime)
    var badges = $("#badges");
    var prepare = 0;
    prepare += data['status-counts']['RECONCILING']
    prepare += data['status-counts']['DEPLOYING']
    prepare += data['status-counts']['CANCELED']
    prepare += data['status-counts']['SCHEDULED']
    prepare += data['status-counts']['CANCELING']
    prepare += data['status-counts']['CREATED']
    badges.children().eq(0).text('Waiting: ' + prepare)

    badges.children().eq(1).text('Running: ' + data['status-counts']['RUNNING'])
    badges.children().eq(2).text('Finished: ' + data['status-counts']['FINISHED'])
    badges.children().eq(3).text('Failed: ' + data['status-counts']['FAILED'])

    $.getJSON(flinkServer + GetJobId() + "/progress", function (data, status) {
        setProgress(data);
    });
}

//画流程图
function drawFlow(nodes, edges) {
    var data = {
        nodes: nodes,
        edges: edges,
    };

    G6.registerNode(
        'default',
        {
            drawShape: function (cfg, group) {
                var rect = group.addShape('rect', {
                    attrs: {
                        x: -90,
                        y: -30,
                        width: 120,
                        height: 60,
                        radius: 10,
                        stroke: 'rgba(113,113,118,0.89)',
                        fill: '#e8eef5',
                        lineWidth: 3,
                        opacity: 0.7
                    },
                    name: 'rect-shape',
                    draggable: true
                });
                if (cfg.name) {
                    group.addShape('text', {
                        attrs: {
                            text: cfg.name,
                            x: -30,
                            y: -5,
                            fill: 'rgba(113,113,118,0.89)',
                            fontSize: 10,
                            textAlign: 'center',
                            textBaseline: 'middle',
                            fontWeight: 'bold'
                        },
                        name: 'text-shape',
                        draggable: true
                    });
                }
                if (cfg.description) {
                    group.addShape('text', {
                        attrs: {
                            text: cfg.description,
                            x: -30,
                            y: 10,
                            fill: 'rgba(52,52,52,0.87)',
                            fontSize: 8,
                            textAlign: 'center',
                            textBaseline: 'middle',
                            fontWeight: 'bold'
                        },
                        name: 'text-shape',
                        draggable: true
                    });
                }
                return rect;
            }
        },
        'single-node'
    );
    G6.registerNode(
        'FINISHED',
        {
            drawShape: function (cfg, group) {
                var rect = group.addShape('rect', {
                    attrs: {
                        x: -90,
                        y: -30,
                        width: 120,
                        height: 60,
                        radius: 10,
                        stroke: '#8df192',
                        fill: '#97f59d',
                        lineWidth: 3,
                        opacity: 0.7
                    },
                    name: 'rect-shape',
                    draggable: true
                });
                if (cfg.name) {
                    group.addShape('text', {
                        attrs: {
                            text: cfg.name,
                            x: -30,
                            y: -5,
                            fill: '#01143e',
                            fontSize: 10,
                            textAlign: 'center',
                            textBaseline: 'middle',
                            fontWeight: 'bold'
                        },
                        name: 'text-shape',
                        draggable: true
                    });
                }
                if (cfg.description) {
                    group.addShape('text', {
                        attrs: {
                            text: cfg.description,
                            x: -30,
                            y: 10,
                            fill: 'rgba(52,52,52,0.87)',
                            fontSize: 8,
                            textAlign: 'center',
                            textBaseline: 'middle',
                            fontWeight: 'bold'
                        },
                        name: 'text-shape',
                        draggable: true
                    });
                }
                return rect;
            },
        },
        'single-node'
    );
    G6.registerNode(
        'FAILED',
        {
            drawShape: function (cfg, group) {
                var rect = group.addShape('rect', {
                    attrs: {
                        x: -90,
                        y: -30,
                        width: 120,
                        height: 60,
                        radius: 10,
                        stroke: '#db174f',
                        fill: '#ea2a2a',
                        lineWidth: 3,
                        opacity: 0.7
                    },
                    name: 'rect-shape',
                    draggable: true
                });
                if (cfg.name) {
                    group.addShape('text', {
                        attrs: {
                            text: cfg.name,
                            x: -30,
                            y: -5,
                            fill: '#000000',
                            fontSize: 10,
                            textAlign: 'center',
                            textBaseline: 'middle',
                            fontWeight: 'bold'
                        },
                        name: 'text-shape',
                        draggable: true
                    });
                }
                if (cfg.description) {
                    group.addShape('text', {
                        attrs: {
                            text: cfg.description,
                            x: -30,
                            y: 10,
                            fill: 'rgba(52,52,52,0.87)',
                            fontSize: 8,
                            textAlign: 'center',
                            textBaseline: 'middle',
                            fontWeight: 'bold'
                        },
                        name: 'text-shape',
                        draggable: true
                    });
                }
                return rect;
            }
        },
        'single-node'
    );
    //IE下运行中节点动画有问题
    if (IEVersion() === -1) {
        G6.registerNode(
            'RUNNING',
            {
                drawShape: function (cfg, group) {
                    var rect = group.addShape('rect', {
                        attrs: {
                            x: -90,
                            y: -30,
                            width: 120,
                            height: 60,
                            radius: 10,
                            stroke: '#d9d9d9',
                            fill: '#C6E5FF',
                            lineWidth: 3,
                            opacity: 0.7
                        },
                        name: 'rect-shape',
                        draggable: true
                    });
                    rect.animate(function (ratio) {
                            ratio = -ratio * ratio * 4 + ratio * 4;
                            var begin = [255, 255, 224];
                            var end = [144, 238, 144];
                            var r = begin[0] - ((begin[0] - end[0])) * ratio;
                            var g = begin[1] - ((begin[1] - end[1])) * ratio;
                            var b = begin[2] - ((begin[2] - end[2])) * ratio;
                            var rgba = "rgba(" + r + "," + g + "," + b + ")";
                            return {
                                fill: rgba
                            };
                        },
                        {
                            // 动画重复
                            repeat: true,
                            duration: 2000,
                            easing: 'easeCubic',
                        })
                    if (cfg.name) {
                        group.addShape('text', {
                            attrs: {
                                text: cfg.name,
                                x: -30,
                                y: -5,
                                fill: '#01143e',
                                fontSize: 10,
                                textAlign: 'center',
                                textBaseline: 'middle',
                                fontWeight: 'bold'
                            },
                            name: 'text-shape',
                            draggable: true
                        });
                    }
                    if (cfg.description) {
                        group.addShape('text', {
                            attrs: {
                                text: cfg.description,
                                x: -30,
                                y: 10,
                                fill: 'rgba(52,52,52,0.87)',
                                fontSize: 8,
                                textAlign: 'center',
                                textBaseline: 'middle',
                                fontWeight: 'bold'
                            },
                            name: 'text-shape',
                            draggable: true
                        });
                    }
                    return rect;
                }
            },
            'single-node'
        );
    } else {
        G6.registerNode(
            'RUNNING',
            {
                drawShape: function (cfg, group) {
                    var rect = group.addShape('rect', {
                        attrs: {
                            x: -90,
                            y: -30,
                            width: 120,
                            height: 60,
                            radius: 10,
                            stroke: '#f7b945',
                            fill: '#fefe7a',
                            lineWidth: 3,
                            opacity: 0.7
                        },
                        name: 'rect-shape',
                        draggable: true
                    });
                    if (cfg.name) {
                        group.addShape('text', {
                            attrs: {
                                text: cfg.name,
                                x: -30,
                                y: -5,
                                fill: '#01143e',
                                fontSize: 10,
                                textAlign: 'center',
                                textBaseline: 'middle',
                                fontWeight: 'bold'
                            },
                            name: 'text-shape',
                            draggable: true
                        });
                    }
                    if (cfg.description) {
                        group.addShape('text', {
                            attrs: {
                                text: cfg.description,
                                x: -30,
                                y: 10,
                                fill: 'rgba(52,52,52,0.87)',
                                fontSize: 8,
                                textAlign: 'center',
                                textBaseline: 'middle',
                                fontWeight: 'bold'
                            },
                            name: 'text-shape',
                            draggable: true
                        });
                    }
                    return rect;
                }
            },
            'single-node'
        );
    }


    var container = document.getElementById('main');
    var wid = $("#main").width();
    var heig = 400;
    var graph = new G6.Graph({
        container: container,
        width: wid,
        height: heig,
        fitViewPadding: 30,
        layout: {
            type: 'dagre',
            ranksep: 70,
            nodesep: 40,
            rankdir: 'LR',
            controlPoints: true,
        },
        defaultNode: {
            type: 'default',
        },
        defaultEdge: {
            type: 'polyline',
            style: {
                radius: 20,
                offset: 45,
                endArrow: true,
                lineWidth: 2,
                stroke: '#C2C8D5'
            }
        },
        nodeStateStyles: {
            selected: {
                stroke: '#5b8ff9',
                fill: '#5394ef'
            }
        },
        modes: {
            default: [
                'drag-canvas',
                /*'drag-node',*/
                'zoom-canvas',
                'click-select',
                {
                    type: 'tooltip',
                    formatText: function (model) {
                        var cfg = model.conf;
                        var text = [];
                        cfg.forEach(function (row) {
                            if (row.value !== ("(none)")) {
                                text.push(row.label + ':' + row.value + '<br>');

                            }
                        });
                        return text.join('\n');
                    },
                    offset: 30
                }
            ]
        },
        fitView: 'autoZoom',
        workerEnabled: true
    });
    graph.data(data);
    graph.render();

    graph.on('node:click', function (evt) {
        var states = evt.item._cfg.states
        var flag = false;
        states.forEach(function (state) {
            if (state === 'selected') {
                flag = true;
            }
        })
        clearTimers();
        if (flag) {
            $('#table').bootstrapTable('resetSearch', evt.item._cfg.id)
            $("#table").bootstrapTable("expandRow", 0);
        } else {
            $('#table').bootstrapTable('resetSearch')
        }
    })

    graph.on('canvas:click', function (evt) {
        $('#table').bootstrapTable('resetSearch')
        clearTimers();
    })

    if (typeof window !== 'undefined')
        window.onresize = function () {
            if (!graph || graph.get('destroyed')) return;
            if (!container) return;
            graph.changeSize($("#main").width(), $("#main").height());
            graph.render()
        };

    g = graph
}

//流程图放大
function enlarge() {
    var wight = g.getWidth();
    var height = g.getHeight();
    var zoom = g.getZoom();
    g.zoomTo(zoom + 0.2, {x: wight / 2, y: height / 2});
}

//流程图缩小
function narrow() {
    var wight = g.getWidth();
    var height = g.getHeight();
    var zoom = g.getZoom();
    g.zoomTo(zoom - 0.2, {x: wight / 2, y: height / 2});
}

//流程图刷新
function flow_refresh() {
    g.changeSize($("#main").width(), $("#main").height());
    g.render();
    $('#table').bootstrapTable('resetSearch');
    clearTimers();
}

//流程图画布增加高度
function toDown() {
    var height = 600;
    $("#main").css("height", height)
    $("#demo-panel-flow-down").css("display", "none")
    $("#demo-panel-flow-up").css("display", "")

    g.changeSize($("#main").width(), height);
    g.render()
    $('#table').bootstrapTable('resetSearch')
    clearTimers();
}

//流程图画布减少高度
function toUp() {
    var height = 400;
    $("#main").css("height", height)
    $("#demo-panel-flow-down").css("display", "")
    $("#demo-panel-flow-up").css("display", "none")

    g.changeSize($("#main").width(), height);
    g.render()
    $('#table').bootstrapTable('resetSearch')
    clearTimers();
}

//显示异常信息
function showExceptions() {

    function retryCallback() {
        var xhr;

        // 设置5秒超时定时器
        var timer = setTimeout(function () {
            // 中断上一个请求
            xhr.abort();
            // 超时重试
            retryCallback();
        }, 5000)

        xhr = $.ajax({
            type: 'get',
            url: flinkServer + GetJobId() + "/exceptions",
            success: function (data, status) {
                //能进来说明请求成功，不再重试
                clearTimeout(timer)
                if (data['all-exceptions'].length <= 0) {
                    $("#exceptions").parent().hide();
                    return;
                }
                $("#exceptions").parent().hide();

                function showExcetion(i) {
                    if (i == 0) {
                        return "in";
                    } else {
                        return "";
                    }
                }

                for (var i = 0; i < data['all-exceptions'].length; i++) {
                    $("#exceptions").append(
                        '<div class="panel panel-pink panel-colorful">' +
                        '<div class="panel-heading"><h4 class="panel-title">' +
                        '<a data-parent="#exceptions" data-toggle="collapse" href="#exception' + i + '">Exceptions: ' +
                        data['all-exceptions'][i]['task'] +
                        '<span class="pad-lft" style="float: right">' +
                        timeStamp2String(data['all-exceptions'][i]['timestamp']) +
                        '</span><span class="pad-lft" style="float: right">localhost:41291</span></a></h4></div>' +
                        '<div class="panel-collapse collapse ' + showExcetion(i) + '" id="exception' + i + '"><div class="panel-body">' +
                        '<pre class="precss">' +
                        data['all-exceptions'][i]['exception'] +
                        '</pre></div></div>'
                    )
                }

            }
        })
    }

    retryCallback();

}

//初始化表格
function initTable() {
    $('#table').bootstrapTable({
        striped: true,                      //是否显示行间隔色
        cache: false,                       //是否使用缓存，默认为true，所以一般情况下需要设置一下这个属性（*）
        pagination: false,                   //是否显示分页（*）
        /*sidePagination: "client",           //分页方式：client客户端分页，server服务端分页（*）
        pageNumber: 1,                      //初始化加载第一页，默认第一页
        pageSize: 5,                        //每页的记录行数（*）
        pageList: [5, 10, 20],              //可供选择的每页的行数（*）*/
        search: true,                       //是否显示表格搜索，此搜索是客户端搜索，不会进服务端
        showRefresh: true,                  //是否显示刷新按钮
        minimumCountColumns: 2,             //最少允许的列数
        clickToSelect: false,                //是否启用点击选中行
        /*onClickRow: function (item, $element) {
            var index = $element.data('index')
            for (var i = 0; i < rows.length; i++) {
                if (rows[i] === index) {
                    var slice = rows.splice(i, i + 1);
                    $("#table").bootstrapTable("collapseRow", slice);
                    return;
                }
            }
            rows.push(index)
            $("#table").bootstrapTable("expandRow", index);
        },*/
        uniqueId: "id",                     //每一行的唯一标识，一般为主键列
        showToggle: false,                  //是否显示详细视图和列表视图的切换按钮
        showColumns: true,
        cardView: false,                    //是否显示详细视图
        detailView: true,                   //是否显示父子表
        columns: [{
            field: 'id',
            title: 'id',
            visible: false
        }, {
            field: 'start-time',
            title: 'Start time'
        }, {
            field: 'end-time',
            title: 'End time'
        }, {
            field: 'duration',
            title: 'Duration'
        }, {
            field: 'description',
            title: 'Name',
            align: 'left'
        }, {
            field: 'read-bytes',
            title: 'Bytes received'
        }, {
            field: 'read-records',
            title: 'Records received'
        }, {
            field: 'write-bytes',
            title: 'Bytes sent'
        }, {
            field: 'write-records',
            title: 'Records sent'
        }, {
            field: 'parallelism',
            title: 'Parallelism',
            sortable: true
        }, {
            field: 'tasks',
            title: 'Tasks',
            formatter: taskFormatter
        }, {
            field: 'status',
            title: 'Status',
            align: 'center',
            formatter: statusFormatter
        }],
        onExpandRow: function (index, row, $detail) {
            var temp = [];
            for (var i = 0; i < row.parallelism; i++) {
                temp.push({
                    'host': '-',
                    'status': '-',
                    'duration': '-',
                    'start-time': '-',
                    'end-time': '-',
                    'read-bytes': '-',
                    'write-bytes': '-',
                    'read-records': '-',
                    'write-records': '-'
                });
            }
            var cur_table = $detail.html('<table></table>').find('table');
            $(cur_table).bootstrapTable({
                data: temp,
                contentType: 'application/json;charset=UTF-8',
                dataType: 'json',
                clickToSelect: true,
                detailView: false,//父子表
                pageSize: 10,
                pageList: [10, 20],
                columns: [{
                    field: 'start-time',
                    title: 'Start time'
                }, {
                    field: 'end-time',
                    title: 'End time'
                }, {
                    field: 'duration',
                    title: 'Duration'
                }, {
                    field: 'read-bytes',
                    title: 'Bytes received'
                }, {
                    field: 'read-records',
                    title: 'Records received'
                }, {
                    field: 'write-bytes',
                    title: 'Bytes sent'
                }, {
                    field: 'write-records',
                    title: 'Records received'
                }, {
                    field: 'host',
                    title: 'Host'
                }, {
                    field: 'status',
                    title: 'Status',
                    formatter: statusFormatter
                }]
            });
            var url = flinkServer + GetJobId() + "/vertices/" + row.id;

            function fltable(data) {
                var jsons = [];
                data.subtasks.forEach(function (task) {
                    jsons.push({
                        'host': task.host,
                        'status': task.status,
                        'duration': duration2String(task.duration),
                        'start-time': timeStamp2String(task['start-time']),
                        'end-time': timeStamp2String(task['end-time']),
                        'read-bytes': bytesToSize(task['metrics']['read-bytes']),
                        'write-bytes': bytesToSize(task['metrics']['write-bytes']),
                        'read-records': toThousands(task['metrics']['read-records']),
                        'write-records': toThousands(task['metrics']['write-records'])
                    });
                })
                var chilren = $(cur_table).children("tbody").children()
                for (var j = 0; j < chilren.length; j++) {
                    var index = $(chilren).eq(j).attr("data-index");
                    if (!($(chilren).eq(j).children().eq(0).text() === jsons[index]['start-time'])) {
                        $(chilren).eq(j).children().eq(0).text(jsons[index]['start-time'])
                    }
                    if (!($(chilren).eq(j).children().eq(1).text() === jsons[index]['end-time'])) {
                        $(chilren).eq(j).children().eq(1).text(jsons[index]['end-time'])
                    }
                    if (!($(chilren).eq(j).children().eq(2).text() === jsons[index]['duration'])) {
                        $(chilren).eq(j).children().eq(2).text(jsons[index]['duration'])
                    }
                    if (!($(chilren).eq(j).children().eq(3).text() === jsons[index]['read-bytes'])) {
                        $(chilren).eq(j).children().eq(3).text(jsons[index]['read-bytes'])
                    }
                    if (!($(chilren).eq(j).children().eq(4).text() === jsons[index]['read-records'])) {
                        $(chilren).eq(j).children().eq(4).text(jsons[index]['read-records'])
                    }
                    if (!($(chilren).eq(j).children().eq(5).text() === jsons[index]['write-bytes'])) {
                        $(chilren).eq(j).children().eq(5).text(jsons[index]['write-bytes'])
                    }
                    if (!($(chilren).eq(j).children().eq(6).text() === jsons[index]['write-records'])) {
                        $(chilren).eq(j).children().eq(6).text(jsons[index]['write-records'])
                    }
                    if (!($(chilren).eq(j).children().eq(7).text() === jsons[index]['host'])) {
                        $(chilren).eq(j).children().eq(7).text(jsons[index]['host'])
                    }
                    if (!($(chilren).eq(j).children().eq(8).text() === jsons[index]['status'])) {
                        $(chilren).eq(j).children().eq(8).html(statusFormatter(jsons[index]['status'], null))
                    }
                }
            }

            $.getJSON(url, function (data, status) {
                fltable(data);
                if (row.status !== "FINISHED" && row.status !== "FAILED") {
                    var timer = setInterval(function () {
                        $.getJSON(url, function (data, status) {
                            fltable(data);
                        });
                    }, 500)
                    expended[row.id] = timer;
                }

            });

        },
        onCollapseRow: function (index, row, $detail) {
            if (expended[row.id]) {
                clearInterval(expended[row.id]);
                expended[row.id] = null;
            }
        }
    });
}

//填充表格
function appendtable(vertices) {
    vertices.forEach(function (vertice) {
        var row = {
            'id': vertice.id,
            'start-time': timeStamp2String(vertice['start-time']),
            'end-time': vertice['end-time'] > 0 ? timeStamp2String(vertice['end-time']) : "-",
            'duration': duration2String(vertice.duration),
            'description': vertice.name,
            'write-bytes': bytesToSize(vertice['metrics']['write-bytes']),
            'read-bytes': bytesToSize(vertice['metrics']['read-bytes']),
            'write-records': toThousands(vertice['metrics']['write-records']),
            'read-records': toThousands(vertice['metrics']['read-records']),
            'parallelism': vertice.parallelism,
            'tasks': vertice.tasks,
            'status': vertice.status
        };

        $('#table').bootstrapTable('append', row);
    });
}

//格式化状态图标
function statusFormatter(value, row) {
    var labelColor;
    var text;
    if (value === "FINISHED") {
        labelColor = "success";
        text = "FINISHED";
    } else if (value === "FAILED") {
        labelColor = "danger";
        text = "FAIL";
    } else if (value === "RUNNING") {
        labelColor = "warning";
        text = "RUNNING";
    } else {
        labelColor = "default";
        text = "WAITING";
    }
    return '<div class="label label-table label-' + labelColor + '"> ' + text + '</div>';
}

//格式化子任务数样式
function taskFormatter(value, row) {

    var prepare = 0;
    prepare += value['RECONCILING']
    prepare += value['DEPLOYING']
    prepare += value['CANCELED']
    prepare += value['SCHEDULED']
    prepare += value['CANCELING']
    prepare += value['CREATED']

    var ret = '';
    ret += '<span style="padding: 2px;margin-left: 2px;text-align: center" data-toggle="tooltip" title="Waiting" class="label label-default">' + prepare + '</span>';
    ret += '<span style="padding: 2px;margin-left: 2px;text-align: center" data-toggle="tooltip" title="Running" class="label label-warning">' + value['RUNNING'] + '</span>';
    ret += '<span style="padding: 2px;margin-left: 2px;text-align: center" data-toggle="tooltip" title="Finish" class="label label-success">' + value['FINISHED'] + '</span>';
    ret += '<span style="padding: 2px;margin-left: 2px;text-align: center" data-toggle="tooltip" title="Fail" class="label label-danger">' + value['FAILED'] + '</span>';
    return ret;
}

//任务耗时字符串化
function duration2String(time) {
    if (time < 0) {
        return "-ms";
    } else if (time >= 0 && time < 1000) {
        return time + "ms";
    } else if (time >= 1000 && time < 60000) {
        return Math.floor(time / 1000) + "s" + time % 1000 + "ms";
    } else if (time >= 60000 && time < 3600000) {
        time = Math.floor(time / 1000);
        return Math.floor(time / 60) + "min" + time % 60 + "s";
    } else {
        time = Math.floor(time / 60000);
        return Math.floor(time / 60) + "hour" + time % 60 + "min";
    }

}

//在Jquery里格式化Date日期时间数据
function timeStamp2String(time) {
    var datetime = new Date();
    datetime.setTime(time);

    var month = datetime.getMonth() + 1 < 10 ? "0" + (datetime.getMonth() + 1) : datetime.getMonth() + 1;
    var date = datetime.getDate() < 10 ? "0" + datetime.getDate() : datetime.getDate();
    var hour = datetime.getHours() < 10 ? "0" + datetime.getHours() : datetime.getHours();
    var minute = datetime.getMinutes() < 10 ? "0" + datetime.getMinutes() : datetime.getMinutes();
    var second = datetime.getSeconds() < 10 ? "0" + datetime.getSeconds() : datetime.getSeconds();
    return month + "-" + date + " " + hour + ":" + minute + ":" + second;
}

//字节转字符串
function bytesToSize(bytes) {
    if (bytes === 0) return '0 B';
    var k = 1024;
    sizes = ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];
    i = Math.floor(Math.log(bytes) / Math.log(k))
    return (bytes / Math.pow(k, i)).toPrecision(3) + ' ' + sizes[i];
    //toPrecision(3) 后面保留两位小数，如1.00GB
}

//数字加逗号:1,000
function toThousands(num) {
    return (num || 0).toString().replace(/(\d)(?=(?:\d{3})+$)/g, '$1,');
}

//获取地址栏#号后值
function GetJobId() {
    var str = location.href
    var num = str.indexOf("#");
    str = str.substr(num + 2);
    return str;
}

//切换经典模式
function changeMode() {
    var str = location.href
    var split = str.split("?");
    var index = split[0].lastIndexOf("/") + 1;
    var url = split[0].substr(0, index);
    $("#changeMode").attr("href", url + "i_nosidebar.html?" + split[1]);
    $("#changeMode").attr("target", "_blank");
}

//定时器更新流程图和进度条
function setupInterval(data, nodes) {
    if (data.state !== "FINISHED" && data.state !== "FAILED") {
        var interval = setInterval(function () {
            if (g) {
                $.getJSON(flinkServer + GetJobId(), function (data, status) {
                    var verticeMap = data.vertices.reduce(function (acc, el, i) {
                        acc[el.id] = i;
                        return acc;
                    }, {});

                    var idMapping = nodes.reduce(function (map, el, i) {
                        map[el.id] = i;
                        return map;
                    }, {});

                    data.plan.nodes.forEach(function (node) {

                        var vertice = data.vertices[verticeMap[node.id]];
                        var status;
                        if (vertice.status === "FINISHED" || vertice.status === "RUNNING" || vertice.status === "FAILED") {
                            status = vertice.status;
                        } else {
                            status = "default";
                        }
                        var temp = nodes[idMapping[node.id]];
                        if (temp.type !== status) {
                            temp.type = status;
                            temp.conf = [
                                {
                                    label: 'id',
                                    value: node.id,
                                },
                                {
                                    label: 'operator_strategy',
                                    value: node.operator_strategy,
                                },
                                {
                                    label: 'Status',
                                    value: vertice.status,
                                },
                                {
                                    label: 'Parallelism',
                                    value: vertice.parallelism,
                                },
                            ]
                            g.update(node.id, temp);

                        }

                        var chilren = $("#table").children("tbody").children()
                        //遍历父表行
                        for (var j = 0; j < chilren.length; j++) {
                            var rowid = $(chilren).eq(j).attr("data-uniqueid");
                            if (rowid === node.id) {
                                var row = {
                                    'id': vertice.id,
                                    'start-time': timeStamp2String(vertice['start-time']),
                                    'end-time': vertice['end-time'] > 0 ? timeStamp2String(vertice['end-time']) : "-",
                                    'duration': duration2String(vertice.duration),
                                    'description': vertice.name,
                                    'read-bytes': bytesToSize(vertice['metrics']['read-bytes']),
                                    'read-records': toThousands(vertice['metrics']['read-records']),
                                    'write-bytes': bytesToSize(vertice['metrics']['write-bytes']),
                                    'write-records': toThousands(vertice['metrics']['write-records']),
                                    'parallelism': vertice.parallelism,
                                    'tasks': vertice.tasks,
                                    'status': vertice.status
                                };
                                if ($(chilren).eq(j).children().eq(-1).text() !== row.status) {
                                    $(chilren).eq(j).children().eq(-1).html(statusFormatter(row.status, null))
                                }
                                if ($(chilren).eq(j).children().eq(-2).text() !== row.tasks) {
                                    $(chilren).eq(j).children().eq(-2).html(taskFormatter(row.tasks, null))
                                }
                                if ($(chilren).eq(j).children().eq(-3).text() !== row.parallelism) {
                                    $(chilren).eq(j).children().eq(-3).text(row.parallelism)
                                }
                                if ($(chilren).eq(j).children().eq(-4).text() !== row['write-records']) {
                                    $(chilren).eq(j).children().eq(-4).text(row['write-records'])
                                }
                                if ($(chilren).eq(j).children().eq(-5).text() !== row['write-bytes']) {
                                    $(chilren).eq(j).children().eq(-5).text(row['write-bytes'])
                                }
                                if ($(chilren).eq(j).children().eq(-6).text() !== row['read-records']) {
                                    $(chilren).eq(j).children().eq(-6).text(row['read-records'])
                                }
                                if ($(chilren).eq(j).children().eq(-7).text() !== row['read-bytes']) {
                                    $(chilren).eq(j).children().eq(-7).text(row['read-bytes'])
                                }
                                if ($(chilren).eq(j).children().eq(-8).text() !== row.description) {
                                    $(chilren).eq(j).children().eq(-8).text(row.description)
                                }
                                if ($(chilren).eq(j).children().eq(-9).text() !== row.duration) {
                                    $(chilren).eq(j).children().eq(-9).text(row.duration)
                                }
                                if ($(chilren).eq(j).children().eq(-10).text() !== row['end-time']) {
                                    $(chilren).eq(j).children().eq(-10).text(row['end-time'])
                                }
                                if ($(chilren).eq(j).children().eq(-11).text() !== row['start-time']) {
                                    $(chilren).eq(j).children().eq(-11).text(row['start-time'])
                                }
                            }

                        }

                    });
                    if (data.state === "FINISHED" || data.state === "FAILED") {
                        clearInterval(interval)
                    }
                });
            }
            $.getJSON(flinkServer + GetJobId() + "/progress", function (data, status) {
                flProgress(data);
            });
        }, 1000);
    }
}

//刷新进度条
function flProgress(cur) {
    if (cur > 100 || cur < 0) {
        return;
    }
    var start = $("#progress-span").text();

    start = parseInt(start.substr(0, start.length - 1));
    if (cur == start) {
        return;
    }
    var percentage = parseInt(start);
    var step = (cur - start) / 10;
    var interval = setInterval(function () {
        percentage = percentage + step;
        var widthTemp = percentage.toFixed(2) + '%';
        if ((step > 0 && percentage < cur) || (step < 0 && percentage > cur)) {
            $("#progress-bar").css('width', widthTemp);
            $("#progress-span").text(percentage.toFixed(0) + '%');
        } else {
            clearInterval(interval);
            widthTemp = cur + '%';
            $("#progress-bar").css('width', widthTemp);
            $("#progress-span").text(widthTemp);
        }
    }, 10)
}

//设置进度条
function setProgress(cur) {

    $("#progress-bar").css('width', cur + '%');
    $("#progress-span").text(cur + '%');

}

//清除所有定时器
function clearTimers() {
    var keys = Object.keys(expended);
    keys.forEach(function (key) {
        clearInterval(expended[key]);
        expended[key] = null;
    })
}

//判断是否为ie浏览器
function IEVersion() {
    var userAgent = navigator.userAgent; //取得浏览器的userAgent字符串
    var isIE = userAgent.indexOf("compatible") > -1 && userAgent.indexOf("MSIE") > -1; //判断是否IE<11浏览器
    var isEdge = userAgent.indexOf("Edge") > -1 && !isIE; //判断是否IE的Edge浏览器
    var isIE11 = userAgent.indexOf('Trident') > -1 && userAgent.indexOf("rv:11.0") > -1;
    if (isIE) {
        var reIE = new RegExp("MSIE (\\d+\\.\\d+);");
        reIE.test(userAgent);
        var fIEVersion = parseFloat(RegExp["$1"]);
        if (fIEVersion == 7) {
            return 7;
        } else if (fIEVersion == 8) {
            return 8;
        } else if (fIEVersion == 9) {
            return 9;
        } else if (fIEVersion == 10) {
            return 10;
        } else {
            return 6;//IE版本<=7
        }
    } else if (isEdge) {
        return 'edge';//edge
    } else if (isIE11) {
        return 11; //IE11
    } else {
        return -1;//不是ie浏览器
    }
}
